/*
 * Decompiled with CFR 0.152.
 */
package com.startechnology.start_core.item;

import com.google.common.base.Preconditions;
import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.FluidPipeProperties;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.PropertyKey;
import com.gregtechceu.gtceu.api.data.chemical.material.stack.ItemMaterialInfo;
import com.gregtechceu.gtceu.api.data.chemical.material.stack.MaterialStack;
import com.gregtechceu.gtceu.api.item.ComponentItem;
import com.gregtechceu.gtceu.api.item.IComponentItem;
import com.gregtechceu.gtceu.api.item.component.IItemComponent;
import com.gregtechceu.gtceu.api.item.component.ThermalFluidStats;
import com.gregtechceu.gtceu.common.data.GTItems;
import com.gregtechceu.gtceu.common.data.GTMaterials;
import com.gregtechceu.gtceu.common.item.DataItemBehavior;
import com.gregtechceu.gtceu.common.item.ItemFluidContainer;
import com.gregtechceu.gtceu.common.item.TooltipBehavior;
import com.gregtechceu.gtceu.utils.FormattingUtil;
import com.startechnology.start_core.StarTCore;
import com.startechnology.start_core.item.StarTBacteriaItems;
import com.startechnology.start_core.item.components.StarTDreamCopyBehaviour;
import com.tterrag.registrate.builders.ItemBuilder;
import com.tterrag.registrate.providers.ProviderType;
import com.tterrag.registrate.util.entry.ItemEntry;
import com.tterrag.registrate.util.nullness.NonNullBiConsumer;
import com.tterrag.registrate.util.nullness.NonNullConsumer;
import net.minecraft.network.chat.Component;

public class StarTItems {
    public static final ItemEntry<ComponentItem> TOOL_DATA_DNA_DISK = ((ItemBuilder)((ItemBuilder)StarTCore.START_REGISTRATE.item("data_dna_disk", ComponentItem::create).lang("Data DNA Disk").onRegister(StarTItems.attach((IItemComponent)new DataItemBehavior(true)))).onRegister(StarTItems.attach((IItemComponent)new TooltipBehavior(lines -> lines.add(Component.m_237115_((String)"item.start_core.data_dna_disk.tooltip")))))).register();
    public static final ItemEntry<ComponentItem> TOOL_COMPONENT_DATA_CORE = ((ItemBuilder)((ItemBuilder)StarTCore.START_REGISTRATE.item("component_data_core", ComponentItem::create).lang("Component Data Core").onRegister(StarTItems.attach((IItemComponent)new DataItemBehavior(true)))).onRegister(StarTItems.attach((IItemComponent)new TooltipBehavior(lines -> lines.add(Component.m_237115_((String)"item.start_core.component_data_core.tooltip")))))).register();
    public static final ItemEntry<ComponentItem> TOOL_DREAM_COPY_ITEM = ((ItemBuilder)((ItemBuilder)StarTCore.START_REGISTRATE.item("lucinducer", ComponentItem::create).lang("Lucinducer").onRegister(StarTItems.attach((IItemComponent)new StarTDreamCopyBehaviour()))).onRegister(StarTItems.attach((IItemComponent)new TooltipBehavior(lines -> lines.add(Component.m_237115_((String)"item.start_core.lucinducer.tooltip")))))).register();
    public static ItemEntry<ComponentItem> FLUID_CELL_LARGE_ENRICHED_NAQUADAH = StarTItems.createFluidCell(GTMaterials.NaquadahEnriched, 768, 12, 16, true, true, false);
    public static ItemEntry<ComponentItem> FLUID_CELL_LARGE_NEUTRONIUM = StarTItems.createFluidCell(GTMaterials.Neutronium, 1024, 16, 8, true, true, true);

    public static <T extends IComponentItem> NonNullConsumer<T> attach(IItemComponent components) {
        return item -> item.attachComponents(new IItemComponent[]{components});
    }

    public static ItemEntry<ComponentItem> createFluidCell(Material mat, int capacity, int matSize, int stackSize, boolean acidProof, boolean cryoProof, boolean plasmaProof) {
        FluidPipeProperties prop = (FluidPipeProperties)mat.getProperty(PropertyKey.FLUID_PIPE);
        Preconditions.checkArgument((prop != null ? 1 : 0) != 0, (String)"Material { %s } does not have Fluid Pipe properties, but is being used to create a Fluid Cell", (Object)mat.getName());
        return ((ItemBuilder)((ItemBuilder)((ItemBuilder)StarTCore.START_REGISTRATE.item("%s_fluid_cell".formatted(mat.getName()), ComponentItem::create).lang("%s " + FormattingUtil.toEnglishName((Object)mat.getName()) + " Cell").color(() -> GTItems::cellColor).setData(ProviderType.ITEM_MODEL, NonNullBiConsumer.noop())).properties(p -> p.m_41487_(stackSize)).onRegister(GTItems.attach((IItemComponent[])new IItemComponent[]{GTItems.cellName(), ThermalFluidStats.create((int)(1000 * capacity), (int)prop.getMaxFluidTemperature(), (boolean)true, (boolean)acidProof, (boolean)cryoProof, (boolean)plasmaProof, (boolean)true), new ItemFluidContainer()}))).onRegister(GTItems.materialInfo((ItemMaterialInfo)new ItemMaterialInfo(new MaterialStack[]{new MaterialStack(mat, 3628800L * (long)matSize)})))).register();
    }

    public static void init() {
        StarTBacteriaItems.init();
    }
}

