/*
 * Decompiled with CFR 0.152.
 */
package com.startechnology.start_core.integration.jade.provider;

import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.api.blockentity.MetaMachineBlockEntity;
import com.gregtechceu.gtceu.api.capability.recipe.FluidRecipeCapability;
import com.gregtechceu.gtceu.api.capability.recipe.ItemRecipeCapability;
import com.gregtechceu.gtceu.api.capability.recipe.RecipeCapability;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.api.machine.steam.SimpleSteamMachine;
import com.gregtechceu.gtceu.api.recipe.GTRecipe;
import com.gregtechceu.gtceu.api.recipe.RecipeHelper;
import com.gregtechceu.gtceu.api.recipe.chance.boost.ChanceBoostFunction;
import com.gregtechceu.gtceu.api.recipe.content.Content;
import com.gregtechceu.gtceu.api.recipe.ingredient.FluidIngredient;
import com.gregtechceu.gtceu.client.util.TooltipHelper;
import com.gregtechceu.gtceu.common.machine.multiblock.steam.SteamParallelMultiblockMachine;
import com.gregtechceu.gtceu.integration.jade.GTElementHelper;
import com.gregtechceu.gtceu.integration.jade.provider.CapabilityBlockProvider;
import com.gregtechceu.gtceu.utils.FormattingUtil;
import com.gregtechceu.gtceu.utils.GTUtil;
import com.startechnology.start_core.StarTCore;
import com.startechnology.start_core.api.capability.StarTCapabilityHelper;
import com.startechnology.start_core.machine.threading.StarTThreadingCapableMachine;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentUtils;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.Nullable;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.ITooltip;
import snownee.jade.api.config.IPluginConfig;
import snownee.jade.api.fluid.JadeFluidObject;
import snownee.jade.api.ui.BoxStyle;
import snownee.jade.api.ui.IBoxStyle;
import snownee.jade.api.ui.IElementHelper;
import snownee.jade.util.FluidTextHelper;

public class StarTThreadedRecipeProvider
extends CapabilityBlockProvider<StarTThreadingCapableMachine> {
    public StarTThreadedRecipeProvider() {
        super(StarTCore.resourceLocation("threading_recipes"));
    }

    @Nullable
    protected StarTThreadingCapableMachine getCapability(Level level, BlockPos pos, @Nullable Direction side) {
        StarTThreadingCapableMachine capability = StarTCapabilityHelper.getThreadingCapableMachine(level, pos, side);
        if (capability != null) {
            return capability;
        }
        return null;
    }

    protected void write(CompoundTag data, StarTThreadingCapableMachine capability) {
        int threadIndex = 0;
        for (StarTThreadingCapableMachine.ThreadedRecipeExecution threadExecutionContext : capability.getActiveThreads()) {
            Object item2;
            GTRecipe recipe = threadExecutionContext.recipe;
            String threadPrefix = "thread_" + threadIndex;
            if (recipe == null) continue;
            int recipeTier = RecipeHelper.getPreOCRecipeEuTier((GTRecipe)recipe);
            int chanceTier = recipeTier + recipe.ocLevel;
            ChanceBoostFunction function = recipe.getType().getChanceFunction();
            List itemContents = recipe.getOutputContents((RecipeCapability)ItemRecipeCapability.CAP);
            List fluidContents = recipe.getOutputContents((RecipeCapability)FluidRecipeCapability.CAP);
            ListTag itemTags = new ListTag();
            for (Object item2 : itemContents) {
                ItemStack[] stacks = ((Ingredient)ItemRecipeCapability.CAP.of(((Content)item2).content)).m_43908_();
                if (stacks.length == 0 || stacks[0].m_41619_()) continue;
                ItemStack stack = stacks[0];
                CompoundTag itemTag = new CompoundTag();
                GTUtil.saveItemStack((ItemStack)stack, (CompoundTag)itemTag);
                if (((Content)item2).chance < ((Content)item2).maxChance) {
                    int count = stack.m_41613_();
                    double countD = (double)count * (double)recipe.parallels * (double)function.getBoostedChance((Content)item2, recipeTier, chanceTier) / (double)((Content)item2).maxChance;
                    count = countD < 1.0 ? 1 : (int)Math.round(countD);
                    itemTag.m_128405_("Count", count);
                }
                itemTags.add((Object)itemTag);
            }
            if (!itemTags.isEmpty()) {
                data.m_128365_(threadPrefix + "OutputItems", (Tag)itemTags);
            }
            ListTag fluidTags = new ListTag();
            item2 = fluidContents.iterator();
            while (item2.hasNext()) {
                Content fluid = (Content)item2.next();
                FluidStack[] stacks = ((FluidIngredient)FluidRecipeCapability.CAP.of(fluid.content)).getStacks();
                if (stacks.length == 0 || stacks[0].isEmpty()) continue;
                FluidStack stack = stacks[0];
                CompoundTag fluidTag = new CompoundTag();
                stack.writeToNBT(fluidTag);
                if (fluid.chance < fluid.maxChance) {
                    int amount = stack.getAmount();
                    double amountD = (double)amount * (double)recipe.parallels * (double)function.getBoostedChance(fluid, recipeTier, chanceTier) / (double)fluid.maxChance;
                    amount = amountD < 1.0 ? 1 : (int)Math.round(amountD);
                    fluidTag.m_128405_("Amount", amount);
                }
                fluidTags.add((Object)fluidTag);
            }
            if (!fluidTags.isEmpty()) {
                data.m_128365_(threadPrefix + "OutputFluids", (Tag)fluidTags);
            }
            long EUt = RecipeHelper.getInputEUt((GTRecipe)recipe);
            boolean isInput = true;
            if (EUt == 0L) {
                isInput = false;
                EUt = RecipeHelper.getOutputEUt((GTRecipe)recipe);
            }
            data.m_128356_(threadPrefix + "EUt", EUt);
            data.m_128379_(threadPrefix + "isInput", isInput);
            data.m_128379_(threadPrefix + "isWorking", threadExecutionContext.isWorking);
            data.m_128405_(threadPrefix + "Progress", threadExecutionContext.totalDuration - threadExecutionContext.ticksRemaining);
            data.m_128405_(threadPrefix + "MaxProgress", threadExecutionContext.totalDuration);
            ++threadIndex;
        }
        data.m_128405_("thread_amount", threadIndex);
    }

    protected void addTooltip(CompoundTag capData, ITooltip tooltip, Player player, BlockAccessor block, BlockEntity blockEntity, IPluginConfig config) {
        int threadAmount = capData.m_128451_("thread_amount");
        for (int i = 0; i < threadAmount; ++i) {
            ListTag itemTags;
            tooltip.add((Component)Component.m_237110_((String)"start_core.machine.threading_controller.jade_thread_header", (Object[])new Object[]{Component.m_237113_((String)FormattingUtil.formatNumbers((int)(i + 1))).m_130940_(ChatFormatting.GOLD)}));
            String threadPrefix = "thread_" + i;
            int currentProgress = capData.m_128451_(threadPrefix + "Progress");
            int maxProgress = capData.m_128451_(threadPrefix + "MaxProgress");
            MutableComponent text = maxProgress < 20 ? Component.m_237110_((String)"gtceu.jade.progress_tick", (Object[])new Object[]{currentProgress, maxProgress}) : Component.m_237110_((String)"gtceu.jade.progress_sec", (Object[])new Object[]{Math.round((float)currentProgress / 20.0f), Math.round((float)maxProgress / 20.0f)});
            if (maxProgress > 0) {
                int color = StarTThreadedRecipeProvider.generateThreadColor(i);
                tooltip.add(tooltip.getElementHelper().progress(this.getProgress(currentProgress, maxProgress), (Component)text, tooltip.getElementHelper().progressStyle().color(color).textColor(-1), (IBoxStyle)Util.m_137469_((Object)BoxStyle.DEFAULT, style -> {
                    style.borderColor = -11184811;
                }), true));
            }
            long EUt = capData.m_128454_(threadPrefix + "EUt");
            boolean isWorking = capData.m_128471_(threadPrefix + "isWorking");
            boolean isInput = capData.m_128471_(threadPrefix + "isInput");
            boolean isSteam = false;
            if (blockEntity instanceof MetaMachineBlockEntity) {
                MetaMachineBlockEntity mbe = (MetaMachineBlockEntity)blockEntity;
                MetaMachine machine = mbe.getMetaMachine();
                if (machine instanceof SimpleSteamMachine) {
                    SimpleSteamMachine ssm = (SimpleSteamMachine)machine;
                    EUt = (long)((double)EUt * ssm.getConversionRate());
                    isSteam = true;
                } else if (machine instanceof SteamParallelMultiblockMachine) {
                    SteamParallelMultiblockMachine smb = (SteamParallelMultiblockMachine)machine;
                    EUt = (long)((double)EUt * smb.getConversionRate());
                    isSteam = true;
                }
            }
            if (EUt > 0L && isWorking) {
                if (isSteam) {
                    text = Component.m_237113_((String)FormattingUtil.formatNumbers((long)EUt)).m_130940_(ChatFormatting.GREEN).m_7220_((Component)Component.m_237113_((String)" mB/t").m_130940_(ChatFormatting.RESET));
                } else {
                    byte tier = GTUtil.getOCTierByVoltage((long)EUt);
                    text = Component.m_237113_((String)FormattingUtil.formatNumbers((long)EUt)).m_130940_(ChatFormatting.RED).m_7220_((Component)Component.m_237113_((String)" EU/t").m_130940_(ChatFormatting.RESET).m_7220_((Component)Component.m_237113_((String)" (").m_130940_(ChatFormatting.GREEN)));
                    if (tier < GTValues.TIER_COUNT) {
                        text = text.m_7220_((Component)Component.m_237113_((String)GTValues.VNF[tier]).m_130938_(style -> style.m_178520_(GTValues.VC[tier])));
                    } else {
                        int speed = tier - 14;
                        text = text.m_7220_((Component)Component.m_237113_((String)"MAX").m_130938_(style -> style.m_131148_(TooltipHelper.rainbowColor((float)speed))).m_7220_((Component)Component.m_237113_((String)"+").m_130938_(style -> style.m_178520_(GTValues.VC[speed])).m_7220_((Component)Component.m_237113_((String)FormattingUtil.formatNumbers((int)(tier - 14)))).m_130938_(style -> style.m_178520_(GTValues.VC[speed]))));
                    }
                    text = text.m_7220_((Component)Component.m_237113_((String)")").m_130940_(ChatFormatting.GREEN));
                }
                if (isInput) {
                    tooltip.add((Component)Component.m_237115_((String)"gtceu.top.energy_consumption").m_130946_(" ").m_7220_((Component)text));
                } else {
                    tooltip.add((Component)Component.m_237115_((String)"gtceu.top.energy_production").m_130946_(" ").m_7220_((Component)text));
                }
            }
            ArrayList<ItemStack> outputItems = new ArrayList<ItemStack>();
            if (capData.m_128425_(threadPrefix + "OutputItems", 9) && !(itemTags = capData.m_128437_(threadPrefix + "OutputItems", 10)).isEmpty()) {
                for (Tag tag : itemTags) {
                    CompoundTag tCompoundTag;
                    ItemStack stack;
                    if (!(tag instanceof CompoundTag) || (stack = GTUtil.loadItemStack((CompoundTag)(tCompoundTag = (CompoundTag)tag))).m_41619_()) continue;
                    outputItems.add(stack);
                }
            }
            ArrayList<FluidStack> outputFluids = new ArrayList<FluidStack>();
            if (capData.m_128425_(threadPrefix + "OutputFluids", 9)) {
                ListTag fluidTags = capData.m_128437_(threadPrefix + "OutputFluids", 10);
                for (Tag tag : fluidTags) {
                    CompoundTag tCompoundTag;
                    FluidStack stack;
                    if (!(tag instanceof CompoundTag) || (stack = FluidStack.loadFluidStackFromNBT((CompoundTag)(tCompoundTag = (CompoundTag)tag))).isEmpty()) continue;
                    outputFluids.add(stack);
                }
            }
            if (!outputItems.isEmpty() || !outputFluids.isEmpty()) {
                tooltip.add((Component)Component.m_237115_((String)"gtceu.top.recipe_output"));
            }
            this.addItemTooltips(tooltip, outputItems);
            this.addFluidTooltips(tooltip, outputFluids);
        }
    }

    private void addItemTooltips(ITooltip iTooltip, List<ItemStack> outputItems) {
        IElementHelper helper = iTooltip.getElementHelper();
        for (ItemStack itemOutput : outputItems) {
            if (itemOutput == null || itemOutput.m_41619_()) continue;
            int count = itemOutput.m_41613_();
            itemOutput.m_41764_(1);
            iTooltip.add(helper.smallItem(itemOutput));
            MutableComponent text = Component.m_237113_((String)" ").m_130946_(String.valueOf(count)).m_130946_("\u00d7 ").m_7220_(this.getItemName(itemOutput)).m_130940_(ChatFormatting.WHITE);
            iTooltip.append((Component)text);
        }
    }

    private void addFluidTooltips(ITooltip iTooltip, List<FluidStack> outputFluids) {
        for (FluidStack fluidOutput : outputFluids) {
            if (fluidOutput == null || fluidOutput.isEmpty()) continue;
            iTooltip.add(GTElementHelper.smallFluid((JadeFluidObject)this.getFluid(fluidOutput)));
            MutableComponent text = Component.m_237113_((String)" ").m_130946_(FluidTextHelper.getUnicodeMillibuckets((long)fluidOutput.getAmount(), (boolean)true)).m_130946_(" ").m_7220_(this.getFluidName(fluidOutput)).m_130940_(ChatFormatting.WHITE);
            iTooltip.append((Component)text);
        }
    }

    private Component getItemName(ItemStack stack) {
        return ComponentUtils.m_130748_((Component)stack.m_41720_().m_41466_()).m_130940_(ChatFormatting.WHITE);
    }

    private Component getFluidName(FluidStack stack) {
        return ComponentUtils.m_130748_((Component)stack.getDisplayName()).m_130940_(ChatFormatting.WHITE);
    }

    private JadeFluidObject getFluid(FluidStack stack) {
        return JadeFluidObject.of((Fluid)stack.getFluid(), (long)stack.getAmount());
    }

    private static int generateThreadColor(int threadIndex) {
        float goldenRatio = 0.618034f;
        float hue = (float)(threadIndex + 1) * goldenRatio % 1.0f;
        float saturation = 0.85f;
        float value = 0.85f;
        int rgb = StarTThreadedRecipeProvider.hsvToRgb(hue, saturation, value);
        return 0xFF000000 | rgb;
    }

    private static int hsvToRgb(float h, float s, float v) {
        float b;
        float g;
        float r;
        int hi = (int)(h * 6.0f);
        float f = h * 6.0f - (float)hi;
        float p = v * (1.0f - s);
        float q = v * (1.0f - f * s);
        float t = v * (1.0f - (1.0f - f) * s);
        switch (hi % 6) {
            case 0: {
                r = v;
                g = t;
                b = p;
                break;
            }
            case 1: {
                r = q;
                g = v;
                b = p;
                break;
            }
            case 2: {
                r = p;
                g = v;
                b = t;
                break;
            }
            case 3: {
                r = p;
                g = q;
                b = v;
                break;
            }
            case 4: {
                r = t;
                g = p;
                b = v;
                break;
            }
            case 5: {
                r = v;
                g = p;
                b = q;
                break;
            }
            default: {
                b = 0.0f;
                g = 0.0f;
                r = 0.0f;
            }
        }
        int red = (int)(r * 255.0f);
        int green = (int)(g * 255.0f);
        int blue = (int)(b * 255.0f);
        return red << 16 | green << 8 | blue;
    }
}

