/*
 * Decompiled with CFR 0.152.
 */
package com.startechnology.start_core.block.casings;

import com.gregtechceu.gtceu.api.block.ActiveBlock;
import com.gregtechceu.gtceu.api.item.tool.GTToolType;
import com.gregtechceu.gtceu.common.data.GTModels;
import com.startechnology.start_core.StarTCore;
import com.tterrag.registrate.builders.BlockBuilder;
import com.tterrag.registrate.providers.DataGenContext;
import com.tterrag.registrate.providers.RegistrateBlockstateProvider;
import com.tterrag.registrate.util.entry.BlockEntry;
import com.tterrag.registrate.util.nullness.NonNullBiConsumer;
import com.tterrag.registrate.util.nullness.NonNullSupplier;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.ModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.client.model.generators.VariantBlockStateBuilder;

public class StarTCasingBlocks {
    public static final BlockEntry<ActiveBlock> FIREBOX_ENRICHED_NAQUADAH = StarTCasingBlocks.createFireboxCasing("enriched_naquadah_firebox", StarTCore.resourceLocation("block/casings/naquadah/firebox_casing"), StarTCore.resourceLocation("block/casings/naquadah/casing"));
    public static final BlockEntry<ActiveBlock> ENGINE_INTAKE_ENRICHED_NAQUADAH = StarTCasingBlocks.createActiveCasing("enriched_naquadah_engine_intake_casing", "block/variant/enriched_naquadah_engine_intake");

    private static NonNullBiConsumer<DataGenContext<Block, ActiveBlock>, RegistrateBlockstateProvider> createFireboxModel(String name, ResourceLocation sideTexture, ResourceLocation topBottomTexture) {
        return (ctx, prov) -> {
            ActiveBlock block = (ActiveBlock)ctx.getEntry();
            ModelBuilder inactive = prov.models().cubeBottomTop(name, sideTexture, topBottomTexture, topBottomTexture);
            ModelBuilder active = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)prov.models().withExistingParent(name + "_active", StarTCore.resourceLocation("block/fire_box_active"))).texture("side", sideTexture)).texture("bottom", topBottomTexture)).texture("top", topBottomTexture);
            ((VariantBlockStateBuilder)prov.getVariantBuilder((Block)block).partialState().with((Property)ActiveBlock.ACTIVE, (Comparable)Boolean.valueOf(false)).modelForState().modelFile((ModelFile)inactive).addModel()).partialState().with((Property)ActiveBlock.ACTIVE, (Comparable)Boolean.valueOf(true)).modelForState().modelFile((ModelFile)active).addModel();
        };
    }

    private static BlockEntry<ActiveBlock> createFireboxCasing(String name, ResourceLocation sideTexture, ResourceLocation topBottomTexture) {
        BlockEntry block = ((BlockBuilder)StarTCore.START_REGISTRATE.block("%s_casing".formatted(name), ActiveBlock::new).initialProperties(() -> Blocks.f_50075_).properties(p -> p.m_60922_((state, level, pos, ent) -> false)).addLayer(() -> RenderType::m_110457_).blockstate(StarTCasingBlocks.createFireboxModel("%s_casing".formatted(name), sideTexture, topBottomTexture)).tag(new TagKey[]{(TagKey)GTToolType.WRENCH.harvestTags.get(0), BlockTags.f_144282_}).item(BlockItem::new).build()).register();
        return block;
    }

    protected static BlockEntry<ActiveBlock> createActiveCasing(String name, String baseModelPath) {
        return ((BlockBuilder)StarTCore.START_REGISTRATE.block(name, ActiveBlock::new).initialProperties(() -> Blocks.f_50075_).addLayer(() -> RenderType::m_110457_).blockstate(GTModels.createActiveModel((ResourceLocation)StarTCore.resourceLocation(baseModelPath))).tag(new TagKey[]{(TagKey)GTToolType.WRENCH.harvestTags.get(0), BlockTags.f_144282_}).item(BlockItem::new).model((ctx, prov) -> prov.withExistingParent(prov.name((NonNullSupplier)ctx), StarTCore.resourceLocation(baseModelPath))).build()).register();
    }

    public static final void init() {
    }
}

