/*
 * Decompiled with CFR 0.152.
 */
package com.startechnology.start_core.api.capability;

import com.gregtechceu.gtceu.api.blockentity.MetaMachineBlockEntity;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.startechnology.start_core.api.capability.IStarTDreamLinkNetworkMachine;
import com.startechnology.start_core.api.capability.StarTCapability;
import com.startechnology.start_core.machine.abyssal_harvester.StarTAbyssalHarvesterMachine;
import com.startechnology.start_core.machine.hellforge.StarTHellForgeMachine;
import com.startechnology.start_core.machine.redstone.StarTRedstoneInterfacePartMachine;
import com.startechnology.start_core.machine.threading.StarTThreadingCapableMachine;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.Nullable;

public class StarTCapabilityHelper {
    private static <T> LazyOptional<T> getCapabilityFromMachine(Capability<T> capability, MetaMachine machine) {
        if (capability == StarTCapability.CAPABILITY_DREAM_LINK_NETWORK_MACHINE) {
            if (machine instanceof IStarTDreamLinkNetworkMachine) {
                IStarTDreamLinkNetworkMachine dreamLinkNetworkMachine = (IStarTDreamLinkNetworkMachine)machine;
                return StarTCapability.CAPABILITY_DREAM_LINK_NETWORK_MACHINE.orEmpty(capability, LazyOptional.of(() -> dreamLinkNetworkMachine));
            }
        } else if (capability == StarTCapability.CAPABILITY_HELL_FORGE_MACHINE) {
            if (machine instanceof StarTHellForgeMachine) {
                StarTHellForgeMachine hellforgeMachine = (StarTHellForgeMachine)machine;
                return StarTCapability.CAPABILITY_HELL_FORGE_MACHINE.orEmpty(capability, LazyOptional.of(() -> hellforgeMachine));
            }
        } else if (capability == StarTCapability.CAPABILITY_REDSTONE_INTERFACE) {
            if (machine instanceof StarTRedstoneInterfacePartMachine) {
                StarTRedstoneInterfacePartMachine redstoneMachine = (StarTRedstoneInterfacePartMachine)machine;
                return StarTCapability.CAPABILITY_REDSTONE_INTERFACE.orEmpty(capability, LazyOptional.of(() -> redstoneMachine));
            }
        } else if (capability == StarTCapability.CAPABILITY_ABYSSAL_HARVESTER) {
            if (machine instanceof StarTAbyssalHarvesterMachine) {
                StarTAbyssalHarvesterMachine harvesterMachine = (StarTAbyssalHarvesterMachine)machine;
                return StarTCapability.CAPABILITY_ABYSSAL_HARVESTER.orEmpty(capability, LazyOptional.of(() -> harvesterMachine));
            }
        } else if (capability == StarTCapability.CAPABILITY_THREADING_CAPABLE_MACHINE && machine instanceof StarTThreadingCapableMachine) {
            StarTThreadingCapableMachine threadingCapableMachine = (StarTThreadingCapableMachine)machine;
            return StarTCapability.CAPABILITY_THREADING_CAPABLE_MACHINE.orEmpty(capability, LazyOptional.of(() -> threadingCapableMachine));
        }
        return LazyOptional.empty();
    }

    @Nullable
    private static <T> T getBlockEntityCapability(Capability<T> capability, Level level, BlockPos pos, @Nullable Direction side) {
        BlockEntity blockEntity;
        if (level.m_8055_(pos).m_155947_() && (blockEntity = level.m_7702_(pos)) != null && blockEntity instanceof MetaMachineBlockEntity) {
            MetaMachineBlockEntity metaMachineBlockEntity = (MetaMachineBlockEntity)blockEntity;
            MetaMachine machine = metaMachineBlockEntity.getMetaMachine();
            return StarTCapabilityHelper.getCapabilityFromMachine(capability, machine).resolve().orElse(null);
        }
        return null;
    }

    @Nullable
    public static IStarTDreamLinkNetworkMachine getDreamLinkNetworkMachine(Level level, BlockPos pos, @Nullable Direction side) {
        return StarTCapabilityHelper.getBlockEntityCapability(StarTCapability.CAPABILITY_DREAM_LINK_NETWORK_MACHINE, level, pos, side);
    }

    @Nullable
    public static StarTRedstoneInterfacePartMachine getRedstoneInterfacePartMachine(Level level, BlockPos pos, @Nullable Direction side) {
        return StarTCapabilityHelper.getBlockEntityCapability(StarTCapability.CAPABILITY_REDSTONE_INTERFACE, level, pos, side);
    }

    @Nullable
    public static StarTThreadingCapableMachine getThreadingCapableMachine(Level level, BlockPos pos, @Nullable Direction side) {
        return StarTCapabilityHelper.getBlockEntityCapability(StarTCapability.CAPABILITY_THREADING_CAPABLE_MACHINE, level, pos, side);
    }

    @Nullable
    public static StarTHellForgeMachine getHellforgeMachine(Level level, BlockPos pos, @Nullable Direction side) {
        return StarTCapabilityHelper.getBlockEntityCapability(StarTCapability.CAPABILITY_HELL_FORGE_MACHINE, level, pos, side);
    }

    @Nullable
    public static StarTAbyssalHarvesterMachine getAbyssalHarvesterMachine(Level level, BlockPos pos, @Nullable Direction side) {
        return StarTCapabilityHelper.getBlockEntityCapability(StarTCapability.CAPABILITY_ABYSSAL_HARVESTER, level, pos, side);
    }
}

