/*
 * Decompiled with CFR 0.152.
 */
package com.startechnology.start_core.api.bacteria;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.StringUtils;

public class StarTBacteriaStats {
    public static final String BACTERIA_PRODUCTION_NBT_TAG = "bacteria_production";
    public static final String BACTERIA_METABOLISM_NBT_TAG = "bacteria_metabolism";
    public static final String BACTERIA_MUTABILITY_NBT_TAG = "bacteria_mutability";
    public static final String BACTERIA_PRIMARY_NBT_TAG = "bacteria_primary";
    public static final String BACTERIA_SECONDARY_NBT_TAG = "bacteria_secondary";
    public static final String BACTERIA_TERTIARY_NBT_TAG = "bacteria_tertiary";
    public static final Integer MAX_STAT_VALUE = 5;
    private Integer production;
    private Integer metabolism;
    private Integer mutability;
    private Fluid primary;
    private Fluid secondary;
    private Fluid tertiary;

    public Integer getProduction() {
        return this.production;
    }

    public Integer getMetabolism() {
        return this.metabolism;
    }

    public Integer getMutability() {
        return this.mutability;
    }

    public Fluid getPrimary() {
        return this.primary;
    }

    public Fluid getSecondary() {
        return this.secondary;
    }

    public Fluid getTertiary() {
        return this.tertiary;
    }

    public String getProductionPretty() {
        return StarTBacteriaStats.getPrettyStatHighBias(this.production);
    }

    public String getMetabolismPretty() {
        return StarTBacteriaStats.getPrettyStatLowBias(this.metabolism);
    }

    public MutableComponent getFluidPretty(Fluid fluid) {
        if (fluid == null) {
            return Component.m_237115_((String)"behaviour.start_core.bacteria.affinity_none");
        }
        return Component.m_237115_((String)fluid.getFluidType().getDescriptionId());
    }

    public String getMutabilityPretty() {
        return String.format("\u00a7f%s\u00a7r", StarTBacteriaStats.getStatRectangleForm(this.mutability));
    }

    public static String getPrettyStatHighBias(Integer stat) {
        String colourCode = switch (stat) {
            case 1 -> "\u00a74";
            case 2 -> "\u00a7c";
            case 3 -> "\u00a7e";
            case 4 -> "\u00a72";
            case 5 -> "\u00a7a";
            default -> " \u00a7e";
        };
        return String.format("%s%s\u00a7r", colourCode, StarTBacteriaStats.getStatRectangleForm(stat));
    }

    public static String getPrettyStatLowBias(Integer stat) {
        String colourCode = switch (stat) {
            case 5 -> "\u00a74";
            case 4 -> "\u00a7c";
            case 3 -> "\u00a7e";
            case 2 -> "\u00a72";
            case 1 -> "\u00a7a";
            default -> " \u00a7e";
        };
        return String.format("%s%s\u00a7r", colourCode, StarTBacteriaStats.getStatRectangleForm(stat));
    }

    public static String getStatRectangleForm(Integer stat) {
        return StringUtils.repeat((char)'\u25a0', (int)stat) + StringUtils.repeat((char)'\u25a1', (int)(MAX_STAT_VALUE - stat));
    }

    public StarTBacteriaStats(Integer production, Integer metabolism, Integer mutability, Fluid primary, Fluid secondary, Fluid tertiary) {
        this.production = production;
        this.metabolism = metabolism;
        this.mutability = mutability;
        this.primary = primary;
        this.secondary = secondary;
        this.tertiary = tertiary;
    }

    public StarTBacteriaStats(CompoundTag bacteriaStatsCompound) {
        this.production = bacteriaStatsCompound.m_128451_(BACTERIA_PRODUCTION_NBT_TAG);
        this.metabolism = bacteriaStatsCompound.m_128451_(BACTERIA_METABOLISM_NBT_TAG);
        this.mutability = bacteriaStatsCompound.m_128451_(BACTERIA_MUTABILITY_NBT_TAG);
        String affinityString = bacteriaStatsCompound.m_128461_(BACTERIA_PRIMARY_NBT_TAG);
        String[] resourceSplit = affinityString.split(":");
        ResourceLocation bacteriaAffinityLocation = new ResourceLocation(resourceSplit[0], resourceSplit[1]);
        if (ForgeRegistries.FLUIDS.containsKey(bacteriaAffinityLocation)) {
            this.primary = (Fluid)ForgeRegistries.FLUIDS.getValue(bacteriaAffinityLocation);
        }
        if (ForgeRegistries.FLUIDS.containsKey(bacteriaAffinityLocation = new ResourceLocation((resourceSplit = (affinityString = bacteriaStatsCompound.m_128461_(BACTERIA_SECONDARY_NBT_TAG)).split(":"))[0], resourceSplit[1]))) {
            this.secondary = (Fluid)ForgeRegistries.FLUIDS.getValue(bacteriaAffinityLocation);
        }
        if (ForgeRegistries.FLUIDS.containsKey(bacteriaAffinityLocation = new ResourceLocation((resourceSplit = (affinityString = bacteriaStatsCompound.m_128461_(BACTERIA_TERTIARY_NBT_TAG)).split(":"))[0], resourceSplit[1]))) {
            this.tertiary = (Fluid)ForgeRegistries.FLUIDS.getValue(bacteriaAffinityLocation);
        }
    }

    public CompoundTag toCompoundTag() {
        CompoundTag bacteriaStatsCompound = new CompoundTag();
        bacteriaStatsCompound.m_128405_(BACTERIA_PRODUCTION_NBT_TAG, this.production.intValue());
        bacteriaStatsCompound.m_128405_(BACTERIA_METABOLISM_NBT_TAG, this.metabolism.intValue());
        bacteriaStatsCompound.m_128405_(BACTERIA_MUTABILITY_NBT_TAG, this.mutability.intValue());
        if (this.primary != null) {
            bacteriaStatsCompound.m_128359_(BACTERIA_PRIMARY_NBT_TAG, ForgeRegistries.FLUIDS.getKey((Object)this.primary).toString());
        }
        if (this.secondary != null) {
            bacteriaStatsCompound.m_128359_(BACTERIA_SECONDARY_NBT_TAG, ForgeRegistries.FLUIDS.getKey((Object)this.secondary).toString());
        }
        if (this.tertiary != null) {
            bacteriaStatsCompound.m_128359_(BACTERIA_TERTIARY_NBT_TAG, ForgeRegistries.FLUIDS.getKey((Object)this.tertiary).toString());
        }
        return bacteriaStatsCompound;
    }
}

