/*
 * Decompiled with CFR 0.152.
 */
package com.startechnology.start_core;

import com.gregtechceu.gtceu.api.GTCEuAPI;
import com.gregtechceu.gtceu.api.data.DimensionMarker;
import com.gregtechceu.gtceu.api.data.chemical.material.event.MaterialEvent;
import com.gregtechceu.gtceu.api.data.chemical.material.event.MaterialRegistryEvent;
import com.gregtechceu.gtceu.api.data.chemical.material.event.PostMaterialEvent;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.FluidPipeProperties;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.IMaterialProperty;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.PropertyKey;
import com.gregtechceu.gtceu.api.machine.MachineDefinition;
import com.gregtechceu.gtceu.api.recipe.GTRecipeType;
import com.gregtechceu.gtceu.api.recipe.category.GTRecipeCategory;
import com.gregtechceu.gtceu.api.registry.registrate.GTRegistrate;
import com.gregtechceu.gtceu.common.data.GTMaterials;
import com.gregtechceu.gtceu.common.data.GTRecipeTypes;
import com.startechnology.start_core.api.StarTCreativeTab;
import com.startechnology.start_core.data.StarTDimensionMarkers;
import com.startechnology.start_core.machine.StarTMachines;
import com.startechnology.start_core.machine.abyssal_containment.StarTAbyssalContainmentMachine;
import com.startechnology.start_core.materials.StarTMaterials;
import com.startechnology.start_core.recipe.StarTRecipeCategories;
import com.startechnology.start_core.recipe.StarTRecipeTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="start_core")
public class StarTCore {
    public static final String MOD_ID = "start_core";
    public static final Logger LOGGER = LogManager.getLogger();
    public static final GTRegistrate START_REGISTRATE = GTRegistrate.create((String)"start_core");
    public static final RandomSource RNG = RandomSource.m_216337_();

    public static ResourceLocation resourceLocation(String path) {
        return new ResourceLocation(MOD_ID, path);
    }

    public StarTCore() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        StarTCreativeTab.init();
        START_REGISTRATE.creativeModeTab(() -> StarTCreativeTab.START_CORE);
        modEventBus.addListener(this::commonSetup);
        modEventBus.addListener(this::clientSetup);
        modEventBus.addListener(this::addMaterialRegistries);
        modEventBus.addListener(this::addMaterials);
        modEventBus.addListener(this::modifyMaterials);
        modEventBus.addGenericListener(GTRecipeType.class, this::registerRecipeTypes);
        modEventBus.addGenericListener(MachineDefinition.class, this::registerMachines);
        modEventBus.addGenericListener(GTRecipeCategory.class, this::registerRecipeCategories);
        modEventBus.addGenericListener(DimensionMarker.class, this::registerDimensionalMarkers);
        START_REGISTRATE.registerRegistrate();
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        StarTAbyssalContainmentMachine.init();
    }

    private void clientSetup(FMLClientSetupEvent event) {
    }

    private void addMaterialRegistries(MaterialRegistryEvent event) {
        GTCEuAPI.materialManager.createRegistry(MOD_ID);
    }

    private void addMaterials(MaterialEvent event) {
        StarTMaterials.register();
    }

    private void modifyMaterials(PostMaterialEvent event) {
        if (!GTMaterials.NaquadahEnriched.hasProperty(PropertyKey.FLUID_PIPE)) {
            GTMaterials.NaquadahEnriched.setProperty(PropertyKey.FLUID_PIPE, (IMaterialProperty)new FluidPipeProperties(8000, 500, true, true, true, false));
        }
    }

    private void registerDimensionalMarkers(GTCEuAPI.RegisterEvent<ResourceLocation, DimensionMarker> event) {
        StarTDimensionMarkers.init();
    }

    private void registerRecipeTypes(GTCEuAPI.RegisterEvent<ResourceLocation, GTRecipeType> event) {
        GTRecipeTypes.BLAST_RECIPES.setMaxIOSize(3, 3, 3, 3);
        StarTRecipeTypes.init();
    }

    private void registerRecipeCategories(GTCEuAPI.RegisterEvent<ResourceLocation, GTRecipeCategory> event) {
        StarTRecipeCategories.init();
    }

    private void registerMachines(GTCEuAPI.RegisterEvent<ResourceLocation, MachineDefinition> event) {
        StarTMachines.init();
    }
}

