/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.item;

import com.google.common.collect.ImmutableList;
import com.simibubi.create.foundation.item.TooltipHelper;
import com.simibubi.create.foundation.item.TooltipModifier;
import com.simibubi.create.foundation.utility.CreateLang;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.createmod.catnip.lang.FontHelper;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.Nullable;

public record ItemDescription(ImmutableList<Component> lines, ImmutableList<Component> linesOnShift, ImmutableList<Component> linesOnCtrl) {
    private static final Map<Item, Supplier<String>> CUSTOM_TOOLTIP_KEYS = new IdentityHashMap<Item, Supplier<String>>();

    @Nullable
    public static ItemDescription create(Item item, FontHelper.Palette palette) {
        return ItemDescription.create(ItemDescription.getTooltipTranslationKey(item), palette);
    }

    @Nullable
    public static ItemDescription create(String translationKey, FontHelper.Palette palette) {
        if (!ItemDescription.canFillBuilder(translationKey + ".summary")) {
            return null;
        }
        Builder builder = new Builder(palette);
        ItemDescription.fillBuilder(builder, translationKey);
        return builder.build();
    }

    public static boolean canFillBuilder(String translationKey) {
        return I18n.m_118936_((String)translationKey);
    }

    public static void fillBuilder(Builder builder, String translationKey) {
        int i;
        String summaryKey = translationKey + ".summary";
        if (I18n.m_118936_((String)summaryKey)) {
            builder.addSummary(I18n.m_118938_((String)summaryKey, (Object[])new Object[0]));
        }
        for (i = 1; i < 100; ++i) {
            String conditionKey = translationKey + ".condition" + i;
            String behaviourKey = translationKey + ".behaviour" + i;
            if (!I18n.m_118936_((String)conditionKey)) break;
            builder.addBehaviour(I18n.m_118938_((String)conditionKey, (Object[])new Object[0]), I18n.m_118938_((String)behaviourKey, (Object[])new Object[0]));
        }
        for (i = 1; i < 100; ++i) {
            String controlKey = translationKey + ".control" + i;
            String actionKey = translationKey + ".action" + i;
            if (!I18n.m_118936_((String)controlKey)) break;
            builder.addAction(I18n.m_118938_((String)controlKey, (Object[])new Object[0]), I18n.m_118938_((String)actionKey, (Object[])new Object[0]));
        }
    }

    public static void useKey(Item item, Supplier<String> supplier) {
        CUSTOM_TOOLTIP_KEYS.put(item, supplier);
    }

    public static void useKey(ItemLike item, String string) {
        ItemDescription.useKey(item.m_5456_(), () -> string);
    }

    public static void referKey(ItemLike item, Supplier<? extends ItemLike> otherItem) {
        ItemDescription.useKey(item.m_5456_(), () -> ((ItemLike)otherItem.get()).m_5456_().m_5524_());
    }

    public static String getTooltipTranslationKey(Item item) {
        if (CUSTOM_TOOLTIP_KEYS.containsKey(item)) {
            return CUSTOM_TOOLTIP_KEYS.get(item).get() + ".tooltip";
        }
        return item.m_5524_() + ".tooltip";
    }

    public ImmutableList<Component> getCurrentLines() {
        if (Screen.m_96638_()) {
            return this.linesOnShift;
        }
        if (Screen.m_96637_()) {
            return this.linesOnCtrl;
        }
        return this.lines;
    }

    public static class Builder {
        protected final FontHelper.Palette palette;
        protected final List<String> summary = new ArrayList<String>();
        protected final List<Pair<String, String>> behaviours = new ArrayList<Pair<String, String>>();
        protected final List<Pair<String, String>> actions = new ArrayList<Pair<String, String>>();

        public Builder(FontHelper.Palette palette) {
            this.palette = palette;
        }

        public Builder addSummary(String summaryLine) {
            this.summary.add(summaryLine);
            return this;
        }

        public Builder addBehaviour(String condition, String behaviour) {
            this.behaviours.add((Pair<String, String>)Pair.of((Object)condition, (Object)behaviour));
            return this;
        }

        public Builder addAction(String condition, String action) {
            this.actions.add((Pair<String, String>)Pair.of((Object)condition, (Object)action));
            return this;
        }

        public ItemDescription build() {
            boolean bl;
            String condition;
            ArrayList lines = new ArrayList();
            ArrayList<Object> linesOnShift = new ArrayList<Object>();
            ArrayList<Object> linesOnCtrl = new ArrayList<Object>();
            for (String string : this.summary) {
                linesOnShift.addAll(TooltipHelper.cutStringTextComponent(string, this.palette));
            }
            if (!this.behaviours.isEmpty()) {
                linesOnShift.add(CommonComponents.f_237098_);
            }
            for (Pair pair : this.behaviours) {
                condition = (String)pair.getLeft();
                String behaviour = (String)pair.getRight();
                linesOnShift.add(Component.m_237113_((String)condition).m_130940_(ChatFormatting.GRAY));
                linesOnShift.addAll(TooltipHelper.cutStringTextComponent(behaviour, this.palette.primary(), this.palette.highlight(), 1));
            }
            for (Pair pair : this.actions) {
                condition = (String)pair.getLeft();
                String action = (String)pair.getRight();
                linesOnCtrl.add(Component.m_237113_((String)condition).m_130940_(ChatFormatting.GRAY));
                linesOnCtrl.addAll(TooltipHelper.cutStringTextComponent(action, this.palette.primary(), this.palette.highlight(), 1));
            }
            boolean hasDescription = !linesOnShift.isEmpty();
            boolean bl2 = bl = !linesOnCtrl.isEmpty();
            if (hasDescription || bl) {
                String[] holdDesc = CreateLang.translateDirect("tooltip.holdForDescription", "$").getString().split("\\$");
                String[] holdCtrl = CreateLang.translateDirect("tooltip.holdForControls", "$").getString().split("\\$");
                MutableComponent keyShift = CreateLang.translateDirect("tooltip.keyShift", new Object[0]);
                MutableComponent keyCtrl = CreateLang.translateDirect("tooltip.keyCtrl", new Object[0]);
                for (List list : Arrays.asList(lines, linesOnShift, linesOnCtrl)) {
                    MutableComponent tabBuilder;
                    boolean ctrl;
                    boolean shift = list == linesOnShift;
                    boolean bl3 = ctrl = list == linesOnCtrl;
                    if (holdDesc.length != 2 || holdCtrl.length != 2) {
                        list.add(0, Component.m_237113_((String)"Invalid lang formatting!"));
                        continue;
                    }
                    if (bl) {
                        tabBuilder = Component.m_237119_();
                        tabBuilder.m_7220_((Component)Component.m_237113_((String)holdCtrl[0]).m_130940_(ChatFormatting.DARK_GRAY));
                        tabBuilder.m_7220_((Component)keyCtrl.m_6879_().m_130940_(ctrl ? ChatFormatting.WHITE : ChatFormatting.GRAY));
                        tabBuilder.m_7220_((Component)Component.m_237113_((String)holdCtrl[1]).m_130940_(ChatFormatting.DARK_GRAY));
                        list.add(0, tabBuilder);
                    }
                    if (hasDescription) {
                        tabBuilder = Component.m_237119_();
                        tabBuilder.m_7220_((Component)Component.m_237113_((String)holdDesc[0]).m_130940_(ChatFormatting.DARK_GRAY));
                        tabBuilder.m_7220_((Component)keyShift.m_6879_().m_130940_(shift ? ChatFormatting.WHITE : ChatFormatting.GRAY));
                        tabBuilder.m_7220_((Component)Component.m_237113_((String)holdDesc[1]).m_130940_(ChatFormatting.DARK_GRAY));
                        list.add(0, tabBuilder);
                    }
                    if (!shift && !ctrl) continue;
                    list.add(hasDescription && bl ? 2 : 1, CommonComponents.f_237098_);
                }
            }
            if (!hasDescription) {
                linesOnCtrl.clear();
                linesOnShift.addAll(lines);
            }
            if (!bl) {
                linesOnCtrl.clear();
                linesOnCtrl.addAll(lines);
            }
            return new ItemDescription((ImmutableList<Component>)ImmutableList.copyOf(lines), (ImmutableList<Component>)ImmutableList.copyOf(linesOnShift), (ImmutableList<Component>)ImmutableList.copyOf(linesOnCtrl));
        }
    }

    public static class Modifier
    implements TooltipModifier {
        protected final Item item;
        protected final FontHelper.Palette palette;
        protected String cachedLanguage;
        protected ItemDescription description;

        public Modifier(Item item, FontHelper.Palette palette) {
            this.item = item;
            this.palette = palette;
        }

        @Override
        public void modify(ItemTooltipEvent context) {
            if (this.checkLocale()) {
                this.description = ItemDescription.create(this.item, this.palette);
            }
            if (this.description == null) {
                return;
            }
            context.getToolTip().addAll(1, this.description.getCurrentLines());
        }

        protected boolean checkLocale() {
            String currentLanguage = Minecraft.m_91087_().m_91102_().m_264236_();
            if (!currentLanguage.equals(this.cachedLanguage)) {
                this.cachedLanguage = currentLanguage;
                return true;
            }
            return false;
        }
    }
}

