/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.trains.station;

import com.simibubi.create.content.decoration.slidingDoor.DoorControl;
import com.simibubi.create.content.trains.station.GlobalStation;
import com.simibubi.create.content.trains.station.StationBlock;
import com.simibubi.create.content.trains.station.StationBlockEntity;
import com.simibubi.create.foundation.networking.BlockEntityConfigurationPacket;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class StationEditPacket
extends BlockEntityConfigurationPacket<StationBlockEntity> {
    boolean dropSchedule;
    boolean assemblyMode;
    Boolean tryAssemble;
    DoorControl doorControl;
    String name;

    public static StationEditPacket dropSchedule(BlockPos pos) {
        StationEditPacket packet = new StationEditPacket(pos);
        packet.dropSchedule = true;
        return packet;
    }

    public static StationEditPacket tryAssemble(BlockPos pos) {
        StationEditPacket packet = new StationEditPacket(pos);
        packet.tryAssemble = true;
        return packet;
    }

    public static StationEditPacket tryDisassemble(BlockPos pos) {
        StationEditPacket packet = new StationEditPacket(pos);
        packet.tryAssemble = false;
        return packet;
    }

    public static StationEditPacket configure(BlockPos pos, boolean assemble, String name, DoorControl doorControl) {
        StationEditPacket packet = new StationEditPacket(pos);
        packet.assemblyMode = assemble;
        packet.tryAssemble = null;
        packet.name = name;
        packet.doorControl = doorControl;
        return packet;
    }

    public StationEditPacket(FriendlyByteBuf buffer) {
        super(buffer);
    }

    public StationEditPacket(BlockPos pos) {
        super(pos);
    }

    @Override
    protected void writeSettings(FriendlyByteBuf buffer) {
        buffer.writeBoolean(this.dropSchedule);
        if (this.dropSchedule) {
            return;
        }
        buffer.writeBoolean(this.doorControl != null);
        if (this.doorControl != null) {
            buffer.m_130130_(this.doorControl.ordinal());
        }
        buffer.writeBoolean(this.tryAssemble != null);
        if (this.tryAssemble != null) {
            buffer.writeBoolean(this.tryAssemble.booleanValue());
            return;
        }
        buffer.writeBoolean(this.assemblyMode);
        buffer.m_130070_(this.name);
    }

    @Override
    protected void readSettings(FriendlyByteBuf buffer) {
        if (buffer.readBoolean()) {
            this.dropSchedule = true;
            return;
        }
        if (buffer.readBoolean()) {
            this.doorControl = DoorControl.values()[Mth.m_14045_((int)buffer.m_130242_(), (int)0, (int)DoorControl.values().length)];
        }
        this.name = "";
        if (buffer.readBoolean()) {
            this.tryAssemble = buffer.readBoolean();
            return;
        }
        this.assemblyMode = buffer.readBoolean();
        this.name = buffer.m_130136_(256);
    }

    @Override
    protected void applySettings(ServerPlayer player, StationBlockEntity be) {
        Level level = be.m_58904_();
        BlockPos blockPos = be.m_58899_();
        BlockState blockState = level.m_8055_(blockPos);
        GlobalStation station = be.getStation();
        if (this.dropSchedule) {
            if (station == null) {
                return;
            }
            be.dropSchedule(player, station.getPresentTrain());
            return;
        }
        if (this.doorControl != null) {
            be.doorControls.set(this.doorControl);
        }
        if (!this.name.isBlank()) {
            be.updateName(this.name);
        }
        if (!(blockState.m_60734_() instanceof StationBlock)) {
            return;
        }
        Boolean isAssemblyMode = (Boolean)blockState.m_61143_((Property)StationBlock.ASSEMBLING);
        boolean assemblyComplete = false;
        if (this.tryAssemble != null) {
            if (!isAssemblyMode.booleanValue()) {
                return;
            }
            if (this.tryAssemble.booleanValue()) {
                be.assemble(player.m_20148_());
                assemblyComplete = station != null && station.getPresentTrain() != null;
            } else if (be.tryDisassembleTrain(player) && be.tryEnterAssemblyMode()) {
                be.refreshAssemblyInfo();
            }
            if (!assemblyComplete) {
                return;
            }
        }
        if (this.assemblyMode) {
            be.enterAssemblyMode(player);
        } else {
            be.exitAssemblyMode();
        }
    }

    @Override
    protected void applySettings(StationBlockEntity be) {
    }
}

