/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.equipment.armor;

import com.google.common.cache.Cache;
import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.AllPartialModels;
import com.simibubi.create.content.equipment.armor.CardboardArmorHandler;
import com.simibubi.create.content.logistics.box.PackageRenderer;
import com.simibubi.create.foundation.utility.TickBasedCache;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import net.createmod.catnip.animation.AnimationTickHolder;
import net.minecraft.client.CameraType;
import net.minecraft.client.Minecraft;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class CardboardArmorHandlerClient {
    private static final Cache<UUID, Integer> BOXES_PLAYERS_ARE_HIDING_AS = new TickBasedCache<UUID, Integer>(20, true);

    @SubscribeEvent
    public static void keepCacheAliveDesignDespiteNotRendering(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            return;
        }
        Player player = event.player;
        if (!CardboardArmorHandler.testForStealth((Entity)player)) {
            return;
        }
        try {
            CardboardArmorHandlerClient.getCurrentBoxIndex(player);
        }
        catch (ExecutionException e) {
            e.printStackTrace();
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void playerRendersAsBoxWhenSneaking(RenderPlayerEvent.Pre event) {
        Player player = event.getEntity();
        if (!CardboardArmorHandler.testForStealth((Entity)player)) {
            return;
        }
        event.setCanceled(true);
        if (player == Minecraft.m_91087_().f_91074_ && Minecraft.m_91087_().f_91066_.m_92176_() == CameraType.FIRST_PERSON) {
            return;
        }
        PoseStack ms = event.getPoseStack();
        ms.m_85836_();
        ms.m_252880_(0.0f, 0.125f, 0.0f);
        float movement = (float)player.m_20182_().m_82492_(player.f_19854_, player.f_19855_, player.f_19856_).m_82553_();
        if (player.m_20096_()) {
            ms.m_252880_(0.0f, Math.min(Math.abs(Mth.m_14089_((float)(AnimationTickHolder.getRenderTime() % 256.0f / 2.0f))) * 2.0f / 16.0f, movement * 5.0f), 0.0f);
        }
        float interpolatedYaw = Mth.m_14179_((float)event.getPartialTick(), (float)player.f_19859_, (float)player.m_146908_());
        try {
            PartialModel model = AllPartialModels.PACKAGES_TO_HIDE_AS.get(CardboardArmorHandlerClient.getCurrentBoxIndex(player));
            PackageRenderer.renderBox((Entity)player, interpolatedYaw, ms, event.getMultiBufferSource(), event.getPackedLight(), model);
        }
        catch (ExecutionException e) {
            e.printStackTrace();
        }
        ms.m_85849_();
    }

    private static Integer getCurrentBoxIndex(Player player) throws ExecutionException {
        return (Integer)BOXES_PLAYERS_ARE_HIDING_AS.get((Object)player.m_20148_(), () -> player.m_9236_().f_46441_.m_188503_(AllPartialModels.PACKAGES_TO_HIDE_AS.size()));
    }
}

