/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.core.scans;

import java.lang.annotation.ElementType;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.javafmlmod.FMLModContainer;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.fml.loading.moddiscovery.ModAnnotation;
import org.zeith.hammerlib.HammerLib;
import org.zeith.hammerlib.annotations.Setup;
import org.zeith.hammerlib.annotations.client.ClientSetup;
import org.zeith.hammerlib.api.proxy.IProxy;
import org.zeith.hammerlib.core.adapter.RegistryAdapter;
import org.zeith.hammerlib.core.scans.base.IAnnotationScanListener;
import org.zeith.hammerlib.core.scans.base.IScanListener;
import org.zeith.hammerlib.util.mcf.ScanDataHelper;

public class ScanSetups {
    private static final List<ModAnnotation.EnumHolder> BOTH_SIDES = Stream.of(Dist.values()).map(dst -> new ModAnnotation.EnumHolder("Lnet/minecraftforge/itf/distmarker/Dist;", dst.name())).collect(Collectors.toList());

    public static IScanListener create() {
        IScanListener l = IAnnotationScanListener.forAnnotation(Setup.class, ElementType.METHOD, ScanSetups::handleSetup);
        return (IScanListener)IProxy.create(() -> () -> l.then(IAnnotationScanListener.forAnnotation(ClientSetup.class, ElementType.METHOD, ScanSetups::clientSetup)), () -> () -> l);
    }

    private static void handleSetup(ScanDataHelper.ModAwareAnnotationData data) {
        List<ModAnnotation.EnumHolder> lst;
        List<ModAnnotation.EnumHolder> side = data.getProperty("side").orElse(BOTH_SIDES);
        if (side instanceof List && !(lst = side).isEmpty()) {
            for (ModAnnotation.EnumHolder o : lst) {
                if (!(o instanceof ModAnnotation.EnumHolder)) continue;
                ModAnnotation.EnumHolder h = o;
                if (!FMLEnvironment.dist.name().equals(h.getValue())) continue;
                HammerLib.LOG.info("Injecting setup into {}", (Object)data.clazz().getClassName());
                data.getOwnerMod().map(FMLModContainer::getEventBus).ifPresent(b -> b.addListener(event -> RegistryAdapter.setup(event, data.getOwnerClass(), data.getMemberName())));
                return;
            }
        } else {
            HammerLib.LOG.warn("What the hell is this? {}->{}", (Object)data.parent.clazz(), (Object)data.getMemberName());
        }
    }

    private static void clientSetup(ScanDataHelper.ModAwareAnnotationData data) {
        HammerLib.LOG.info("Injecting client-setup into {}", (Object)data.clazz().getClassName());
        data.getOwnerMod().map(FMLModContainer::getEventBus).ifPresent(b -> b.addListener(event -> RegistryAdapter.clientSetup(event, data.getOwnerClass(), data.getMemberName())));
    }
}

