/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.client.flowgui.util;

import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipPositioner;
import net.minecraft.client.gui.screens.inventory.tooltip.DefaultTooltipPositioner;
import net.minecraft.network.chat.Component;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import org.zeith.hammerlib.client.flowgui.Graphics;
import org.zeith.hammerlib.util.mcf.fluid.FluidHelper;

public interface Tooltip {
    public void render(Graphics var1, Font var2, int var3, int var4);

    public static Tooltip ofItem(ItemStack stack) {
        return new ItemTooltip(stack);
    }

    public static Tooltip ofItem(Supplier<ItemStack> stack) {
        return new ItemTooltip(stack);
    }

    public static Tooltip ofFluid(FluidStack stack, boolean showCapacity, int capacity) {
        return new FluidTooltip(stack, showCapacity, capacity);
    }

    public static Tooltip ofFluid(Supplier<FluidStack> stack, boolean showCapacity, int capacity) {
        return new FluidTooltip(stack, showCapacity, capacity);
    }

    public static Tooltip ofComponent(Component ... text) {
        return new TextComponentTooltip(text);
    }

    public static Tooltip ofComponent(List<Component> text) {
        return new TextComponentTooltip(text);
    }

    public static Tooltip ofComponent(TooltipComponent component, Component ... text) {
        return new TextComponentTooltip(Optional.ofNullable(component), text);
    }

    public static Tooltip ofComponent(TooltipComponent component, List<Component> text) {
        return new TextComponentTooltip(text, Optional.ofNullable(component));
    }

    public static Tooltip ofSequence(FormattedCharSequence ... text) {
        return new CharSequenceTooltip(List.of(text));
    }

    public static Tooltip ofSequence(List<FormattedCharSequence> text) {
        return new CharSequenceTooltip(text);
    }

    public static Tooltip ofSequence(ClientTooltipPositioner positioner, FormattedCharSequence ... text) {
        return new CharSequenceTooltip(List.of(text), positioner);
    }

    public static Tooltip ofSequence(ClientTooltipPositioner positioner, List<FormattedCharSequence> text) {
        return new CharSequenceTooltip(text, positioner);
    }

    public record ItemTooltip(Supplier<ItemStack> stack) implements Tooltip
    {
        public ItemTooltip(ItemStack stack) {
            this(() -> ((ItemStack)stack).m_41777_());
        }

        @Override
        public void render(Graphics g, Font font, int x, int y) {
            g.gfx().m_280153_(font, this.stack.get(), x, y);
        }
    }

    public record FluidTooltip(Supplier<FluidStack> stack, boolean showCapacity, int capacity) implements Tooltip
    {
        public FluidTooltip(FluidStack stack, boolean showCapacity, int capacity) {
            this(() -> ((FluidStack)stack).copy(), showCapacity, capacity);
        }

        @Override
        public void render(Graphics g, Font font, int x, int y) {
            boolean ait = Minecraft.m_91087_().f_91066_.f_92125_;
            List<Component> tt = FluidHelper.getFluidTooltip(this.stack.get(), this.showCapacity, this.capacity, ait);
            Optional<TooltipComponent> com = FluidHelper.getFluidTooltipComponent(this.stack.get(), this.showCapacity, this.capacity, ait);
            g.gfx().m_280677_(font, tt, com, x, y);
        }
    }

    public record TextComponentTooltip(List<Component> tooltip, Optional<TooltipComponent> component) implements Tooltip
    {
        public TextComponentTooltip(List<Component> tooltip) {
            this(tooltip, Optional.empty());
        }

        public TextComponentTooltip(Optional<TooltipComponent> component, Component ... tooltip) {
            this(List.of(tooltip), component);
        }

        public TextComponentTooltip(Component ... tooltip) {
            this(List.of(tooltip));
        }

        @Override
        public void render(Graphics g, Font font, int x, int y) {
            g.renderTooltip(font, this.tooltip, this.component, x, y);
        }
    }

    public record CharSequenceTooltip(List<FormattedCharSequence> tooltip, ClientTooltipPositioner positioner) implements Tooltip
    {
        public CharSequenceTooltip(List<FormattedCharSequence> tooltip) {
            this(tooltip, DefaultTooltipPositioner.f_262752_);
        }

        @Override
        public void render(Graphics g, Font font, int x, int y) {
            g.gfx().m_280547_(font, this.tooltip, this.positioner, x, y);
        }
    }
}

