/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.api.data;

import java.util.Objects;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.zeith.hammerlib.api.data.IDataArray;
import org.zeith.hammerlib.util.java.OptionalFloat;

public interface IDataTree {
    @Nullable
    public Object get(String var1);

    @NotNull
    public Set<String> keys();

    default public boolean getBoolean(String index) {
        boolean bl;
        Object val = this.get(index);
        if (val instanceof Boolean) {
            Boolean b = (Boolean)val;
            bl = b;
        } else {
            bl = Boolean.parseBoolean(Objects.toString(val));
        }
        return bl;
    }

    default public boolean getBooleanOrDefault(String index, boolean defaultValue) {
        boolean bl;
        Object val = this.get(index);
        if (val instanceof Boolean) {
            Boolean b = (Boolean)val;
            bl = b;
        } else {
            String s = Objects.toString(val);
            bl = s.equalsIgnoreCase("false") || s.equalsIgnoreCase("true") ? Boolean.parseBoolean(s) : defaultValue;
        }
        return bl;
    }

    default public String getString(String index) {
        Object val = this.get(index);
        return val != null ? Objects.toString(val) : null;
    }

    default public OptionalInt getInt(String index) {
        Object val = this.get(index);
        if (val instanceof Number) {
            Number num = (Number)val;
            return OptionalInt.of(num.intValue());
        }
        if (val instanceof IDataArray || val instanceof IDataTree) {
            return OptionalInt.empty();
        }
        try {
            return OptionalInt.of(Integer.parseInt(Objects.toString(val)));
        }
        catch (Exception e) {
            return OptionalInt.empty();
        }
    }

    default public OptionalFloat getFloat(String index) {
        Object val = this.get(index);
        if (val instanceof Number) {
            Number num = (Number)val;
            return OptionalFloat.of(num.floatValue());
        }
        if (val instanceof IDataArray || val instanceof IDataTree) {
            return OptionalFloat.empty();
        }
        try {
            return OptionalFloat.of(Float.parseFloat(Objects.toString(val)));
        }
        catch (Exception e) {
            return OptionalFloat.empty();
        }
    }

    default public OptionalLong getLong(String index) {
        Object val = this.get(index);
        if (val instanceof Number) {
            Number num = (Number)val;
            return OptionalLong.of(num.longValue());
        }
        if (val instanceof IDataArray || val instanceof IDataTree) {
            return OptionalLong.empty();
        }
        try {
            return OptionalLong.of(Long.parseLong(Objects.toString(val)));
        }
        catch (Exception e) {
            return OptionalLong.empty();
        }
    }

    default public OptionalDouble getDouble(String index) {
        Object val = this.get(index);
        if (val instanceof Number) {
            Number num = (Number)val;
            return OptionalDouble.of(num.doubleValue());
        }
        if (val instanceof IDataArray || val instanceof IDataTree) {
            return OptionalDouble.empty();
        }
        try {
            return OptionalDouble.of(Double.parseDouble(Objects.toString(val)));
        }
        catch (Exception e) {
            return OptionalDouble.empty();
        }
    }
}

