/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.utils;

import com.google.common.base.MoreObjects;
import com.lowdragmc.lowdraglib.utils.Size;
import java.util.Objects;
import net.minecraft.world.phys.Vec2;
import org.joml.Vector2f;

public class Position {
    public static final Position ORIGIN = new Position(0, 0);
    public final int x;
    public final int y;

    public Position(int x, int y) {
        this.x = x;
        this.y = y;
    }

    public static Position of(int x, int y) {
        return new Position(x, y);
    }

    public Position add(Position other) {
        return new Position(this.x + other.x, this.y + other.y);
    }

    public Position add(int x, int y) {
        return new Position(this.x + x, this.y + y);
    }

    public Position subtract(Position other) {
        return new Position(this.x - other.x, this.y - other.y);
    }

    public Position add(Size size) {
        return new Position(this.x + size.width, this.y + size.height);
    }

    public Position addX(int x) {
        return new Position(this.x + x, this.y);
    }

    public Position addY(int y) {
        return new Position(this.x, this.y + y);
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Position)) {
            return false;
        }
        Position position = (Position)o;
        return this.x == position.x && this.y == position.y;
    }

    public int hashCode() {
        return Objects.hash(this.x, this.y);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("x", this.x).add("y", this.y).toString();
    }

    public Vector2f vector2f() {
        return new Vector2f((float)this.x, (float)this.y);
    }

    public Vec2 vec2() {
        return new Vec2((float)this.x, (float)this.y);
    }
}

