/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.pipelike;

import com.lowdragmc.lowdraglib.pipelike.Node;
import com.lowdragmc.lowdraglib.pipelike.PipeNet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.saveddata.SavedData;

public abstract class LevelPipeNet<NodeDataType, T extends PipeNet<NodeDataType>>
extends SavedData {
    private final ServerLevel serverLevel;
    protected List<T> pipeNets = new ArrayList<T>();
    protected final Map<ChunkPos, List<T>> pipeNetsByChunk = new HashMap<ChunkPos, List<T>>();

    public LevelPipeNet(ServerLevel serverLevel) {
        this.serverLevel = serverLevel;
    }

    public LevelPipeNet(ServerLevel serverLevel, CompoundTag tag) {
        this(serverLevel);
        this.pipeNets = new ArrayList<T>();
        ListTag allEnergyNets = tag.m_128437_("PipeNets", 10);
        for (int i = 0; i < allEnergyNets.size(); ++i) {
            CompoundTag pNetTag = allEnergyNets.m_128728_(i);
            T pipeNet = this.createNetInstance();
            ((PipeNet)pipeNet).deserializeNBT(pNetTag);
            this.addPipeNetSilently(pipeNet);
        }
        this.init();
    }

    public ServerLevel getWorld() {
        return this.serverLevel;
    }

    protected void init() {
        this.pipeNets.forEach(PipeNet::onNodeConnectionsUpdate);
    }

    public void addNode(BlockPos nodePos, NodeDataType nodeData, int mark, int openConnections, boolean isActive) {
        PipeNet<Object> myPipeNet = null;
        Node<NodeDataType> node = new Node<NodeDataType>(nodeData, openConnections, mark, isActive);
        for (Direction facing : Direction.values()) {
            Node secondNode;
            BlockPos offsetPos = nodePos.m_121945_(facing);
            T pipeNet = this.getNetFromPos(offsetPos);
            Node node2 = secondNode = pipeNet == null ? null : ((PipeNet)pipeNet).getAllNodes().get(offsetPos);
            if (pipeNet == null || !((PipeNet)pipeNet).canAttachNode(nodeData) || !((PipeNet)pipeNet).canNodesConnect(secondNode, facing.m_122424_(), node, null)) continue;
            if (myPipeNet == null) {
                myPipeNet = pipeNet;
                myPipeNet.addNode(nodePos, node);
                continue;
            }
            if (myPipeNet == pipeNet) continue;
            myPipeNet.uniteNetworks((PipeNet<Object>)pipeNet);
        }
        if (myPipeNet == null) {
            myPipeNet = (PipeNet<Object>)this.createNetInstance();
            myPipeNet.addNode(nodePos, node);
            this.addPipeNet(myPipeNet);
            this.m_77762_();
        }
    }

    protected void addPipeNetToChunk(ChunkPos chunkPos, T pipeNet) {
        this.pipeNetsByChunk.computeIfAbsent(chunkPos, any -> new ArrayList()).add(pipeNet);
    }

    protected void removePipeNetFromChunk(ChunkPos chunkPos, T pipeNet) {
        List<T> list = this.pipeNetsByChunk.get(chunkPos);
        if (list != null) {
            list.remove(pipeNet);
        }
        if (list.isEmpty()) {
            this.pipeNetsByChunk.remove(chunkPos);
        }
    }

    public void removeNode(BlockPos nodePos) {
        T pipeNet = this.getNetFromPos(nodePos);
        if (pipeNet != null) {
            ((PipeNet)pipeNet).removeNode(nodePos);
        }
    }

    public void updateBlockedConnections(BlockPos nodePos, Direction side, boolean isBlocked) {
        T pipeNet = this.getNetFromPos(nodePos);
        if (pipeNet != null) {
            ((PipeNet)pipeNet).updateBlockedConnections(nodePos, side, isBlocked);
        }
    }

    public void updateData(BlockPos nodePos, NodeDataType data) {
        T pipeNet = this.getNetFromPos(nodePos);
        if (pipeNet != null) {
            ((PipeNet)pipeNet).updateNodeData(nodePos, data);
        }
    }

    public void updateMark(BlockPos nodePos, int newMark) {
        T pipeNet = this.getNetFromPos(nodePos);
        if (pipeNet != null) {
            ((PipeNet)pipeNet).updateMark(nodePos, newMark);
        }
    }

    public T getNetFromPos(BlockPos blockPos) {
        List pipeNetsInChunk = this.pipeNetsByChunk.getOrDefault(new ChunkPos(blockPos), Collections.emptyList());
        for (PipeNet pipeNet : pipeNetsInChunk) {
            if (!pipeNet.containsNode(blockPos)) continue;
            return (T)pipeNet;
        }
        return null;
    }

    protected void addPipeNet(T pipeNet) {
        this.addPipeNetSilently(pipeNet);
    }

    protected void addPipeNetSilently(T pipeNet) {
        this.pipeNets.add(pipeNet);
        ((PipeNet)pipeNet).getContainedChunks().forEach(chunkPos -> this.addPipeNetToChunk((ChunkPos)chunkPos, pipeNet));
        ((PipeNet)pipeNet).isValid = true;
    }

    protected void removePipeNet(T pipeNet) {
        this.pipeNets.remove(pipeNet);
        ((PipeNet)pipeNet).getContainedChunks().forEach(chunkPos -> this.removePipeNetFromChunk((ChunkPos)chunkPos, pipeNet));
        ((PipeNet)pipeNet).isValid = false;
        this.m_77762_();
    }

    protected abstract T createNetInstance();

    public CompoundTag m_7176_(CompoundTag compound) {
        ListTag allPipeNets = new ListTag();
        for (PipeNet pipeNet : this.pipeNets) {
            CompoundTag pNetTag = pipeNet.serializeNBT();
            allPipeNets.add((Object)pNetTag);
        }
        compound.m_128365_("PipeNets", (Tag)allPipeNets);
        return compound;
    }
}

