/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.networking.s2c;

import com.lowdragmc.lowdraglib.gui.factory.UIFactory;
import com.lowdragmc.lowdraglib.networking.IHandlerContext;
import com.lowdragmc.lowdraglib.networking.IPacket;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class SPacketUIOpen
implements IPacket {
    private ResourceLocation uiFactoryId;
    private FriendlyByteBuf serializedHolder;
    private int windowId;

    public SPacketUIOpen(ResourceLocation uiFactoryId, FriendlyByteBuf serializedHolder, int windowId) {
        this.uiFactoryId = uiFactoryId;
        this.serializedHolder = serializedHolder;
        this.windowId = windowId;
    }

    @Override
    public void encode(FriendlyByteBuf buf) {
        buf.m_130130_(this.serializedHolder.readableBytes());
        buf.writeBytes((ByteBuf)this.serializedHolder);
        buf.m_130085_(this.uiFactoryId);
        buf.m_130130_(this.windowId);
    }

    @Override
    public void decode(FriendlyByteBuf buf) {
        ByteBuf directSliceBuffer = buf.readBytes(buf.m_130242_());
        ByteBuf copiedDataBuffer = Unpooled.copiedBuffer((ByteBuf)directSliceBuffer);
        directSliceBuffer.release();
        this.serializedHolder = new FriendlyByteBuf(copiedDataBuffer);
        this.uiFactoryId = buf.m_130281_();
        this.windowId = buf.m_130242_();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void execute(IHandlerContext handler) {
        UIFactory<?> uiFactory;
        if (handler.isClient() && (uiFactory = UIFactory.FACTORIES.get(this.uiFactoryId)) != null) {
            uiFactory.initClientUI(this.serializedHolder, this.windowId);
        }
    }

    public SPacketUIOpen() {
    }
}

