/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.gui.widget.codeeditor.language;

import com.lowdragmc.lowdraglib.gui.widget.codeeditor.Document;
import com.lowdragmc.lowdraglib.gui.widget.codeeditor.FoldableRegion;
import java.util.ArrayList;
import java.util.List;

public class FoldingManager {
    private List<FoldableRegion> regions = new ArrayList<FoldableRegion>();

    public void updateFoldingRegions(Document document) {
        this.regions.clear();
        for (int i = 0; i < document.getLineCount(); ++i) {
            String line = document.getLine(i).trim();
            if (!line.endsWith("{")) continue;
            int startLine = i;
            int endLine = this.findMatchingBrace(document, i);
            if (endLine <= startLine) continue;
            this.regions.add(new FoldableRegion(startLine, endLine));
            i = endLine;
        }
    }

    private int findMatchingBrace(Document document, int startLine) {
        int braceCount = 0;
        for (int i = startLine; i < document.getLineCount(); ++i) {
            String line = document.getLine(i);
            for (char c : line.toCharArray()) {
                if (c == '{') {
                    ++braceCount;
                    continue;
                }
                if (c != '}' || --braceCount != 0) continue;
                return i;
            }
        }
        return startLine;
    }

    public void toggleFold(int line) {
        for (FoldableRegion region : this.regions) {
            if (region.getStartLine() != line) continue;
            region.toggle();
            break;
        }
    }

    public boolean isLineVisible(int line) {
        for (FoldableRegion region : this.regions) {
            if (!region.isCollapsed() || line <= region.getStartLine() || line > region.getEndLine()) continue;
            return false;
        }
        return true;
    }

    public List<FoldableRegion> getRegions() {
        return this.regions;
    }
}

