/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.gui.graphprocessor.nodes.value;

import com.lowdragmc.lowdraglib.gui.editor.annotation.LDLRegister;
import com.lowdragmc.lowdraglib.gui.editor.configurator.ConfiguratorGroup;
import com.lowdragmc.lowdraglib.gui.editor.configurator.WrapperConfigurator;
import com.lowdragmc.lowdraglib.gui.graphprocessor.annotation.InputPort;
import com.lowdragmc.lowdraglib.gui.graphprocessor.annotation.OutputPort;
import com.lowdragmc.lowdraglib.gui.graphprocessor.data.BaseNode;
import com.lowdragmc.lowdraglib.gui.graphprocessor.data.NodePort;
import com.lowdragmc.lowdraglib.gui.graphprocessor.nodes.utils.PrintNode;
import com.lowdragmc.lowdraglib.gui.widget.codeeditor.CodeEditorWidget;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import java.util.List;
import java.util.Objects;

@LDLRegister(name="string", group="graph_processor.node.value")
public class StringNode
extends BaseNode {
    @InputPort
    public Object in;
    @OutputPort
    public String out;
    @Persisted
    private String internalValue;

    @Override
    public void process() {
        this.out = this.in == null ? Objects.requireNonNullElse(this.internalValue, "") : PrintNode.format(this.in);
    }

    @Override
    public int getMinWidth() {
        return 150;
    }

    @Override
    public void buildConfigurator(ConfiguratorGroup father) {
        for (NodePort port : this.getInputPorts()) {
            if (!port.fieldName.equals("in") || port.getEdges().isEmpty()) continue;
            return;
        }
        CodeEditorWidget codeEditor = new CodeEditorWidget(0, 0, this.getMinWidth(), 100);
        codeEditor.setLines(List.of(this.internalValue == null ? "" : this.internalValue));
        codeEditor.setOnTextChanged(lines -> {
            this.internalValue = String.join((CharSequence)"\n", lines);
        });
        father.addConfigurators(new WrapperConfigurator(codeEditor));
    }

    public String getInternalValue() {
        return this.internalValue;
    }
}

