/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.gui.graphprocessor.nodes.minecraft.data;

import com.lowdragmc.lowdraglib.gui.editor.annotation.ConfigSetter;
import com.lowdragmc.lowdraglib.gui.editor.annotation.Configurable;
import com.lowdragmc.lowdraglib.gui.editor.annotation.LDLRegister;
import com.lowdragmc.lowdraglib.gui.editor.configurator.ConfiguratorGroup;
import com.lowdragmc.lowdraglib.gui.editor.configurator.StringConfigurator;
import com.lowdragmc.lowdraglib.gui.graphprocessor.annotation.CustomPortBehavior;
import com.lowdragmc.lowdraglib.gui.graphprocessor.annotation.CustomPortOutput;
import com.lowdragmc.lowdraglib.gui.graphprocessor.annotation.InputPort;
import com.lowdragmc.lowdraglib.gui.graphprocessor.annotation.OutputPort;
import com.lowdragmc.lowdraglib.gui.graphprocessor.data.BaseNode;
import com.lowdragmc.lowdraglib.gui.graphprocessor.data.NodePort;
import com.lowdragmc.lowdraglib.gui.graphprocessor.data.PortData;
import com.lowdragmc.lowdraglib.gui.graphprocessor.data.PortEdge;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import java.util.Collections;
import java.util.List;
import net.minecraft.nbt.ByteTag;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.DoubleTag;
import net.minecraft.nbt.FloatTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.LongTag;
import net.minecraft.nbt.ShortTag;
import net.minecraft.nbt.Tag;

@LDLRegister(name="compound reader", group="graph_processor.node.minecraft.data")
public class CompoundReaderNode
extends BaseNode {
    @InputPort
    public CompoundTag tag;
    @InputPort
    public String key;
    @OutputPort
    public Object out;
    @Configurable(showName=false)
    public Type type = Type.STRING;
    @Persisted
    public String internalKey = "";

    @Override
    public void buildConfigurator(ConfiguratorGroup father) {
        super.buildConfigurator(father);
        for (NodePort port : this.getInputPorts()) {
            if (!port.fieldName.equals("key") || !port.getEdges().isEmpty()) continue;
            StringConfigurator stringConfigurator = new StringConfigurator("key", () -> this.internalKey, s -> {
                this.internalKey = s;
            }, "", true);
            father.addConfigurators(stringConfigurator);
        }
    }

    @Override
    public int getMinWidth() {
        return 120;
    }

    @Override
    public void process() {
        Tag tag;
        if (this.tag == null) {
            this.out = null;
            return;
        }
        String realKey = this.key;
        if (realKey == null) {
            realKey = this.internalKey;
        }
        if (this.type == Type.STRING) {
            this.out = this.tag.m_128461_(realKey);
        } else if (this.type == Type.NUMBER) {
            this.out = Float.valueOf(this.tag.m_128457_(realKey));
        } else if (this.type == Type.BOOL) {
            this.out = this.tag.m_128471_(realKey);
        } else if (this.type == Type.COMPOUND) {
            this.out = this.tag.m_128469_(realKey);
        } else if (this.type == Type.LIST && (tag = this.tag.m_128423_(realKey)) instanceof ListTag) {
            ListTag listTag = (ListTag)tag;
            switch (listTag.m_7264_()) {
                case 8: {
                    this.out = listTag.stream().map(Tag::m_7916_).toList();
                    break;
                }
                case 5: {
                    this.out = listTag.stream().map(FloatTag.class::cast).map(FloatTag::m_7057_).toList();
                    break;
                }
                case 6: {
                    this.out = listTag.stream().map(DoubleTag.class::cast).map(DoubleTag::m_7057_).toList();
                    break;
                }
                case 3: {
                    this.out = listTag.stream().map(IntTag.class::cast).map(IntTag::m_7057_).toList();
                    break;
                }
                case 4: {
                    this.out = listTag.stream().map(LongTag.class::cast).map(LongTag::m_7057_).toList();
                    break;
                }
                case 2: {
                    this.out = listTag.stream().map(ShortTag.class::cast).map(ShortTag::m_7057_).toList();
                    break;
                }
                case 10: {
                    this.out = listTag.stream().map(CompoundTag.class::cast).toList();
                    break;
                }
                case 1: {
                    this.out = listTag.stream().map(ByteTag.class::cast).map(t -> t.m_7063_() != 0).toList();
                    break;
                }
                case 9: {
                    this.out = listTag.stream().map(ListTag.class::cast).toList();
                    break;
                }
                default: {
                    this.out = Collections.emptyList();
                }
            }
        }
    }

    public Class<?> getDisplayType() {
        return switch (this.type) {
            default -> throw new IncompatibleClassChangeError();
            case Type.STRING -> String.class;
            case Type.NUMBER -> Float.class;
            case Type.BOOL -> Boolean.class;
            case Type.COMPOUND -> CompoundTag.class;
            case Type.LIST -> List.class;
        };
    }

    @ConfigSetter(field="type")
    public void setType(Type type) {
        this.type = type;
        for (NodePort outputPort : this.getOutputPorts()) {
            outputPort.portData.displayType = this.getDisplayType();
        }
    }

    @CustomPortBehavior(field="out")
    public List<PortData> modifyOutPort(List<PortEdge> edges) {
        return List.of(new PortData().displayName("out").identifier("out").acceptMultipleEdges(true).displayType(this.getDisplayType()));
    }

    @CustomPortOutput(field="out")
    public void pushOut(List<PortEdge> outputEdges, NodePort outputPort) {
        for (PortEdge edge : outputEdges) {
            edge.passThroughBuffer = this.out;
        }
    }

    public static enum Type {
        STRING,
        NUMBER,
        BOOL,
        COMPOUND,
        LIST;

    }
}

