/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.gui.graphprocessor.nodes.minecraft.data;

import com.lowdragmc.lowdraglib.gui.editor.annotation.Configurable;
import com.lowdragmc.lowdraglib.gui.editor.annotation.LDLRegister;
import com.lowdragmc.lowdraglib.gui.editor.configurator.ConfiguratorGroup;
import com.lowdragmc.lowdraglib.gui.graphprocessor.annotation.InputPort;
import com.lowdragmc.lowdraglib.gui.graphprocessor.annotation.OutputPort;
import com.lowdragmc.lowdraglib.gui.graphprocessor.data.BaseNode;
import com.lowdragmc.lowdraglib.gui.graphprocessor.data.NodePort;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.TagParser;

@LDLRegister(name="compound", group="graph_processor.node.minecraft.data")
public class CompoundNode
extends BaseNode {
    @InputPort
    public Object in = null;
    @OutputPort
    public CompoundTag out = null;
    @Configurable(showName=false)
    public CompoundTag internalValue = new CompoundTag();

    @Override
    public int getMinWidth() {
        return 120;
    }

    @Override
    public void process() {
        if (this.in == null) {
            this.out = this.internalValue;
            return;
        }
        Object object = this.in;
        if (object instanceof CompoundTag) {
            CompoundTag compoundTag;
            this.out = compoundTag = (CompoundTag)object;
        } else {
            try {
                this.out = TagParser.m_129359_((String)this.in.toString());
            }
            catch (CommandSyntaxException e) {
                this.out = null;
            }
        }
        this.internalValue = this.out;
    }

    @Override
    public void buildConfigurator(ConfiguratorGroup father) {
        for (NodePort port : this.getInputPorts()) {
            if (!port.fieldName.equals("in") || port.getEdges().isEmpty()) continue;
            return;
        }
        super.buildConfigurator(father);
    }
}

