/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.gui.graphprocessor.nodes.logic;

import com.lowdragmc.lowdraglib.gui.editor.annotation.LDLRegister;
import com.lowdragmc.lowdraglib.gui.graphprocessor.annotation.InputPort;
import com.lowdragmc.lowdraglib.gui.graphprocessor.annotation.OutputPort;
import com.lowdragmc.lowdraglib.gui.graphprocessor.data.NodePort;
import com.lowdragmc.lowdraglib.gui.graphprocessor.data.trigger.TriggerLink;
import com.lowdragmc.lowdraglib.gui.graphprocessor.data.trigger.TriggerNode;
import java.util.Collections;
import java.util.List;

@LDLRegister(name="for loop", group="graph_processor.node.logic")
public class ForLoopNode
extends TriggerNode {
    @OutputPort(name="loop body")
    public TriggerLink loopBody;
    @OutputPort(name="loop completed")
    public TriggerLink loopCompleted;
    @OutputPort
    public int index;
    @InputPort
    public int start;
    @InputPort
    public int end;
    public boolean isLooping = false;

    @Override
    protected void process() {
        ++this.index;
    }

    @Override
    public void resetNode() {
        super.resetNode();
        this.isLooping = false;
    }

    @Override
    public List<TriggerNode> getNextTriggerNodes() {
        for (NodePort port : this.self().getOutputPorts()) {
            if (port.fieldInfo.getType() != TriggerLink.class || !port.fieldInfo.getName().equals("loopCompleted")) continue;
            return port.getEdges().stream().map(e -> (TriggerNode)e.inputNode).toList();
        }
        return Collections.emptyList();
    }

    public List<TriggerNode> getExecutedNodesLoopBody() {
        for (NodePort port : this.self().getOutputPorts()) {
            if (port.fieldInfo.getType() != TriggerLink.class || !port.fieldInfo.getName().equals("loopBody")) continue;
            return port.getEdges().stream().map(e -> (TriggerNode)e.inputNode).toList();
        }
        return Collections.emptyList();
    }
}

