/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.gui.editor.accessors;

import com.lowdragmc.lowdraglib.gui.editor.accessors.TypesAccessor;
import com.lowdragmc.lowdraglib.gui.editor.annotation.ConfigAccessor;
import com.lowdragmc.lowdraglib.gui.editor.annotation.NumberRange;
import com.lowdragmc.lowdraglib.gui.editor.configurator.Configurator;
import com.lowdragmc.lowdraglib.gui.editor.configurator.RangeConfigurator;
import com.lowdragmc.lowdraglib.utils.Range;
import com.lowdragmc.lowdraglib.utils.ReflectionUtils;
import java.lang.reflect.Field;
import java.util.function.Consumer;
import java.util.function.Supplier;

@ConfigAccessor
public class RangeAccessor
extends TypesAccessor<Range> {
    public RangeAccessor() {
        super(Range.class);
    }

    @Override
    public Range defaultValue(Field field, Class<?> type) {
        NumberRange range;
        if (field.isAnnotationPresent(NumberRange.class) && (range = field.getAnnotation(NumberRange.class)).range().length > 1) {
            return new Range(range.range()[0], range.range()[1]);
        }
        return new Range(Float.valueOf(0.0f), Float.valueOf(1.0f));
    }

    @Override
    public Configurator create(String name, Supplier<Range> supplier, Consumer<Range> consumer, boolean forceUpdate, Field field) {
        RangeConfigurator configurator = new RangeConfigurator(name, supplier, consumer, (Range)this.defaultValue(field, (Class)ReflectionUtils.getRawType(field.getGenericType())), forceUpdate);
        if (field.isAnnotationPresent(NumberRange.class)) {
            NumberRange range = field.getAnnotation(NumberRange.class);
            configurator = configurator.setRange(range.range()[0], range.range()[1]).setWheel(range.wheel());
        }
        return configurator;
    }
}

