/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.client.bakedpipeline;

import com.lowdragmc.lowdraglib.client.bakedpipeline.FaceQuadBakery;
import net.minecraft.client.model.geom.builders.UVPair;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BlockElementFace;
import net.minecraft.client.renderer.block.model.BlockFaceUV;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BlockModelRotation;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.core.Direction;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Vector3f;

@OnlyIn(value=Dist.CLIENT)
public class FaceQuad {
    public static final AABB BLOCK = new AABB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);

    public static BakedQuad bakeFace(AABB cube, Direction face, TextureAtlasSprite sprite, ModelState rotation, int tintIndex, int emissivity, boolean cull, boolean shade) {
        return new FaceQuadBakery().bakeQuad(new Vector3f((float)cube.f_82288_ * 16.0f, (float)cube.f_82289_ * 16.0f, (float)cube.f_82290_ * 16.0f), new Vector3f((float)cube.f_82291_ * 16.0f, (float)cube.f_82292_ * 16.0f, (float)cube.f_82293_ * 16.0f), new BlockElementFace((Direction)(cull ? face : null), tintIndex, "", new BlockFaceUV(new float[]{0.0f, 0.0f, 16.0f, 16.0f}, 0)), sprite, face, rotation, null, shade, emissivity);
    }

    public static BakedQuad bakeFace(Direction face, TextureAtlasSprite sprite, ModelState rotation, int tintIndex, int emissivity, boolean cull, boolean shade) {
        return FaceQuad.bakeFace(BLOCK, face, sprite, rotation, tintIndex, emissivity, cull, shade);
    }

    public static BakedQuad bakeFace(Direction face, TextureAtlasSprite sprite, ModelState rotation, int tintIndex, int emissivity) {
        return FaceQuad.bakeFace(face, sprite, rotation, tintIndex, emissivity, true, true);
    }

    public static BakedQuad bakeFace(Direction face, TextureAtlasSprite sprite, ModelState rotation, int tintIndex) {
        return FaceQuad.bakeFace(face, sprite, rotation, tintIndex, 0);
    }

    public static BakedQuad bakeFace(Direction face, TextureAtlasSprite sprite, ModelState rotation) {
        return FaceQuad.bakeFace(face, sprite, rotation, -1);
    }

    public static BakedQuad bakeFace(Direction face, TextureAtlasSprite sprite) {
        return FaceQuad.bakeFace(face, sprite, (ModelState)BlockModelRotation.X0_Y0);
    }

    public static Builder builder(Direction face, TextureAtlasSprite sprite) {
        return new Builder(face, sprite);
    }

    public static class Builder {
        Vector3f from = new Vector3f(0.0f, 0.0f, 0.0f);
        Vector3f to = new Vector3f(16.0f, 16.0f, 16.0f);
        Direction face;
        TextureAtlasSprite sprite;
        ModelState rotation = BlockModelRotation.X0_Y0;
        int tintIndex = -1;
        int emissivity = 0;
        boolean cull = true;
        boolean shade = true;
        UVPair uv0 = new UVPair(0.0f, 0.0f);
        UVPair uv1 = new UVPair(16.0f, 16.0f);

        protected Builder(Direction face, TextureAtlasSprite sprite) {
            this.face = face;
            this.sprite = sprite;
        }

        public Builder cube(AABB cube) {
            this.from = new Vector3f((float)cube.f_82288_ * 16.0f, (float)cube.f_82289_ * 16.0f, (float)cube.f_82290_ * 16.0f);
            this.to = new Vector3f((float)cube.f_82291_ * 16.0f, (float)cube.f_82292_ * 16.0f, (float)cube.f_82293_ * 16.0f);
            return this;
        }

        public Builder uv0(float u0, float v0) {
            this.uv0 = new UVPair(u0, v0);
            return this;
        }

        public Builder uv1(float u1, float v1) {
            this.uv1 = new UVPair(u1, v1);
            return this;
        }

        public Builder cubeUV() {
            return switch (this.face) {
                default -> throw new IncompatibleClassChangeError();
                case Direction.UP -> this.uv0(this.from.x(), this.from.z()).uv1(this.to.x(), this.to.z());
                case Direction.DOWN -> this.uv0(this.from.x(), this.to.z()).uv1(this.to.x(), this.from.z());
                case Direction.NORTH -> this.uv0(this.to.x(), this.to.y()).uv1(this.from.x(), this.from.y());
                case Direction.SOUTH -> this.uv0(this.from.x(), this.to.y()).uv1(this.to.x(), this.from.y());
                case Direction.WEST -> this.uv0(this.from.z(), this.to.y()).uv1(this.to.z(), this.from.y());
                case Direction.EAST -> this.uv0(this.to.z(), this.to.y()).uv1(this.from.z(), this.from.y());
            };
        }

        public BakedQuad bake() {
            return new FaceQuadBakery().bakeQuad(this.from, this.to, new BlockElementFace(this.cull ? this.face : null, this.tintIndex, "", new BlockFaceUV(new float[]{this.uv0.m_171612_(), this.uv0.m_171613_(), this.uv1.m_171612_(), this.uv1.m_171613_()}, 0)), this.sprite, this.face, this.rotation, null, this.shade, this.emissivity);
        }

        public Builder from(Vector3f from) {
            this.from = from;
            return this;
        }

        public Builder to(Vector3f to) {
            this.to = to;
            return this;
        }

        public Builder face(Direction face) {
            this.face = face;
            return this;
        }

        public Builder sprite(TextureAtlasSprite sprite) {
            this.sprite = sprite;
            return this;
        }

        public Builder rotation(ModelState rotation) {
            this.rotation = rotation;
            return this;
        }

        public Builder tintIndex(int tintIndex) {
            this.tintIndex = tintIndex;
            return this;
        }

        public Builder emissivity(int emissivity) {
            this.emissivity = emissivity;
            return this;
        }

        public Builder cull(boolean cull) {
            this.cull = cull;
            return this;
        }

        public Builder shade(boolean shade) {
            this.shade = shade;
            return this;
        }

        public Builder uv0(UVPair uv0) {
            this.uv0 = uv0;
            return this;
        }

        public Builder uv1(UVPair uv1) {
            this.uv1 = uv1;
            return this;
        }
    }
}

