/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.items;

import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.items.IItemHandler;
import net.povstalec.sgjourney.common.capabilities.ItemPowerCellProvider;
import net.povstalec.sgjourney.common.capabilities.SGJourneyEnergy;
import net.povstalec.sgjourney.common.config.CommonTechConfig;
import net.povstalec.sgjourney.common.init.FluidInit;
import net.povstalec.sgjourney.common.init.ItemInit;
import net.povstalec.sgjourney.common.items.FluidItem;
import net.povstalec.sgjourney.common.items.VialItem;
import net.povstalec.sgjourney.common.misc.ComponentHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PowerCellItem
extends FluidItem.Holder {
    public PowerCellItem(Item.Properties properties) {
        super(properties);
    }

    @Override
    public boolean isCorrectFluid(FluidStack fluidStack) {
        return fluidStack.getFluid() == FluidInit.LIQUID_NAQUADAH_SOURCE.get() || fluidStack.getFluid() == FluidInit.HEAVY_LIQUID_NAQUADAH_SOURCE.get();
    }

    @Override
    public ItemStack getHeldItem(ItemStack holderStack) {
        IItemHandler itemHandler = holderStack.getCapability(ForgeCapabilities.ITEM_HANDLER).resolve().orElse(null);
        if (itemHandler == null) {
            return ItemStack.f_41583_;
        }
        return itemHandler.getStackInSlot(0);
    }

    @Override
    public boolean isValidItem(ItemStack heldStack) {
        return heldStack.m_41720_() instanceof VialItem;
    }

    public long getBufferEnergy(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        if (!stack.m_41782_() || !tag.m_128425_("energy", 4)) {
            return 0L;
        }
        return tag.m_128454_("energy");
    }

    public long getEnergyTransfer(ItemStack stack) {
        return (Long)CommonTechConfig.naquadah_power_cell_max_transfer.get();
    }

    public long getBufferCapacity(ItemStack stack) {
        return (Long)CommonTechConfig.naquadah_power_cell_buffer_capacity.get();
    }

    @Override
    public ICapabilityProvider initCapabilities(ItemStack stack, CompoundTag tag) {
        return new ItemPowerCellProvider(stack){

            @Override
            public boolean isValid(@NotNull ItemStack stack) {
                return PowerCellItem.this.isValidItem(stack);
            }

            @Override
            public long energyCapacity() {
                return PowerCellItem.this.getBufferCapacity(this.stack);
            }

            @Override
            public long energyMaxTransfer() {
                return PowerCellItem.this.getEnergyTransfer(this.stack);
            }

            @NotNull
            public FluidStack getFluidInTank(int tank) {
                return PowerCellItem.this.getFluidStack(this.stack);
            }

            public int getTankCapacity(int tank) {
                return PowerCellItem.this.getFluidCapacity(this.stack);
            }

            public boolean isFluidValid(int tank, @NotNull FluidStack fluidStack) {
                return PowerCellItem.this.isCorrectFluid(fluidStack);
            }
        };
    }

    @Override
    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltipComponents, TooltipFlag isAdvanced) {
        tooltipComponents.add((Component)Component.m_237115_((String)"tooltip.sgjourney.energy_buffer").m_7220_((Component)Component.m_237113_((String)(": " + SGJourneyEnergy.energyToString(this.getBufferEnergy(stack), this.getBufferCapacity(stack))))).m_130940_(ChatFormatting.DARK_RED));
        super.m_7373_(stack, level, tooltipComponents, isAdvanced);
        tooltipComponents.add((Component)ComponentHelper.description("tooltip.sgjourney.naquadah_power_cell.description"));
        tooltipComponents.add((Component)ComponentHelper.usage("tooltip.sgjourney.naquadah_power_cell.reload").m_130940_(ChatFormatting.GRAY).m_130940_(ChatFormatting.ITALIC));
    }

    public static ItemStack liquidNaquadahSetup() {
        ItemStack stack = new ItemStack((ItemLike)ItemInit.NAQUADAH_POWER_CELL.get());
        stack.getCapability(ForgeCapabilities.ITEM_HANDLER).ifPresent(itemHandler -> itemHandler.insertItem(0, VialItem.liquidNaquadahSetup(), false));
        return stack;
    }

    public static ItemStack heavyLiquidNaquadahSetup() {
        ItemStack stack = new ItemStack((ItemLike)ItemInit.NAQUADAH_POWER_CELL.get());
        stack.getCapability(ForgeCapabilities.ITEM_HANDLER).ifPresent(itemHandler -> itemHandler.insertItem(0, VialItem.heavyLiquidNaquadahSetup(), false));
        return stack;
    }
}

