/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.blocks.dhd;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.povstalec.sgjourney.common.block_entities.ProtectedBlockEntity;
import net.povstalec.sgjourney.common.block_entities.StructureGenEntity;
import net.povstalec.sgjourney.common.block_entities.dhd.AbstractDHDEntity;
import net.povstalec.sgjourney.common.blocks.ProtectedBlock;
import net.povstalec.sgjourney.common.misc.ComponentHelper;

public abstract class AbstractDHDBlock
extends HorizontalDirectionalBlock
implements EntityBlock,
ProtectedBlock {
    public AbstractDHDBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)f_54117_, (Comparable)Direction.NORTH));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> state) {
        state.m_61104_(new Property[]{f_54117_});
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    public BlockState m_6843_(BlockState state, Rotation rotation) {
        return (BlockState)state.m_61124_((Property)f_54117_, (Comparable)rotation.m_55954_((Direction)state.m_61143_((Property)f_54117_)));
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_((Property)f_54117_, (Comparable)context.m_8125_().m_122424_());
    }

    public void m_6810_(BlockState oldState, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        BlockEntity blockEntity;
        if (level.m_5776_()) {
            return;
        }
        if (oldState.m_60734_() != newState.m_60734_() && (blockEntity = level.m_7702_(pos)) instanceof AbstractDHDEntity) {
            AbstractDHDEntity dhd = (AbstractDHDEntity)blockEntity;
            dhd.unsetStargate();
        }
        super.m_6810_(oldState, level, pos, newState, isMoving);
    }

    public abstract Block getDHD();

    public void m_5707_(Level level, BlockPos pos, BlockState state, Player player) {
        BlockEntity blockentity = level.m_7702_(pos);
        if (blockentity instanceof AbstractDHDEntity && !level.f_46443_ && !player.m_7500_()) {
            ItemStack itemstack = new ItemStack((ItemLike)this.getDHD());
            blockentity.m_187476_(itemstack);
            ItemEntity itementity = new ItemEntity(level, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, itemstack);
            itementity.m_32060_();
            level.m_7967_((Entity)itementity);
        }
        super.m_5707_(level, pos, state, player);
    }

    @Nullable
    protected static <E extends BlockEntity, A extends BlockEntity> BlockEntityTicker<A> createTickerHelper(BlockEntityType<A> typeA, BlockEntityType<E> typeB, BlockEntityTicker<? super E> ticker) {
        return typeB == typeA ? ticker : null;
    }

    public void m_5871_(ItemStack stack, @Nullable BlockGetter getter, List<Component> tooltipComponents, TooltipFlag isAdvanced) {
        CompoundTag blockEntityTag;
        if (stack.m_41782_() && (blockEntityTag = BlockItem.m_186336_((ItemStack)stack)) != null && blockEntityTag.m_128425_("generation_step", 1) && StructureGenEntity.Step.GENERATED != StructureGenEntity.Step.fromByte(blockEntityTag.m_128445_("generation_step"))) {
            tooltipComponents.add((Component)Component.m_237115_((String)"tooltip.sgjourney.generates_inside_structure").m_130940_(ChatFormatting.YELLOW));
        }
        tooltipComponents.add((Component)ComponentHelper.description("tooltip.sgjourney.dhd.description"));
        tooltipComponents.add((Component)ComponentHelper.usage("tooltip.sgjourney.dhd.dialing_menu"));
        tooltipComponents.add((Component)ComponentHelper.usage("tooltip.sgjourney.dhd.crystal_menu"));
        super.m_5871_(stack, getter, tooltipComponents, isAdvanced);
    }

    @Override
    @Nullable
    public ProtectedBlockEntity getProtectedBlockEntity(BlockGetter reader, BlockPos pos, BlockState state) {
        BlockEntity blockEntity = reader.m_7702_(pos);
        if (blockEntity instanceof AbstractDHDEntity) {
            AbstractDHDEntity dhd = (AbstractDHDEntity)blockEntity;
            return dhd;
        }
        return null;
    }

    @Override
    public boolean hasPermissions(BlockGetter reader, BlockPos pos, BlockState state, Player player, boolean sendMessage) {
        BlockEntity blockEntity = reader.m_7702_(pos);
        if (blockEntity instanceof AbstractDHDEntity) {
            AbstractDHDEntity dhd = (AbstractDHDEntity)blockEntity;
            return dhd.hasPermissions(player, sendMessage);
        }
        return true;
    }
}

