/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.block_entities.tech;

import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.network.PacketDistributor;
import net.povstalec.sgjourney.common.init.PacketHandlerInit;
import net.povstalec.sgjourney.common.packets.ClientboundNaquadahLiquidizerUpdatePacket;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractNaquadahLiquidizerEntity
extends BlockEntity {
    private static final String INVENTORY = "Inventory";
    private static final String PROGRESS = "progress";
    private static final String INPUT_INVENTORY = "input_inventory";
    private static final String FLUID_INPUT_INVENTORY = "fluid_input_inventory";
    private static final String FLUID_OUTPUT_INVENTORY = "fluid_output_inventory";
    public static final int TANK_CAPACITY = 4000;
    public static final int MAX_PROGRESS = 100;
    protected final ItemStackHandler itemInputHandler = this.createItemInputHandler();
    protected final LazyOptional<IItemHandler> lazyInputHandler = LazyOptional.of(() -> this.itemInputHandler);
    protected final ItemStackHandler fluidItemInputHandler = this.createFluidItemHandler();
    protected final LazyOptional<IItemHandler> lazyFluidInputHandler = LazyOptional.of(() -> this.fluidItemInputHandler);
    protected final ItemStackHandler fluidItemOutputHandler = this.createFluidItemHandler();
    protected final LazyOptional<IItemHandler> lazyFluidOutputHandler = LazyOptional.of(() -> this.fluidItemOutputHandler);
    protected LazyOptional<IFluidHandler> lazyFluidHandler1 = LazyOptional.empty();
    protected LazyOptional<IFluidHandler> lazyFluidHandler2 = LazyOptional.empty();
    public int progress = 0;
    protected final FluidTank fluidTank1 = new FluidTank(4000){

        protected void onContentsChanged() {
            AbstractNaquadahLiquidizerEntity.this.m_6596_();
        }

        public boolean isFluidValid(FluidStack stack) {
            return stack.getFluid() == AbstractNaquadahLiquidizerEntity.this.getDesiredFluid1();
        }
    };
    protected final FluidTank fluidTank2 = new FluidTank(4000){

        protected void onContentsChanged() {
            AbstractNaquadahLiquidizerEntity.this.m_6596_();
        }

        public boolean isFluidValid(FluidStack stack) {
            return stack.getFluid() == AbstractNaquadahLiquidizerEntity.this.getDesiredFluid2();
        }
    };

    public AbstractNaquadahLiquidizerEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public void onLoad() {
        super.onLoad();
        this.lazyFluidHandler1 = LazyOptional.of(() -> this.fluidTank1);
        this.lazyFluidHandler2 = LazyOptional.of(() -> this.fluidTank2);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.lazyFluidHandler1.invalidate();
        this.lazyFluidHandler2.invalidate();
        this.lazyInputHandler.invalidate();
        this.lazyFluidInputHandler.invalidate();
        this.lazyFluidOutputHandler.invalidate();
    }

    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        if (nbt.m_128441_(INVENTORY)) {
            ItemStackHandler itemHandler = new ItemStackHandler(3);
            itemHandler.deserializeNBT(nbt.m_128469_(INVENTORY));
            this.itemInputHandler.insertItem(0, itemHandler.getStackInSlot(0), false);
            this.fluidItemInputHandler.insertItem(0, itemHandler.getStackInSlot(1), false);
            this.fluidItemOutputHandler.insertItem(0, itemHandler.getStackInSlot(2), false);
        } else {
            this.itemInputHandler.deserializeNBT(nbt.m_128469_(INPUT_INVENTORY));
            this.fluidItemInputHandler.deserializeNBT(nbt.m_128469_(FLUID_INPUT_INVENTORY));
            this.fluidItemOutputHandler.deserializeNBT(nbt.m_128469_(FLUID_OUTPUT_INVENTORY));
        }
        this.fluidTank1.readFromNBT(nbt.m_128469_("FluidTank1"));
        this.fluidTank2.readFromNBT(nbt.m_128469_("FluidTank2"));
        this.progress = nbt.m_128451_(PROGRESS);
    }

    protected void m_183515_(@NotNull CompoundTag nbt) {
        CompoundTag tag1 = new CompoundTag();
        CompoundTag tag2 = new CompoundTag();
        nbt.m_128365_(INPUT_INVENTORY, (Tag)this.itemInputHandler.serializeNBT());
        nbt.m_128365_(FLUID_INPUT_INVENTORY, (Tag)this.fluidItemInputHandler.serializeNBT());
        nbt.m_128365_(FLUID_OUTPUT_INVENTORY, (Tag)this.fluidItemOutputHandler.serializeNBT());
        this.fluidTank1.writeToNBT(tag1);
        nbt.m_128365_("FluidTank1", (Tag)tag1);
        this.fluidTank2.writeToNBT(tag2);
        nbt.m_128365_("FluidTank2", (Tag)tag2);
        nbt.m_128405_(PROGRESS, this.progress);
        super.m_183515_(nbt);
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> capability, Direction side) {
        if (capability == ForgeCapabilities.FLUID_HANDLER) {
            if (side == Direction.DOWN) {
                return this.lazyFluidHandler2.cast();
            }
            return this.lazyFluidHandler1.cast();
        }
        if (capability == ForgeCapabilities.ITEM_HANDLER) {
            if (side == Direction.UP) {
                return this.lazyInputHandler.cast();
            }
            if (side == Direction.DOWN) {
                return this.lazyFluidOutputHandler.cast();
            }
            return this.lazyFluidInputHandler.cast();
        }
        return super.getCapability(capability, side);
    }

    public abstract Fluid getDesiredFluid1();

    public abstract Fluid getDesiredFluid2();

    public void setFluid1(FluidStack fluidStack) {
        this.fluidTank1.setFluid(fluidStack);
    }

    public FluidStack getFluid1() {
        return this.fluidTank1.getFluid();
    }

    public void setFluid2(FluidStack fluidStack) {
        this.fluidTank2.setFluid(fluidStack);
    }

    public FluidStack getFluid2() {
        return this.fluidTank2.getFluid();
    }

    private ItemStackHandler createItemInputHandler() {
        return new ItemStackHandler(1){

            protected void onContentsChanged(int slot) {
                AbstractNaquadahLiquidizerEntity.this.m_6596_();
            }

            public int getSlotLimit(int slot) {
                return 64;
            }
        };
    }

    private ItemStackHandler createFluidItemHandler() {
        return new ItemStackHandler(1){

            protected void onContentsChanged(int slot) {
                AbstractNaquadahLiquidizerEntity.this.m_6596_();
            }

            public int getSlotLimit(int slot) {
                return 1;
            }

            public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
                return stack.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).isPresent();
            }

            @Nonnull
            public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
                if (!this.isItemValid(slot, stack)) {
                    return stack;
                }
                return super.insertItem(slot, stack, simulate);
            }
        };
    }

    public boolean hasFluidItem1() {
        return this.fluidItemInputHandler.getStackInSlot(0).m_41613_() > 0;
    }

    public boolean hasFluidItem2() {
        return this.fluidItemOutputHandler.getStackInSlot(0).m_41613_() > 0;
    }

    public void fillTank1(FluidStack stack, ItemStack container) {
        this.fluidTank1.fill(stack, IFluidHandler.FluidAction.EXECUTE);
        this.fluidItemInputHandler.extractItem(0, 1, false);
        this.fluidItemInputHandler.insertItem(0, container, false);
    }

    public void fillTank2(FluidStack stack, ItemStack container) {
        this.fluidTank1.fill(stack, IFluidHandler.FluidAction.EXECUTE);
    }

    public void drainFluidFromItem() {
        this.fluidItemInputHandler.getStackInSlot(0).getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).ifPresent(handler -> {
            int drainAmount = Math.min(this.fluidTank1.getSpace(), 1000);
            FluidStack fluidStack = handler.getFluidInTank(0);
            if (this.fluidTank1.isFluidValid(fluidStack)) {
                fluidStack = handler.drain(drainAmount, IFluidHandler.FluidAction.EXECUTE);
                this.fillTank1(fluidStack, handler.getContainer());
            }
        });
    }

    public void putFluidInsideItem() {
        ItemStack stack = this.fluidItemOutputHandler.getStackInSlot(0);
        stack.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).ifPresent(handler -> {
            if (!handler.isFluidValid(0, this.getFluid2())) {
                return;
            }
            int fillAmount = handler.fill(this.getFluid2(), IFluidHandler.FluidAction.EXECUTE);
            this.fluidItemOutputHandler.setStackInSlot(0, handler.getContainer());
            this.fluidTank2.drain(fillAmount, IFluidHandler.FluidAction.EXECUTE);
        });
    }

    protected abstract boolean hasMaterial();

    protected abstract void makeLiquidNaquadah();

    protected void useUpItems(int amount) {
        this.itemInputHandler.extractItem(0, amount, false);
    }

    public void outputLiquid() {
        BlockEntity blockEntity = this.f_58857_.m_7702_(this.f_58858_.m_121945_(Direction.DOWN));
        if (blockEntity == null) {
            return;
        }
        blockEntity.getCapability(ForgeCapabilities.FLUID_HANDLER, Direction.UP).ifPresent(fluidHandler -> {
            FluidStack simulatedOutputAmount = this.fluidTank2.drain(100, IFluidHandler.FluidAction.SIMULATE);
            int simulatedReceiveAmount = fluidHandler.fill(simulatedOutputAmount, IFluidHandler.FluidAction.SIMULATE);
            fluidHandler.fill(this.fluidTank2.drain(simulatedReceiveAmount, IFluidHandler.FluidAction.EXECUTE), IFluidHandler.FluidAction.EXECUTE);
        });
    }

    public static void tick(Level level, BlockPos pos, BlockState state, AbstractNaquadahLiquidizerEntity naquadahLiquidizer) {
        if (level.m_5776_()) {
            return;
        }
        if (naquadahLiquidizer.hasFluidItem1()) {
            naquadahLiquidizer.drainFluidFromItem();
        }
        if (naquadahLiquidizer.hasMaterial() && naquadahLiquidizer.fluidTank1.getFluidAmount() > 0 && naquadahLiquidizer.fluidTank2.getFluidAmount() + 100 <= naquadahLiquidizer.fluidTank2.getCapacity()) {
            ++naquadahLiquidizer.progress;
            naquadahLiquidizer.fluidTank1.drain(1, IFluidHandler.FluidAction.EXECUTE);
            AbstractNaquadahLiquidizerEntity.m_155232_((Level)level, (BlockPos)pos, (BlockState)state);
            if (naquadahLiquidizer.progress >= 100) {
                naquadahLiquidizer.makeLiquidNaquadah();
            }
        } else {
            naquadahLiquidizer.progress = 0;
            AbstractNaquadahLiquidizerEntity.m_155232_((Level)level, (BlockPos)pos, (BlockState)state);
        }
        if (naquadahLiquidizer.hasFluidItem2()) {
            naquadahLiquidizer.putFluidInsideItem();
        }
        naquadahLiquidizer.outputLiquid();
        PacketHandlerInit.INSTANCE.send(PacketDistributor.TRACKING_CHUNK.with(() -> level.m_46745_(naquadahLiquidizer.f_58858_)), (Object)new ClientboundNaquadahLiquidizerUpdatePacket(naquadahLiquidizer.f_58858_, naquadahLiquidizer.getFluid1(), naquadahLiquidizer.getFluid2(), naquadahLiquidizer.progress));
    }
}

