/*
 * Decompiled with CFR 0.152.
 */
package dev.bluephs.vintage.content.kinetics.vibration;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import com.simibubi.create.content.contraptions.behaviour.MovementContext;
import com.simibubi.create.content.contraptions.render.ContraptionMatrices;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.base.KineticBlockEntityRenderer;
import com.simibubi.create.foundation.blockEntity.renderer.SafeBlockEntityRenderer;
import com.simibubi.create.foundation.virtualWorld.VirtualRenderWorld;
import dev.bluephs.vintage.VintagePartialModels;
import dev.bluephs.vintage.content.kinetics.vibration.VibratingTableBlock;
import dev.bluephs.vintage.content.kinetics.vibration.VibratingTableBlockEntity;
import dev.engine_room.flywheel.api.visualization.VisualizationManager;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import net.createmod.catnip.math.AngleHelper;
import net.createmod.catnip.math.VecHelper;
import net.createmod.catnip.render.CachedBuffers;
import net.createmod.catnip.render.SuperByteBuffer;
import net.createmod.catnip.render.SuperByteBufferCache;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;

public class VibratingTableRenderer
extends SafeBlockEntityRenderer<VibratingTableBlockEntity> {
    public VibratingTableRenderer(BlockEntityRendererProvider.Context context) {
    }

    protected void renderSafe(VibratingTableBlockEntity be, float partialTicks, PoseStack ms, MultiBufferSource buffer, int light, int overlay) {
        this.renderTable(be, partialTicks, ms, buffer, light);
        this.renderItems(be, partialTicks, ms, buffer, light, overlay);
        if (VisualizationManager.supportsVisualization((LevelAccessor)be.m_58904_())) {
            return;
        }
        this.renderShaft(be, ms, buffer, light, overlay);
    }

    protected void renderTable(VibratingTableBlockEntity be, float partialTicks, PoseStack ms, MultiBufferSource buffer, int light) {
        BlockState blockState = be.m_58900_();
        float offset = 0.0f;
        if (be.haveRecipe()) {
            offset = be.getRenderedHeadOffset(partialTicks);
        }
        SuperByteBuffer superBuffer = CachedBuffers.partialFacing((PartialModel)VintagePartialModels.VIBRATING_TABLE, (BlockState)blockState, (Direction)((Direction)blockState.m_61143_((Property)BlockStateProperties.f_61374_)));
        superBuffer.translate(0.0, (double)offset, 0.0);
        superBuffer.color(0xFFFFFF).light(light).renderInto(ms, buffer.m_6299_(RenderType.m_110457_()));
    }

    protected void renderShaft(VibratingTableBlockEntity be, PoseStack ms, MultiBufferSource buffer, int light, int overlay) {
        KineticBlockEntityRenderer.renderRotatingBuffer((KineticBlockEntity)be, (SuperByteBuffer)this.getRotatedModel(be), (PoseStack)ms, (VertexConsumer)buffer.m_6299_(RenderType.m_110451_()), (int)light);
    }

    protected void renderItems(VibratingTableBlockEntity be, float partialTicks, PoseStack ms, MultiBufferSource buffer, int light, int overlay) {
        boolean output;
        boolean input = !be.inputInv.getStackInSlot(0).m_41619_();
        boolean bl = output = !be.outputInv.getStackInSlot(0).m_41619_();
        if (!input && !output) {
            return;
        }
        float offset = 0.0f;
        if (be.haveRecipe()) {
            offset = be.getRenderedHeadOffset(partialTicks);
        }
        if (input) {
            if (!output) {
                boolean alongZ = be.m_58900_().m_61143_((Property)BlockStateProperties.f_61374_) == Direction.NORTH || be.m_58900_().m_61143_((Property)BlockStateProperties.f_61374_) == Direction.SOUTH;
                ms.m_85836_();
                for (int i = 0; i < be.inputInv.getSlots(); ++i) {
                    ItemStack stack = be.inputInv.getStackInSlot(i);
                    if (stack.m_41619_()) continue;
                    ItemRenderer itemRenderer = Minecraft.m_91087_().m_91291_();
                    BakedModel modelWithOverrides = itemRenderer.m_174264_(stack, be.m_58904_(), null, 0);
                    boolean blockItem = modelWithOverrides.m_7539_();
                    ms.m_85837_(0.5, (double)((blockItem ? 0.925f : 0.875f) + offset), 0.5);
                    ms.m_85841_(0.5f, 0.5f, 0.5f);
                    if (alongZ) {
                        ms.m_252781_(Axis.f_252436_.m_252977_(90.0f));
                    }
                    ms.m_252781_(Axis.f_252529_.m_252977_(90.0f));
                    itemRenderer.m_269128_(stack, ItemDisplayContext.FIXED, light, overlay, ms, buffer, be.m_58904_(), 0);
                    break;
                }
                ms.m_85849_();
            } else {
                boolean blockItem;
                BakedModel modelWithOverrides;
                ItemRenderer itemRenderer;
                ItemStack stack;
                int i;
                ms.m_85836_();
                for (i = 0; i < be.inputInv.getSlots(); ++i) {
                    stack = be.inputInv.getStackInSlot(i);
                    if (stack.m_41619_()) continue;
                    itemRenderer = Minecraft.m_91087_().m_91291_();
                    modelWithOverrides = itemRenderer.m_174264_(stack, be.m_58904_(), null, 0);
                    blockItem = modelWithOverrides.m_7539_();
                    ms.m_85837_(0.33, (double)((blockItem ? 0.925f : 0.875f) + offset), 0.33);
                    ms.m_85841_(0.5f, 0.5f, 0.5f);
                    ms.m_252781_(Axis.f_252529_.m_252977_(90.0f));
                    itemRenderer.m_269128_(stack, ItemDisplayContext.FIXED, light, overlay, ms, buffer, be.m_58904_(), 0);
                    ms.m_252781_(Axis.f_252529_.m_252977_(-90.0f));
                    ms.m_252880_(0.0f, blockItem ? -0.925f : -0.875f, 0.0f);
                    break;
                }
                for (i = 0; i < be.outputInv.getSlots(); ++i) {
                    stack = be.outputInv.getStackInSlot(i);
                    if (stack.m_41619_()) continue;
                    itemRenderer = Minecraft.m_91087_().m_91291_();
                    modelWithOverrides = itemRenderer.m_174264_(stack, be.m_58904_(), null, 0);
                    blockItem = modelWithOverrides.m_7539_();
                    ms.m_85837_(0.66, (double)(blockItem ? 0.925f : 0.875f), 0.66);
                    ms.m_252781_(Axis.f_252529_.m_252977_(90.0f));
                    itemRenderer.m_269128_(stack, ItemDisplayContext.FIXED, light, overlay, ms, buffer, be.m_58904_(), 0);
                    break;
                }
                ms.m_85849_();
            }
        } else if (output) {
            boolean alongZ = be.m_58900_().m_61143_((Property)BlockStateProperties.f_61374_) == Direction.NORTH || be.m_58900_().m_61143_((Property)BlockStateProperties.f_61374_) == Direction.SOUTH;
            ms.m_85836_();
            for (int i = 0; i < be.outputInv.getSlots(); ++i) {
                ItemStack stack = be.outputInv.getStackInSlot(i);
                if (stack.m_41619_()) continue;
                ItemRenderer itemRenderer = Minecraft.m_91087_().m_91291_();
                BakedModel modelWithOverrides = itemRenderer.m_174264_(stack, be.m_58904_(), null, 0);
                boolean blockItem = modelWithOverrides.m_7539_();
                ms.m_85837_(0.5, (double)((blockItem ? 0.925f : 0.875f) + offset), 0.5);
                ms.m_85841_(0.5f, 0.5f, 0.5f);
                if (alongZ) {
                    ms.m_252781_(Axis.f_252436_.m_252977_(90.0f));
                }
                ms.m_252781_(Axis.f_252529_.m_252977_(90.0f));
                itemRenderer.m_269128_(stack, ItemDisplayContext.FIXED, light, overlay, ms, buffer, be.m_58904_(), 0);
                break;
            }
            ms.m_85849_();
        }
    }

    protected SuperByteBuffer getRotatedModel(KineticBlockEntity be) {
        return CachedBuffers.block((SuperByteBufferCache.Compartment)KineticBlockEntityRenderer.KINETIC_BLOCK, (BlockState)this.getRenderedBlockState(be));
    }

    protected BlockState getRenderedBlockState(KineticBlockEntity be) {
        return KineticBlockEntityRenderer.shaft((Direction.Axis)KineticBlockEntityRenderer.getRotationAxisOf((KineticBlockEntity)be));
    }

    public static void renderInContraption(MovementContext context, VirtualRenderWorld renderWorld, ContraptionMatrices matrices, MultiBufferSource buffer) {
        BlockState state = context.state;
        Direction facing = (Direction)state.m_61143_(VibratingTableBlock.HORIZONTAL_FACING);
        Vec3 facingVec = Vec3.m_82528_((Vec3i)((Direction)context.state.m_61143_(VibratingTableBlock.HORIZONTAL_FACING)).m_122436_());
        facingVec = (Vec3)context.rotation.apply(facingVec);
        Direction closestToFacing = Direction.m_122366_((double)facingVec.f_82479_, (double)facingVec.f_82480_, (double)facingVec.f_82481_);
        boolean horizontal = closestToFacing.m_122434_().m_122479_();
        boolean backwards = VecHelper.isVecPointingTowards((Vec3)context.relativeMotion, (Direction)facing.m_122424_());
        boolean moving = context.getAnimationSpeed() != 0.0f;
        boolean shouldAnimate = context.contraption.stalled && horizontal || !context.contraption.stalled && !backwards && moving;
        SuperByteBuffer superBuffer = CachedBuffers.partial((PartialModel)VintagePartialModels.VIBRATING_TABLE, (BlockState)state);
        ((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)superBuffer.transform(matrices.getModel())).center()).rotateY(AngleHelper.horizontalAngle((Direction)facing))).rotateX(AngleHelper.verticalAngle((Direction)facing));
        if (!VibratingTableBlock.isHorizontal(state)) {
            superBuffer.rotateZ(0.0f);
        }
        ((SuperByteBuffer)superBuffer.uncenter()).light(LevelRenderer.m_109541_((BlockAndTintGetter)renderWorld, (BlockPos)context.localPos)).renderInto(matrices.getViewProjection(), buffer.m_6299_(RenderType.m_110457_()));
    }
}

