/*
 * Decompiled with CFR 0.152.
 */
package dev.bluephs.vintage.content.kinetics.laser;

import com.google.gson.JsonObject;
import com.simibubi.create.compat.jei.category.sequencedAssembly.SequencedAssemblySubCategory;
import com.simibubi.create.content.processing.recipe.ProcessingRecipe;
import com.simibubi.create.content.processing.recipe.ProcessingRecipeBuilder;
import com.simibubi.create.content.processing.sequenced.IAssemblyRecipe;
import com.simibubi.create.foundation.recipe.IRecipeTypeInfo;
import dev.bluephs.vintage.Vintage;
import dev.bluephs.vintage.VintageBlocks;
import dev.bluephs.vintage.VintageLang;
import dev.bluephs.vintage.VintageRecipes;
import dev.bluephs.vintage.compat.jei.category.assemblies.AssemblyLaserCutting;
import dev.bluephs.vintage.infrastructure.config.VintageConfig;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.items.wrapper.RecipeWrapper;

@ParametersAreNonnullByDefault
public class LaserCuttingRecipe
extends ProcessingRecipe<RecipeWrapper>
implements IAssemblyRecipe {
    public int energy = 0;
    public int maxChargeRate = 0;

    public LaserCuttingRecipe(ProcessingRecipeBuilder.ProcessingRecipeParams params) {
        super((IRecipeTypeInfo)VintageRecipes.LASER_CUTTING, params);
    }

    public boolean matches(RecipeWrapper inv, Level worldIn) {
        if (inv.m_7983_()) {
            return false;
        }
        return ((Ingredient)this.ingredients.get(0)).test(inv.m_8020_(0));
    }

    protected int getMaxInputCount() {
        return 1;
    }

    protected int getMaxOutputCount() {
        return 2;
    }

    public void addAssemblyIngredients(List<Ingredient> list) {
    }

    @OnlyIn(value=Dist.CLIENT)
    public Component getDescriptionForAssembly() {
        MutableComponent result = VintageLang.translateDirect("recipe.assembly.laser_cutting", new Object[0]);
        if (Vintage.useEnergy || ((Boolean)VintageConfig.server().energy.forceEnergy.get()).booleanValue()) {
            result.m_130946_(" ").m_7220_((Component)VintageLang.translateDirect("recipe.assembly.with", new Object[0])).m_130946_(" " + this.energy).m_130946_("fe");
        }
        return result;
    }

    public void addRequiredMachines(Set<ItemLike> list) {
        list.add((ItemLike)VintageBlocks.LASER.get());
    }

    public Supplier<Supplier<SequencedAssemblySubCategory>> getJEISubCategory() {
        return () -> AssemblyLaserCutting::new;
    }

    public void readAdditional(JsonObject json) {
        if (json.has("energy")) {
            this.energy = json.get("energy").getAsInt();
        }
        if (json.has("maxChargeRate")) {
            this.maxChargeRate = json.get("maxChargeRate").getAsInt();
        }
    }

    public void readAdditional(FriendlyByteBuf buffer) {
        this.energy = buffer.readInt();
        this.maxChargeRate = buffer.readInt();
    }

    public void writeAdditional(JsonObject json) {
        json.addProperty("energy", (Number)this.energy);
        json.addProperty("maxChargeRate", (Number)this.maxChargeRate);
    }

    public void writeAdditional(FriendlyByteBuf buffer) {
        buffer.writeInt(this.energy);
        buffer.writeInt(this.maxChargeRate);
    }

    public int getEnergy() {
        return this.energy;
    }

    public int getMaxChargeRate() {
        return this.maxChargeRate;
    }
}

