/*
 * Decompiled with CFR 0.152.
 */
package dev.bluephs.vintage.content.kinetics.helve_hammer;

import com.simibubi.create.api.equipment.goggles.IProxyHoveringInformation;
import com.simibubi.create.content.equipment.wrench.IWrenchable;
import com.simibubi.create.content.kinetics.base.DirectionalKineticBlock;
import com.simibubi.create.foundation.block.IBE;
import com.simibubi.create.foundation.block.render.MultiPosDestructionHandler;
import dev.bluephs.vintage.VintageBlockEntity;
import dev.bluephs.vintage.VintageBlocks;
import dev.bluephs.vintage.content.kinetics.helve_hammer.HelveKineticBlockEntity;
import dev.bluephs.vintage.content.kinetics.helve_hammer.HelveStructuralBlock;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Consumer;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.ParticleEngine;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.extensions.common.IClientBlockExtensions;
import org.jetbrains.annotations.Nullable;

public class HelveKineticBlock
extends DirectionalKineticBlock
implements IWrenchable,
IProxyHoveringInformation,
IBE<HelveKineticBlockEntity> {
    public HelveKineticBlock(BlockBehaviour.Properties p_52591_) {
        super(p_52591_);
    }

    public Direction.Axis getRotationAxis(BlockState state) {
        return ((Direction)state.m_61143_((Property)FACING)).m_122427_().m_122434_();
    }

    public boolean hasShaftTowards(LevelReader world, BlockPos pos, BlockState state, Direction face) {
        return face.m_122434_() == ((Direction)state.m_61143_((Property)FACING)).m_122427_().m_122434_();
    }

    public Class<HelveKineticBlockEntity> getBlockEntityClass() {
        return HelveKineticBlockEntity.class;
    }

    public BlockEntityType<? extends HelveKineticBlockEntity> getBlockEntityType() {
        return (BlockEntityType)VintageBlockEntity.HELVE_KINETIC.get();
    }

    public PushReaction getPistonPushReaction(BlockState pState) {
        return PushReaction.BLOCK;
    }

    public InteractionResult onWrenched(BlockState state, UseOnContext context) {
        return InteractionResult.PASS;
    }

    public ItemStack m_7397_(BlockGetter pLevel, BlockPos pPos, BlockState pState) {
        return VintageBlocks.HELVE.asStack();
    }

    public InteractionResult onSneakWrenched(BlockState state, UseOnContext context) {
        BlockPos clickedPos = context.m_8083_();
        Level level = context.m_43725_();
        if (this.stillValid((BlockGetter)level, clickedPos, state, false)) {
            BlockPos masterPos = HelveKineticBlock.getMaster((BlockGetter)level, clickedPos, state);
            context = new UseOnContext(level, context.m_43723_(), context.m_43724_(), context.m_43722_(), new BlockHitResult(context.m_43720_(), context.m_43719_(), masterPos, context.m_43721_()));
            state = level.m_8055_(masterPos);
        }
        return super.onSneakWrenched(state, context);
    }

    public void m_6810_(BlockState pState, Level pLevel, BlockPos pPos, BlockState pNewState, boolean pIsMoving) {
        pLevel.m_46747_(pPos);
        if (this.stillValid((BlockGetter)pLevel, pPos, pState, false)) {
            pLevel.m_46961_(HelveKineticBlock.getMaster((BlockGetter)pLevel, pPos, pState), true);
        }
    }

    public void m_5707_(Level pLevel, BlockPos pPos, BlockState pState, Player pPlayer) {
        if (this.stillValid((BlockGetter)pLevel, pPos, pState, false)) {
            BlockPos masterPos = HelveKineticBlock.getMaster((BlockGetter)pLevel, pPos, pState);
            pLevel.m_6801_(masterPos.hashCode(), masterPos, -1);
            if (!pLevel.m_5776_() && pPlayer.m_7500_()) {
                pLevel.m_46961_(masterPos, false);
            }
        }
        super.m_5707_(pLevel, pPos, pState, pPlayer);
    }

    public BlockState m_7417_(BlockState pState, Direction pFacing, BlockState pFacingState, LevelAccessor pLevel, BlockPos pCurrentPos, BlockPos pFacingPos) {
        Level level;
        if (this.stillValid((BlockGetter)pLevel, pCurrentPos, pState, false)) {
            BlockPos masterPos = HelveKineticBlock.getMaster((BlockGetter)pLevel, pCurrentPos, pState);
            if (!pLevel.m_183326_().m_183582_(masterPos, (Object)((Block)VintageBlocks.HELVE.get()))) {
                pLevel.m_186460_(masterPos, (Block)VintageBlocks.HELVE.get(), 1);
            }
            return pState;
        }
        if (!(pLevel instanceof Level) || (level = (Level)pLevel).m_5776_()) {
            return pState;
        }
        if (!level.m_183326_().m_183582_(pCurrentPos, (Object)this)) {
            level.m_186460_(pCurrentPos, (Block)this, 1);
        }
        return pState;
    }

    public static BlockPos getMaster(BlockGetter level, BlockPos pos, BlockState state) {
        Direction direction = (Direction)state.m_61143_((Property)FACING);
        BlockPos targetedPos = pos.m_5484_(direction, 2);
        BlockState targetedState = level.m_8055_(targetedPos);
        if (targetedState.m_60713_((Block)VintageBlocks.HELVE_STRUCTURAL.get()) || targetedState.m_60713_((Block)VintageBlocks.HELVE_KINETIC.get())) {
            return HelveKineticBlock.getMaster(level, targetedPos, targetedState);
        }
        return targetedPos;
    }

    public boolean stillValid(BlockGetter level, BlockPos pos, BlockState state, boolean directlyAdjacent) {
        if (!state.m_60713_((Block)this)) {
            return false;
        }
        Direction direction = (Direction)state.m_61143_((Property)FACING);
        BlockPos targetedPos = pos.m_121945_(direction);
        BlockState targetedState = level.m_8055_(targetedPos);
        if (!directlyAdjacent && this.stillValid(level, targetedPos, targetedState, true)) {
            return true;
        }
        return targetedState.m_60734_() instanceof HelveStructuralBlock;
    }

    public void m_213897_(BlockState pState, ServerLevel pLevel, BlockPos pPos, RandomSource pRandom) {
        if (!this.stillValid((BlockGetter)pLevel, pPos, pState, false)) {
            pLevel.m_46597_(pPos, Blocks.f_50016_.m_49966_());
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void initializeClient(Consumer<IClientBlockExtensions> consumer) {
        consumer.accept(new RenderProperties());
    }

    public boolean addLandingEffects(BlockState state1, ServerLevel level, BlockPos pos, BlockState state2, LivingEntity entity, int numberOfParticles) {
        return true;
    }

    public BlockPos getInformationSource(Level level, BlockPos pos, BlockState state) {
        return this.stillValid((BlockGetter)level, pos, state, false) ? HelveKineticBlock.getMaster((BlockGetter)level, pos, state) : pos;
    }

    public static class RenderProperties
    implements IClientBlockExtensions,
    MultiPosDestructionHandler {
        public boolean addDestroyEffects(BlockState state, Level Level2, BlockPos pos, ParticleEngine manager) {
            return true;
        }

        public boolean addHitEffects(BlockState state, Level level, HitResult target, ParticleEngine manager) {
            if (target instanceof BlockHitResult) {
                BlockHitResult bhr = (BlockHitResult)target;
                BlockPos targetPos = bhr.m_82425_();
                HelveKineticBlock centrifugeStructuralBlock = (HelveKineticBlock)((Object)VintageBlocks.HELVE_KINETIC.get());
                if (centrifugeStructuralBlock.stillValid((BlockGetter)level, targetPos, state, false)) {
                    manager.m_107367_(HelveKineticBlock.getMaster((BlockGetter)level, targetPos, state), bhr.m_82434_());
                }
                return true;
            }
            return super.addHitEffects(state, level, target, manager);
        }

        @Nullable
        public Set<BlockPos> getExtraPositions(ClientLevel level, BlockPos pos, BlockState blockState, int progress) {
            HelveKineticBlock centrifugeStructuralBlock = (HelveKineticBlock)((Object)VintageBlocks.HELVE_KINETIC.get());
            if (!centrifugeStructuralBlock.stillValid((BlockGetter)level, pos, blockState, false)) {
                return null;
            }
            HashSet<BlockPos> set = new HashSet<BlockPos>();
            set.add(HelveKineticBlock.getMaster((BlockGetter)level, pos, blockState));
            return set;
        }
    }
}

