/*
 * Decompiled with CFR 0.152.
 */
package dev.bluephs.vintage.content.kinetics.helve_hammer;

import com.google.gson.JsonObject;
import com.simibubi.create.compat.jei.category.sequencedAssembly.SequencedAssemblySubCategory;
import com.simibubi.create.content.processing.recipe.ProcessingRecipe;
import com.simibubi.create.content.processing.recipe.ProcessingRecipeBuilder;
import com.simibubi.create.content.processing.sequenced.IAssemblyRecipe;
import com.simibubi.create.foundation.item.SmartInventory;
import com.simibubi.create.foundation.recipe.IRecipeTypeInfo;
import dev.bluephs.vintage.VintageBlocks;
import dev.bluephs.vintage.VintageLang;
import dev.bluephs.vintage.VintageRecipes;
import dev.bluephs.vintage.compat.jei.category.assemblies.AssemblyHammering;
import dev.bluephs.vintage.content.kinetics.helve_hammer.HelveBlockEntity;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.createmod.catnip.data.Iterate;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.registries.ForgeRegistries;

public class HammeringRecipe
extends ProcessingRecipe<SmartInventory>
implements IAssemblyRecipe {
    int hammerBlows = 1;
    Item anvilBlock = Blocks.f_50016_.m_5456_();

    public HammeringRecipe(ProcessingRecipeBuilder.ProcessingRecipeParams params) {
        super((IRecipeTypeInfo)VintageRecipes.HAMMERING, params);
    }

    public Item getAnvilBlock() {
        return this.anvilBlock;
    }

    public static boolean match(HelveBlockEntity centrifuge, Recipe<?> recipe) {
        return HammeringRecipe.apply(centrifuge, recipe, true);
    }

    public static boolean apply(HelveBlockEntity centrifuge, Recipe<?> recipe) {
        return HammeringRecipe.apply(centrifuge, recipe, false);
    }

    private static boolean apply(HelveBlockEntity centrifuge, Recipe<?> recipe, boolean test) {
        IItemHandlerModifiable availableItems = (IItemHandlerModifiable)centrifuge.getCapability(ForgeCapabilities.ITEM_HANDLER).orElse(null);
        if (availableItems == null) {
            return false;
        }
        if (recipe instanceof HammeringRecipe) {
            HammeringRecipe hammeringRecipe = (HammeringRecipe)recipe;
            if (!centrifuge.anvilBlock.m_5456_().m_7968_().m_150930_(hammeringRecipe.anvilBlock)) {
                return false;
            }
        }
        ArrayList<ItemStack> recipeOutputItems = new ArrayList<ItemStack>();
        LinkedList ingredients = new LinkedList(recipe.m_7527_());
        for (boolean simulate : Iterate.trueAndFalse) {
            if (!simulate && test) {
                return true;
            }
            int[] extractedItemsFromSlot = new int[availableItems.getSlots()];
            for (int i = 0; i < ingredients.size(); ++i) {
                int slot;
                block9: {
                    Ingredient ingredient = (Ingredient)ingredients.get(i);
                    for (slot = 0; slot < availableItems.getSlots(); ++slot) {
                        ItemStack extracted;
                        if (simulate && availableItems.getStackInSlot(slot).m_41613_() <= extractedItemsFromSlot[slot] || !ingredient.test(extracted = availableItems.getStackInSlot(slot))) continue;
                        if (!simulate) {
                            extracted.m_41774_(1);
                        }
                        break block9;
                    }
                    return false;
                }
                int n = slot;
                extractedItemsFromSlot[n] = extractedItemsFromSlot[n] + 1;
            }
            if (simulate && recipe instanceof HammeringRecipe) {
                HammeringRecipe centrifugeRecipe = (HammeringRecipe)recipe;
                recipeOutputItems.addAll(centrifugeRecipe.rollResults());
                recipeOutputItems.addAll((Collection<ItemStack>)centrifugeRecipe.m_7457_((Container)centrifuge.getInputInventory()));
            }
            if (centrifuge.acceptOutputs(recipeOutputItems, simulate)) continue;
            return false;
        }
        return true;
    }

    protected int getMaxInputCount() {
        return 3;
    }

    protected int getMaxOutputCount() {
        return 3;
    }

    public boolean matches(SmartInventory inv, @Nonnull Level worldIn) {
        if (inv.m_7983_()) {
            return false;
        }
        if (this.ingredients.isEmpty()) {
            return !this.fluidIngredients.isEmpty();
        }
        for (Ingredient ingredient : this.ingredients) {
            if (inv.m_18947_(ingredient.m_43908_()[0].m_41720_()) >= ingredient.m_43908_().length) continue;
            return false;
        }
        return true;
    }

    public void addAssemblyIngredients(List<Ingredient> list) {
    }

    @OnlyIn(value=Dist.CLIENT)
    public Component getDescriptionForAssembly() {
        MutableComponent result = VintageLang.translateDirect("recipe.assembly.hammering", new Object[0]);
        if (this.ingredients.size() > 1) {
            if (((Ingredient)this.ingredients.get(1)).m_43908_().length > 0) {
                result.m_130946_(" ").m_7220_((Component)VintageLang.translateDirect("recipe.assembly.with", new Object[0])).m_130946_(" ").m_7220_(((Ingredient)this.ingredients.get(1)).m_43908_()[0].m_41720_().m_41466_());
            }
            if (this.ingredients.size() > 2) {
                for (int i = 2; i < this.ingredients.size() - 1; ++i) {
                    if (((Ingredient)this.ingredients.get(i)).m_43908_().length <= 0) continue;
                    result.m_130946_(", ").m_7220_(((Ingredient)this.ingredients.get(i)).m_43908_()[0].m_41720_().m_41466_());
                }
                if (((Ingredient)this.ingredients.get(this.ingredients.size() - 1)).m_43908_().length > 0) {
                    result.m_130946_(" ").m_7220_((Component)VintageLang.translateDirect("recipe.assembly.and", new Object[0]).m_130946_(" ").m_7220_(((Ingredient)this.ingredients.get(this.ingredients.size() - 1)).m_43908_()[0].m_41720_().m_41466_()));
                }
            }
        }
        if (this.anvilBlock != Blocks.f_50016_.m_5456_()) {
            result.m_130946_(" ").m_7220_((Component)VintageLang.translateDirect("recipe.assembly.on", new Object[0])).m_130946_(" ").m_7220_((Component)Component.m_237115_((String)this.anvilBlock.m_5524_()));
        }
        return result;
    }

    public void addRequiredMachines(Set<ItemLike> list) {
        list.add((ItemLike)VintageBlocks.HELVE.get());
    }

    public Supplier<Supplier<SequencedAssemblySubCategory>> getJEISubCategory() {
        return () -> AssemblyHammering::new;
    }

    public void readAdditional(JsonObject json) {
        this.hammerBlows = json.has("hammerBlows") ? json.get("hammerBlows").getAsInt() : 1;
        this.anvilBlock = json.has("anvilBlock") ? ((Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(json.get("anvilBlock").getAsString()))).m_5456_() : Items.f_41852_;
    }

    public void readAdditional(FriendlyByteBuf buffer) {
        this.hammerBlows = buffer.readInt();
        this.anvilBlock = buffer.m_130267_().m_41720_();
    }

    public void writeAdditional(JsonObject json) {
        json.addProperty("hammerBlows", (Number)this.hammerBlows);
        if (!this.anvilBlock.equals(Blocks.f_50016_)) {
            json.addProperty("anvilBlock", this.anvilBlock.toString());
        }
    }

    public void writeAdditional(FriendlyByteBuf buffer) {
        buffer.writeInt(this.hammerBlows);
        buffer.m_130055_(new ItemStack((ItemLike)this.anvilBlock));
    }

    public int getHammerBlows() {
        return this.hammerBlows;
    }
}

