/*
 * Decompiled with CFR 0.152.
 */
package dev.bluephs.vintage.content.kinetics.curving_press;

import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.belt.transport.TransportedItemStack;
import com.simibubi.create.content.processing.sequenced.SequencedAssemblyRecipe;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.SyncedBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.item.ItemHelper;
import com.simibubi.create.foundation.item.SmartInventory;
import com.simibubi.create.foundation.recipe.RecipeApplier;
import com.simibubi.create.foundation.recipe.RecipeConditions;
import com.simibubi.create.foundation.recipe.RecipeFinder;
import dev.bluephs.vintage.VintageItems;
import dev.bluephs.vintage.VintageLang;
import dev.bluephs.vintage.VintageRecipes;
import dev.bluephs.vintage.VintageRecipesList;
import dev.bluephs.vintage.content.equipment.CurvingHeadItem;
import dev.bluephs.vintage.content.kinetics.curving_press.CurvingBehaviour;
import dev.bluephs.vintage.content.kinetics.curving_press.CurvingRecipe;
import dev.bluephs.vintage.foundation.advancement.VintageAdvancementBehaviour;
import dev.bluephs.vintage.foundation.advancement.VintageAdvancements;
import dev.bluephs.vintage.infrastructure.config.VintageConfig;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.createmod.catnip.math.VecHelper;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapelessRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.RecipeWrapper;

public class CurvingPressBlockEntity
extends KineticBlockEntity
implements CurvingBehaviour.CurvingBehaviourSpecifics {
    private static final Object curvingRecipesKey = new Object();
    public int mode = 0;
    public SmartInventory itemAsHead = new SmartInventory(1, (SyncedBlockEntity)this);
    public int durability = 0;
    boolean redstoneModule = false;
    public CurvingBehaviour pressingBehaviour;
    VintageAdvancementBehaviour advancementBehaviour;
    private static final RecipeWrapper pressingInv = new RecipeWrapper((IItemHandlerModifiable)new ItemStackHandler(1));

    public CurvingPressBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    protected AABB createRenderBoundingBox() {
        return new AABB(this.f_58858_).m_82363_(0.0, -1.5, 0.0).m_82363_(0.0, 1.0, 0.0);
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        super.addBehaviours(behaviours);
        this.pressingBehaviour = new CurvingBehaviour(this);
        behaviours.add((BlockEntityBehaviour)this.pressingBehaviour);
        this.advancementBehaviour = new VintageAdvancementBehaviour((SmartBlockEntity)this);
        behaviours.add(this.advancementBehaviour);
    }

    public boolean addRedstoneApp(ItemStack items) {
        if (this.redstoneModule) {
            return false;
        }
        if (items.m_41720_() != VintageItems.REDSTONE_MODULE.get()) {
            return false;
        }
        this.redstoneModule = true;
        return true;
    }

    public void onItemPressed(ItemStack result, int damage) {
        if (damage < 0) {
            damage = (Integer)VintageConfig.server().recipes.damageHeadAfterAutoCurvingRecipe.get();
        }
        if (damage < 0) {
            damage = 0;
        }
        if (damage > 0) {
            if (this.mode < 5 && this.mode > 0) {
                this.durability -= damage;
                if (this.durability <= 0) {
                    this.mode = 0;
                }
            }
            if (this.mode == 5 && this.itemAsHead.m_8020_(0).m_41763_()) {
                this.itemAsHead.m_8020_(0).m_220157_(damage, this.f_58857_.f_46441_.m_213769_(), null);
                if (this.itemAsHead.m_8020_(0).m_41773_() >= this.itemAsHead.m_8020_(0).m_41776_()) {
                    this.itemAsHead.m_8020_(0).m_41774_(1);
                    this.mode = 0;
                } else {
                    this.durability = this.itemAsHead.m_8020_(0).m_41773_();
                }
            }
        }
        this.advancementBehaviour.awardVintageAdvancement(VintageAdvancements.USE_CURVING_PRESS);
        this.m_6596_();
        this.sendData();
    }

    public void destroy() {
        SmartInventory headInv;
        super.destroy();
        if (this.mode > 0) {
            headInv = new SmartInventory(1, (SyncedBlockEntity)this);
            if (this.mode < 5) {
                ItemStack stack = switch (this.mode) {
                    case 2 -> new ItemStack((ItemLike)VintageItems.CONCAVE_CURVING_HEAD.get());
                    case 3 -> new ItemStack((ItemLike)VintageItems.W_SHAPED_CURVING_HEAD.get());
                    case 4 -> new ItemStack((ItemLike)VintageItems.V_SHAPED_CURVING_HEAD.get());
                    default -> new ItemStack((ItemLike)VintageItems.CONVEX_CURVING_HEAD.get());
                };
                stack.m_41721_(1000 - this.durability);
                ItemHandlerHelper.insertItemStacked((IItemHandler)headInv, (ItemStack)stack, (boolean)false);
            } else if (!this.itemAsHead.m_7983_()) {
                ItemHandlerHelper.insertItemStacked((IItemHandler)headInv, (ItemStack)this.itemAsHead.m_8020_(0), (boolean)false);
            } else {
                ItemHandlerHelper.insertItemStacked((IItemHandler)headInv, (ItemStack)ItemStack.f_41583_, (boolean)false);
            }
            ItemHelper.dropContents((Level)this.f_58857_, (BlockPos)this.f_58858_, (IItemHandler)headInv);
        }
        if (this.redstoneModule) {
            headInv = new SmartInventory(1, (SyncedBlockEntity)this);
            ItemHandlerHelper.insertItemStacked((IItemHandler)headInv, (ItemStack)VintageItems.REDSTONE_MODULE.asStack(), (boolean)false);
            ItemHelper.dropContents((Level)this.f_58857_, (BlockPos)this.f_58858_, (IItemHandler)headInv);
        }
    }

    public CurvingBehaviour getPressingBehaviour() {
        return this.pressingBehaviour;
    }

    protected void write(CompoundTag compound, boolean clientPacket) {
        compound.m_128405_("HeadMode", this.mode);
        compound.m_128405_("Durability", this.durability);
        if (!this.itemAsHead.m_7983_()) {
            compound.m_128365_("ItemAsHead", (Tag)this.itemAsHead.serializeNBT());
        }
        compound.m_128379_("Redstone", this.redstoneModule);
        super.write(compound, clientPacket);
    }

    protected void read(CompoundTag compound, boolean clientPacket) {
        this.mode = compound.m_128451_("HeadMode");
        this.durability = compound.m_128451_("Durability");
        if (compound.m_128441_("ItemAsHead")) {
            this.itemAsHead.deserializeNBT(compound.m_128469_("ItemAsHead"));
            if (this.itemAsHead.m_8020_(0).m_41763_()) {
                this.itemAsHead.m_8020_(0).m_41721_(this.durability);
            }
        } else {
            this.itemAsHead.m_6211_();
        }
        this.redstoneModule = compound.m_128471_("Redstone");
        super.read(compound, clientPacket);
    }

    public static boolean canCurve(Recipe recipe) {
        return CurvingPressBlockEntity.canCurve(recipe, 1);
    }

    public static boolean canCurve(Recipe recipe, int mode) {
        if (!(recipe instanceof CraftingRecipe)) {
            return false;
        }
        if (mode == 1 || mode == 2) {
            ItemStack item = null;
            NonNullList in = recipe.m_7527_();
            if (((Ingredient)in.get(mode - 1)).m_43947_()) {
                return false;
            }
            int matches = 0;
            boolean it = mode == 2;
            for (Ingredient i : in) {
                boolean bl = it = !it;
                if (it) {
                    if (!i.m_43947_()) {
                        if (item == null) {
                            item = i.m_43908_()[0];
                        }
                    } else {
                        return false;
                    }
                    if (i.test(item)) {
                        ++matches;
                        continue;
                    }
                }
                if (i.m_43947_()) continue;
                return false;
            }
            return matches == 3;
        }
        if (mode == 3 || mode == 4) {
            ItemStack item = null;
            NonNullList in = recipe.m_7527_();
            if (mode == 4) {
                if (((Ingredient)in.get(2)).m_43947_() || ((Ingredient)in.get(3)).m_43947_()) {
                    return false;
                }
                int matches = 0;
                int empty = 0;
                for (Ingredient i : in) {
                    if (!i.m_43947_()) {
                        if (item == null) {
                            if (i.m_43908_().length <= 0) {
                                return false;
                            }
                            item = i.m_43908_()[0];
                        }
                        if (i.test(item)) {
                            ++matches;
                            continue;
                        }
                        return false;
                    }
                    if (++empty <= 1) continue;
                    return false;
                }
                return matches == 3 && empty == 1;
            }
            if (!((Ingredient)in.get(2)).m_43947_() && !((Ingredient)in.get(3)).m_43947_()) {
                return false;
            }
            int matches = 0;
            int empty = 0;
            for (Ingredient i : in) {
                if (!i.m_43947_()) {
                    if (item == null) {
                        if (i.m_43908_().length <= 0) {
                            return false;
                        }
                        item = i.m_43908_()[0];
                    }
                    if (i.test(item)) {
                        ++matches;
                        continue;
                    }
                    return false;
                }
                if (++empty <= 1) continue;
                return false;
            }
            return matches == 3 && empty == 1;
        }
        return false;
    }

    private boolean tryToCurve(ItemEntity itemEntity, boolean simulate) {
        if (!((Boolean)VintageConfig.server().recipes.allowAutoCurvingRecipes.get()).booleanValue()) {
            return false;
        }
        if (this.mode <= 0 || this.mode > 4) {
            return false;
        }
        List<CraftingRecipe> recipes = VintageRecipesList.getCurving(this.mode);
        block0: for (CraftingRecipe recipe : recipes) {
            if (recipe instanceof ShapelessRecipe || !recipe.m_8004_(this.mode < 3 ? 3 : 2, 2) || recipe.m_7527_().size() != 6 && this.mode < 3 || recipe.m_7527_().size() != 4 && this.mode >= 3) continue;
            ItemStack item = itemEntity.m_32055_();
            NonNullList in = recipe.m_7527_();
            int matches = 0;
            for (Ingredient i : in) {
                if (i.test(item)) {
                    ++matches;
                    continue;
                }
                if (i.m_43947_()) continue;
                continue block0;
            }
            if (matches != 3) continue;
            if (recipe.m_8043_((RegistryAccess)RegistryAccess.f_243945_).m_41613_() < 3 && itemEntity.m_32055_().m_41613_() < 3) {
                return false;
            }
            if (simulate) {
                return true;
            }
            if (recipe.m_8043_((RegistryAccess)RegistryAccess.f_243945_).m_41613_() >= 3) {
                itemCreated = ItemStack.f_41583_;
                this.pressingBehaviour.particleItems.add(item);
                if (item.m_41613_() == 1) {
                    itemEntity.m_32045_(new ItemStack((ItemLike)recipe.m_8043_((RegistryAccess)RegistryAccess.f_243945_).m_41777_().m_41720_()));
                    this.onItemPressed(itemEntity.m_32055_(), (Integer)VintageConfig.server().recipes.damageHeadAfterAutoCurvingRecipe.get());
                } else {
                    if (itemCreated.m_41619_()) {
                        itemCreated = recipe.m_8043_((RegistryAccess)RegistryAccess.f_243945_).m_41777_();
                    }
                    created = new ItemEntity(this.f_58857_, itemEntity.m_20185_(), itemEntity.m_20186_(), itemEntity.m_20189_(), new ItemStack((ItemLike)recipe.m_8043_((RegistryAccess)RegistryAccess.f_243945_).m_41777_().m_41720_()));
                    created.m_32060_();
                    created.m_20256_(VecHelper.offsetRandomly((Vec3)Vec3.f_82478_, (RandomSource)this.f_58857_.f_46441_, (float)0.05f));
                    this.f_58857_.m_7967_((Entity)created);
                    item.m_41774_(1);
                }
                if (!itemCreated.m_41619_()) {
                    this.onItemPressed(itemCreated, (Integer)VintageConfig.server().recipes.damageHeadAfterAutoCurvingRecipe.get());
                }
            } else {
                itemCreated = ItemStack.f_41583_;
                this.pressingBehaviour.particleItems.add(item);
                if (item.m_41613_() == 3) {
                    itemEntity.m_32045_(new ItemStack((ItemLike)recipe.m_8043_((RegistryAccess)RegistryAccess.f_243945_).m_41777_().m_41720_()));
                    this.onItemPressed(itemEntity.m_32055_(), (Integer)VintageConfig.server().recipes.damageHeadAfterAutoCurvingRecipe.get());
                } else {
                    if (itemCreated.m_41619_()) {
                        itemCreated = recipe.m_8043_((RegistryAccess)RegistryAccess.f_243945_).m_41777_();
                    }
                    created = new ItemEntity(this.f_58857_, itemEntity.m_20185_(), itemEntity.m_20186_(), itemEntity.m_20189_(), recipe.m_8043_((RegistryAccess)RegistryAccess.f_243945_).m_41777_());
                    created.m_32060_();
                    created.m_20256_(VecHelper.offsetRandomly((Vec3)Vec3.f_82478_, (RandomSource)this.f_58857_.f_46441_, (float)0.05f));
                    this.f_58857_.m_7967_((Entity)created);
                    item.m_41774_(3);
                }
                if (!itemCreated.m_41619_()) {
                    this.onItemPressed(itemCreated, (Integer)VintageConfig.server().recipes.damageHeadAfterAutoCurvingRecipe.get());
                }
            }
            return true;
        }
        return false;
    }

    private boolean tryToCurve(List<ItemStack> outputList, ItemStack item, boolean simulate) {
        if (!((Boolean)VintageConfig.server().recipes.allowAutoCurvingRecipes.get()).booleanValue()) {
            return false;
        }
        if (this.mode <= 0 || this.mode >= 4) {
            return false;
        }
        List<CraftingRecipe> recipes = VintageRecipesList.getCurving(this.mode);
        block0: for (CraftingRecipe recipe : recipes) {
            if (recipe instanceof ShapelessRecipe || !recipe.m_8004_(this.mode < 3 ? 3 : 2, 2) || recipe.m_7527_().size() != 6 && this.mode < 3 || recipe.m_7527_().size() != 4 && this.mode >= 3) continue;
            NonNullList in = recipe.m_7527_();
            int matches = 0;
            for (Ingredient i : in) {
                if (i.test(item)) {
                    ++matches;
                    continue;
                }
                if (i.m_43947_()) continue;
                continue block0;
            }
            if (matches != 3) continue;
            if (simulate) {
                return true;
            }
            outputList.add(new ItemStack((ItemLike)recipe.m_8043_((RegistryAccess)RegistryAccess.f_243945_).m_41777_().m_41720_()));
            this.pressingBehaviour.particleItems.add(item);
            for (ItemStack created : outputList) {
                if (created.m_41619_()) continue;
                this.onItemPressed(created, (Integer)VintageConfig.server().recipes.damageHeadAfterAutoCurvingRecipe.get());
                break;
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean tryProcessInWorld(ItemEntity itemEntity, boolean simulate) {
        ItemStack item = itemEntity.m_32055_();
        Optional<CurvingRecipe> recipe = this.getRecipe(item);
        if (!recipe.isPresent()) {
            return this.tryToCurve(itemEntity, simulate);
        }
        if (recipe.get().getMode() != this.mode) {
            return false;
        }
        if (this.mode == 5) {
            if (this.itemAsHead.m_7983_()) {
                return false;
            }
            if (!this.itemAsHead.m_8020_(0).m_150930_(recipe.get().itemAsHead)) {
                return false;
            }
        }
        if (itemEntity.m_32055_().m_41613_() < recipe.get().m_7527_().size()) {
            return false;
        }
        if (simulate) {
            return true;
        }
        ItemStack itemCreated = ItemStack.f_41583_;
        this.pressingBehaviour.particleItems.add(item.m_41777_());
        for (ItemStack result : RecipeApplier.applyRecipeOn((Level)this.f_58857_, (ItemStack)ItemHandlerHelper.copyStackWithSize((ItemStack)item, (int)1), (Recipe)((Recipe)recipe.get()), (boolean)true)) {
            if (itemCreated.m_41619_()) {
                itemCreated = result.m_41777_();
            }
            ItemEntity created = new ItemEntity(this.f_58857_, itemEntity.m_20185_(), itemEntity.m_20186_(), itemEntity.m_20189_(), result);
            created.m_32060_();
            created.m_20256_(VecHelper.offsetRandomly((Vec3)Vec3.f_82478_, (RandomSource)this.f_58857_.f_46441_, (float)0.05f));
            this.f_58857_.m_7967_((Entity)created);
        }
        item.m_41774_(recipe.get().m_7527_().size());
        if (!itemCreated.m_41619_()) {
            this.onItemPressed(itemCreated, recipe.get().headDamage);
        }
        return true;
    }

    @Override
    public boolean tryProcessOnBelt(TransportedItemStack input, List<ItemStack> outputList, boolean simulate) {
        Optional<CurvingRecipe> recipe = this.getRecipe(input.stack);
        if (!recipe.isPresent()) {
            return this.tryToCurve(outputList, input.stack, simulate);
        }
        if (recipe.get().getMode() != this.mode) {
            return false;
        }
        if (this.mode == 5) {
            if (this.itemAsHead.m_7983_()) {
                return false;
            }
            if (!this.itemAsHead.m_8020_(0).m_150930_(recipe.get().itemAsHead)) {
                return false;
            }
        }
        if (input.stack.m_41613_() < recipe.get().m_7527_().size()) {
            return false;
        }
        if (simulate) {
            return true;
        }
        this.pressingBehaviour.particleItems.add(input.stack);
        List outputs = RecipeApplier.applyRecipeOn((Level)this.f_58857_, (ItemStack)ItemHandlerHelper.copyStackWithSize((ItemStack)input.stack, (int)1), (Recipe)((Recipe)recipe.get()), (boolean)true);
        input.stack.m_41774_(recipe.get().m_7527_().size() - 1);
        for (ItemStack created : outputs) {
            if (created.m_41619_()) continue;
            this.onItemPressed(created, recipe.get().headDamage);
            break;
        }
        outputList.addAll(outputs);
        return true;
    }

    public Optional<CurvingRecipe> getRecipe(ItemStack item) {
        Optional<CurvingRecipe> assemblyRecipe = SequencedAssemblyRecipe.getRecipe((Level)this.f_58857_, (ItemStack)item, VintageRecipes.CURVING.getType(), CurvingRecipe.class);
        if (assemblyRecipe.isPresent() && this.mode == ((CurvingRecipe)((Object)assemblyRecipe.get())).getMode()) {
            if (this.mode == 5) {
                if (this.itemAsHead.m_8020_(0).m_150930_(assemblyRecipe.get().getItemAsHead())) {
                    return assemblyRecipe;
                }
            } else {
                return assemblyRecipe;
            }
        }
        pressingInv.m_6836_(0, item);
        assemblyRecipe = VintageRecipes.CURVING.find(pressingInv, this.f_58857_);
        if (assemblyRecipe.isPresent() && this.mode == assemblyRecipe.get().getMode()) {
            if (this.mode == 5) {
                if (this.itemAsHead.m_8020_(0).m_150930_(assemblyRecipe.get().getItemAsHead())) {
                    return assemblyRecipe;
                }
            } else {
                return assemblyRecipe;
            }
        }
        Predicate types = RecipeConditions.isOfType((RecipeType[])new RecipeType[]{VintageRecipes.CURVING.getType()});
        List startedSearch = RecipeFinder.get((Object)curvingRecipesKey, (Level)this.f_58857_, (Predicate)types);
        startedSearch = startedSearch.stream().filter(RecipeConditions.firstIngredientMatches((ItemStack)item)).filter(r -> !VintageRecipes.shouldIgnoreInAutomation(r)).filter(r -> {
            CurvingRecipe curvingRecipe;
            if (r instanceof CurvingRecipe && (curvingRecipe = (CurvingRecipe)((Object)r)).matches(pressingInv, this.f_58857_) && this.mode == curvingRecipe.mode) {
                if (this.mode == 5) {
                    return this.itemAsHead.m_8020_(0).m_150930_(curvingRecipe.getItemAsHead());
                }
                return true;
            }
            return false;
        }).collect(Collectors.toList());
        for (Recipe recipe : startedSearch) {
            if (!(recipe instanceof CurvingRecipe)) continue;
            CurvingRecipe curvingRecipe = (CurvingRecipe)recipe;
            return Optional.ofNullable(curvingRecipe);
        }
        return VintageRecipes.CURVING.find(pressingInv, this.f_58857_);
    }

    @Override
    public float getKineticSpeed() {
        return this.getSpeed();
    }

    @Override
    public boolean canProcessInBulk() {
        return false;
    }

    @Override
    public int getParticleAmount() {
        return 15;
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        super.addToGoggleTooltip(tooltip, isPlayerSneaking);
        if (this.mode <= 0 || this.mode > 5) {
            return true;
        }
        switch (this.mode) {
            case 2: {
                VintageLang.translate("gui.goggles.curving_head", new Object[0]).add(Component.m_237115_((String)((CurvingHeadItem)((Object)VintageItems.CONCAVE_CURVING_HEAD.get())).m_5524_()).m_130940_(ChatFormatting.GOLD)).forGoggles(tooltip);
                break;
            }
            case 3: {
                VintageLang.translate("gui.goggles.curving_head", new Object[0]).add(Component.m_237115_((String)((CurvingHeadItem)((Object)VintageItems.W_SHAPED_CURVING_HEAD.get())).m_5524_()).m_130940_(ChatFormatting.BLUE)).forGoggles(tooltip);
                break;
            }
            case 4: {
                VintageLang.translate("gui.goggles.curving_head", new Object[0]).add(Component.m_237115_((String)((CurvingHeadItem)((Object)VintageItems.V_SHAPED_CURVING_HEAD.get())).m_5524_()).m_130940_(ChatFormatting.YELLOW)).forGoggles(tooltip);
                break;
            }
            case 5: {
                if (this.itemAsHead.m_7983_()) break;
                VintageLang.translate("gui.goggles.curving_head", new Object[0]).add(Component.m_237115_((String)this.itemAsHead.m_8020_(0).m_41778_()).m_130940_(ChatFormatting.LIGHT_PURPLE)).forGoggles(tooltip);
                break;
            }
            default: {
                VintageLang.translate("gui.goggles.curving_head", new Object[0]).add(Component.m_237115_((String)((CurvingHeadItem)((Object)VintageItems.CONVEX_CURVING_HEAD.get())).m_5524_()).m_130940_(ChatFormatting.GREEN)).forGoggles(tooltip);
            }
        }
        if (this.mode == 5) {
            if (this.itemAsHead.m_8020_(0).m_41763_()) {
                VintageLang.translate("gui.goggles.durability", new Object[0]).add(Component.m_237113_((String)(": " + (this.itemAsHead.m_8020_(0).m_41776_() - this.durability)))).forGoggles(tooltip);
            }
        } else {
            VintageLang.translate("gui.goggles.durability", new Object[0]).add(Component.m_237113_((String)(": " + this.durability))).forGoggles(tooltip);
        }
        if (this.redstoneModule) {
            VintageLang.translate("gui.goggles.redstone_module", new Object[0]).style(ChatFormatting.DARK_PURPLE).forGoggles(tooltip);
        }
        return true;
    }

    public int getAnalogSignal() {
        if (!this.redstoneModule) {
            return 0;
        }
        return this.mode > 0 ? 15 : 0;
    }
}

