/*
 * Decompiled with CFR 0.152.
 */
package dev.bluephs.vintage.compat.jei.category;

import com.simibubi.create.compat.jei.category.CreateRecipeCategory;
import com.simibubi.create.content.processing.recipe.ProcessingOutput;
import com.simibubi.create.foundation.gui.AllGuiTextures;
import com.simibubi.create.foundation.item.ItemHelper;
import dev.bluephs.vintage.VintageItems;
import dev.bluephs.vintage.compat.jei.category.animations.AnimatedCurvingPress;
import dev.bluephs.vintage.content.kinetics.curving_press.CurvingRecipe;
import dev.bluephs.vintage.infrastructure.config.VintageConfig;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import net.createmod.catnip.data.Pair;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import org.apache.commons.lang3.mutable.MutableInt;

@ParametersAreNonnullByDefault
public class CurvingCategory
extends CreateRecipeCategory<CurvingRecipe> {
    private final AnimatedCurvingPress press = new AnimatedCurvingPress();

    public CurvingCategory(CreateRecipeCategory.Info<CurvingRecipe> info) {
        super(info);
    }

    public void setRecipe(IRecipeLayoutBuilder builder, CurvingRecipe recipe, IFocusGroup focuses) {
        builder.addSlot(RecipeIngredientRole.INPUT, 4, 28).setBackground(CurvingCategory.getRenderedSlot(), -1, -1).addItemStack(switch (recipe.getMode()) {
            case 2 -> new ItemStack((ItemLike)VintageItems.CONCAVE_CURVING_HEAD.get());
            case 3 -> new ItemStack((ItemLike)VintageItems.W_SHAPED_CURVING_HEAD.get());
            case 4 -> new ItemStack((ItemLike)VintageItems.V_SHAPED_CURVING_HEAD.get());
            case 5 -> new ItemStack((ItemLike)recipe.getItemAsHead());
            default -> new ItemStack((ItemLike)VintageItems.CONVEX_CURVING_HEAD.get());
        });
        List condensedIngredients = ItemHelper.condenseIngredients((NonNullList)recipe.m_7527_());
        Iterator iterator = condensedIngredients.iterator();
        if (iterator.hasNext()) {
            Pair pair = (Pair)iterator.next();
            ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
            for (ItemStack itemStack : ((Ingredient)pair.getFirst()).m_43908_()) {
                ItemStack copy = itemStack.m_41777_();
                copy.m_41764_(((MutableInt)pair.getSecond()).getValue().intValue());
                stacks.add(copy);
            }
            builder.addSlot(RecipeIngredientRole.INPUT, 27, 51).setBackground(CurvingCategory.getRenderedSlot(), -1, -1).addItemStacks(stacks);
        }
        List results = recipe.getRollableResults();
        int i = 0;
        for (ProcessingOutput output : results) {
            ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.OUTPUT, 131 + 19 * i, 50).setBackground(CurvingCategory.getRenderedSlot((ProcessingOutput)output), -1, -1).addItemStack(output.getStack())).addRichTooltipCallback(CurvingCategory.addStochasticTooltip((ProcessingOutput)output));
            ++i;
        }
    }

    public void draw(CurvingRecipe recipe, IRecipeSlotsView iRecipeSlotsView, GuiGraphics graphics, double mouseX, double mouseY) {
        AllGuiTextures.JEI_SHADOW.render(graphics, 61, 41);
        AllGuiTextures.JEI_LONG_ARROW.render(graphics, 52, 54);
        AllGuiTextures.JEI_DOWN_ARROW.render(graphics, 23, 32);
        this.press.draw(graphics, this.getBackground().getWidth() / 2 - 17, 22, recipe.getMode());
        if (recipe.getHeadDamage() != 0) {
            if (recipe.getMode() == 5 && !new ItemStack((ItemLike)recipe.getItemAsHead()).m_41763_()) {
                return;
            }
            if (recipe.getHeadDamage() < 0) {
                if ((Integer)VintageConfig.server().recipes.damageHeadAfterAutoCurvingRecipe.get() == 0) {
                    return;
                }
                graphics.m_280653_(Minecraft.m_91087_().f_91062_, (Component)Component.m_237115_((String)"vintage.jei.text.curving_head_damage").m_130946_(": " + String.valueOf(VintageConfig.server().recipes.damageHeadAfterAutoCurvingRecipe.get())), 88, 75, 0xFFFFFF);
            } else {
                graphics.m_280653_(Minecraft.m_91087_().f_91062_, (Component)Component.m_237115_((String)"vintage.jei.text.curving_head_damage").m_130946_(": " + recipe.getHeadDamage()), 88, 75, 0xFFFFFF);
            }
        }
    }
}

