/*
 * Decompiled with CFR 0.152.
 */
package dev.bluephs.vintage;

import com.mojang.logging.LogUtils;
import com.simibubi.create.AllItems;
import com.simibubi.create.foundation.data.CreateRegistrate;
import com.simibubi.create.foundation.item.ItemDescription;
import com.simibubi.create.foundation.item.KineticStats;
import com.simibubi.create.foundation.item.TagDependentIngredientItem;
import com.simibubi.create.foundation.item.TooltipModifier;
import dev.bluephs.vintage.VintageBlockEntity;
import dev.bluephs.vintage.VintageBlocks;
import dev.bluephs.vintage.VintageFluids;
import dev.bluephs.vintage.VintageItems;
import dev.bluephs.vintage.VintageMenuTypes;
import dev.bluephs.vintage.VintagePartialModels;
import dev.bluephs.vintage.VintageRecipes;
import dev.bluephs.vintage.VintageRecipesList;
import dev.bluephs.vintage.content.equipment.TagDependentSpringItem;
import dev.bluephs.vintage.content.kinetics.grinder.GrinderBlock;
import dev.bluephs.vintage.foundation.advancement.VintageAdvancements;
import dev.bluephs.vintage.infrastructure.config.VintageConfig;
import dev.bluephs.vintage.infrastructure.ponder.VintagePonderPlugin;
import net.createmod.catnip.lang.FontHelper;
import net.createmod.ponder.api.registration.PonderPlugin;
import net.createmod.ponder.foundation.PonderIndex;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import org.slf4j.Logger;

@Mod(value="vintage")
public class Vintage {
    public static final String MOD_ID = "vintage";
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final CreateRegistrate MY_REGISTRATE = CreateRegistrate.create((String)"vintage");
    public static final DeferredRegister<Block> BLOCKS;
    public static final DeferredRegister<Item> ITEMS;
    public static final DeferredRegister<CreativeModeTab> CREATIVE_MODE_TABS;
    public static final RegistryObject<Item> CALORITE_ROD;
    public static final RegistryObject<Item> OSTRUM_ROD;
    public static final RegistryObject<Item> DESH_ROD;
    public static final RegistryObject<Item> NETHERITE_ROD;
    public static final RegistryObject<Item> NETHERSTEEL_ROD;
    public static final RegistryObject<Item> IRONWOOD_ROD;
    public static final RegistryObject<Item> KNIGHTMETAL_ROD;
    public static final RegistryObject<Item> QUEENS_SLIME_ROD;
    public static final RegistryObject<Item> SLIMESTEEL_ROD;
    public static final RegistryObject<Item> VANADIUM_ROD;
    public static final RegistryObject<Item> ANDESITE_ROD;
    public static final RegistryObject<Item> ZINC_ROD;
    public static final RegistryObject<Item> SHADOW_STEEL_ROD;
    public static final RegistryObject<Item> CALORITE_WIRE;
    public static final RegistryObject<Item> OSTRUM_WIRE;
    public static final RegistryObject<Item> DESH_WIRE;
    public static final RegistryObject<Item> BRASS_WIRE;
    public static final RegistryObject<Item> IRONWOOD_WIRE;
    public static final RegistryObject<Item> KNIGHTMETAL_WIRE;
    public static final RegistryObject<Item> QUEENS_SLIME_WIRE;
    public static final RegistryObject<Item> SLIMESTEEL_WIRE;
    public static final RegistryObject<Item> VANADIUM_WIRE;
    public static final RegistryObject<Item> FIERY_WIRE;
    public static final RegistryObject<Item> ANDESITE_WIRE;
    public static final RegistryObject<Item> ZINC_WIRE;
    public static final RegistryObject<Item> SHADOW_STEEL_WIRE;
    public static final RegistryObject<Item> NETHERSTEEL_WIRE;
    public static final RegistryObject<Item> NETHERITE_WIRE;
    public static final RegistryObject<Item> GRINDER_BELT;
    public static final RegistryObject<Item> SPRING_COILING_MACHINE_WHEEL;
    public static final RegistryObject<Item> LASER_ITEM;
    public static final RegistryObject<Item> SULFUR_CHUNK;
    public static final RegistryObject<Item> SULFUR;
    public static final RegistryObject<Item> VANADIUM_INGOT;
    public static final RegistryObject<Item> VANADIUM_NUGGET;
    public static final RegistryObject<Item> NETHERITE_SHEET;
    public static final RegistryObject<Item> NETHERSTEEL_SHEET;
    public static final RegistryObject<Item> IRONWOOD_SHEET;
    public static final RegistryObject<Item> KNIGHTMETAL_SHEET;
    public static final RegistryObject<Item> QUEENS_SLIME_SHEET;
    public static final RegistryObject<Item> SLIMESTEEL_SHEET;
    public static final RegistryObject<Item> VANADIUM_SHEET;
    public static final RegistryObject<Item> FIERY_SHEET;
    public static final RegistryObject<Item> ANDESITE_SHEET;
    public static final RegistryObject<Item> ZINC_SHEET;
    public static final RegistryObject<Item> SHADOW_STEEL_SHEET;
    public static boolean useEnergy;
    public static final RegistryObject<CreativeModeTab> VINTAGE_TAB;

    public static void logThis(String str) {
        LOGGER.info(str);
    }

    public Vintage() {
        Vintage.onCtor();
        MinecraftForge.EVENT_BUS.register((Object)this);
        useEnergy = ModList.get().isLoaded("createaddition") || ModList.get().isLoaded("mekanism") || ModList.get().isLoaded("thermal") || ModList.get().isLoaded("botarium") || ModList.get().isLoaded("immersiveengineering");
    }

    public static void onCtor() {
        ModLoadingContext modLoadingContext = ModLoadingContext.get();
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        IEventBus forgeEventBus = MinecraftForge.EVENT_BUS;
        MY_REGISTRATE.registerEventListeners(modEventBus);
        BLOCKS.register(modEventBus);
        ITEMS.register(modEventBus);
        CREATIVE_MODE_TABS.register(modEventBus);
        VintageBlocks.register();
        VintageItems.register();
        VintageFluids.register();
        VintageMenuTypes.register();
        VintageBlockEntity.register();
        VintageRecipes.register(modEventBus);
        VintagePartialModels.init();
        modEventBus.addListener(Vintage::commonSetup);
        VintageConfig.register(modLoadingContext);
    }

    private static void commonSetup(FMLCommonSetupEvent event) {
        VintageFluids.registerFluidInteractions();
        event.enqueueWork(() -> VintageAdvancements.register());
    }

    @SubscribeEvent
    public void onServerStarting(ServerStartingEvent event) {
        VintageRecipesList.init(event.getServer());
    }

    public static ResourceLocation asResource(String path) {
        return new ResourceLocation(MOD_ID, path);
    }

    static {
        MY_REGISTRATE.setTooltipModifierFactory(item -> new ItemDescription.Modifier(item, FontHelper.Palette.STANDARD_CREATE).andThen(TooltipModifier.mapNull((TooltipModifier)KineticStats.create((Item)item))));
        BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)MOD_ID);
        ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)MOD_ID);
        CREATIVE_MODE_TABS = DeferredRegister.create((ResourceKey)Registries.f_279569_, (String)MOD_ID);
        CALORITE_ROD = ITEMS.register("calorite_rod", () -> new Item(new Item.Properties()));
        OSTRUM_ROD = ITEMS.register("ostrum_rod", () -> new Item(new Item.Properties()));
        DESH_ROD = ITEMS.register("desh_rod", () -> new Item(new Item.Properties()));
        NETHERITE_ROD = ITEMS.register("netherite_rod", () -> new Item(new Item.Properties().m_41486_()));
        NETHERSTEEL_ROD = ITEMS.register("nethersteel_rod", () -> new Item(new Item.Properties()));
        IRONWOOD_ROD = ITEMS.register("ironwood_rod", () -> new Item(new Item.Properties()));
        KNIGHTMETAL_ROD = ITEMS.register("knightmetal_rod", () -> new Item(new Item.Properties()));
        QUEENS_SLIME_ROD = ITEMS.register("queens_slime_rod", () -> new Item(new Item.Properties()));
        SLIMESTEEL_ROD = ITEMS.register("slimesteel_rod", () -> new Item(new Item.Properties()));
        VANADIUM_ROD = ITEMS.register("vanadium_rod", () -> new Item(new Item.Properties()));
        ANDESITE_ROD = ITEMS.register("andesite_rod", () -> new Item(new Item.Properties()));
        ZINC_ROD = ITEMS.register("zinc_rod", () -> new Item(new Item.Properties()));
        SHADOW_STEEL_ROD = ITEMS.register("shadow_steel_rod", () -> new Item(new Item.Properties().m_41497_(Rarity.UNCOMMON)));
        CALORITE_WIRE = ITEMS.register("calorite_wire", () -> new Item(new Item.Properties()));
        OSTRUM_WIRE = ITEMS.register("ostrum_wire", () -> new Item(new Item.Properties()));
        DESH_WIRE = ITEMS.register("desh_wire", () -> new Item(new Item.Properties()));
        BRASS_WIRE = ITEMS.register("brass_wire", () -> new Item(new Item.Properties()));
        IRONWOOD_WIRE = ITEMS.register("ironwood_wire", () -> new Item(new Item.Properties()));
        KNIGHTMETAL_WIRE = ITEMS.register("knightmetal_wire", () -> new Item(new Item.Properties()));
        QUEENS_SLIME_WIRE = ITEMS.register("queens_slime_wire", () -> new Item(new Item.Properties()));
        SLIMESTEEL_WIRE = ITEMS.register("slimesteel_wire", () -> new Item(new Item.Properties()));
        VANADIUM_WIRE = ITEMS.register("vanadium_wire", () -> new Item(new Item.Properties()));
        FIERY_WIRE = ITEMS.register("fiery_wire", () -> new Item(new Item.Properties().m_41497_(Rarity.UNCOMMON).m_41486_()));
        ANDESITE_WIRE = ITEMS.register("andesite_wire", () -> new Item(new Item.Properties()));
        ZINC_WIRE = ITEMS.register("zinc_wire", () -> new Item(new Item.Properties()));
        SHADOW_STEEL_WIRE = ITEMS.register("shadow_steel_wire", () -> new Item(new Item.Properties().m_41497_(Rarity.UNCOMMON)));
        NETHERSTEEL_WIRE = ITEMS.register("nethersteel_wire", () -> new Item(new Item.Properties()));
        NETHERITE_WIRE = ITEMS.register("netherite_wire", () -> new Item(new Item.Properties().m_41486_()));
        GRINDER_BELT = ITEMS.register("grinder_belt", () -> new Item(new Item.Properties()));
        SPRING_COILING_MACHINE_WHEEL = ITEMS.register("spring_coiling_machine_wheel", () -> new Item(new Item.Properties()));
        LASER_ITEM = ITEMS.register("laser_item", () -> new Item(new Item.Properties()));
        SULFUR_CHUNK = ITEMS.register("sulfur_chunk", () -> new Item(new Item.Properties()));
        SULFUR = ITEMS.register("sulfur", () -> new Item(new Item.Properties()));
        VANADIUM_INGOT = ITEMS.register("vanadium_ingot", () -> new Item(new Item.Properties()));
        VANADIUM_NUGGET = ITEMS.register("vanadium_nugget", () -> new Item(new Item.Properties()));
        NETHERITE_SHEET = ITEMS.register("netherite_sheet", () -> new Item(new Item.Properties().m_41486_()));
        NETHERSTEEL_SHEET = ITEMS.register("nethersteel_sheet", () -> new Item(new Item.Properties()));
        IRONWOOD_SHEET = ITEMS.register("ironwood_sheet", () -> new Item(new Item.Properties()));
        KNIGHTMETAL_SHEET = ITEMS.register("knightmetal_sheet", () -> new Item(new Item.Properties()));
        QUEENS_SLIME_SHEET = ITEMS.register("queens_slime_sheet", () -> new Item(new Item.Properties()));
        SLIMESTEEL_SHEET = ITEMS.register("slimesteel_sheet", () -> new Item(new Item.Properties()));
        VANADIUM_SHEET = ITEMS.register("vanadium_sheet", () -> new Item(new Item.Properties()));
        FIERY_SHEET = ITEMS.register("fiery_sheet", () -> new Item(new Item.Properties().m_41497_(Rarity.UNCOMMON).m_41486_()));
        ANDESITE_SHEET = ITEMS.register("andesite_sheet", () -> new Item(new Item.Properties()));
        ZINC_SHEET = ITEMS.register("zinc_sheet", () -> new Item(new Item.Properties()));
        SHADOW_STEEL_SHEET = ITEMS.register("shadow_steel_sheet", () -> new Item(new Item.Properties().m_41497_(Rarity.UNCOMMON)));
        useEnergy = false;
        VINTAGE_TAB = CREATIVE_MODE_TABS.register("vintage_tab", () -> CreativeModeTab.builder().withTabsBefore(new ResourceKey[]{CreativeModeTabs.f_256797_}).m_257941_((Component)Component.m_237115_((String)"itemGroup.vintage")).m_257737_(() -> ((GrinderBlock)((Object)((Object)((Object)VintageBlocks.BELT_GRINDER.get())))).m_5456_().m_7968_()).m_257501_((parameters, output) -> {
            boolean forceItems = (Boolean)VintageConfig.client().forceCompatItemsIntoCreativeTab.get();
            boolean adAstraLoaded = ModList.get().isLoaded("ad_astra");
            boolean twilightForestLoaded = ModList.get().isLoaded("twilightforest");
            boolean tConstructLoaded = ModList.get().isLoaded("tconstruct");
            boolean bigCannonsLoaded = ModList.get().isLoaded("createbigcannons");
            output.m_246326_((ItemLike)VintageBlocks.BELT_GRINDER.get());
            output.m_246326_((ItemLike)VintageBlocks.SPRING_COILING_MACHINE.get());
            output.m_246326_((ItemLike)VintageBlocks.VACUUM_CHAMBER.get());
            output.m_246326_((ItemLike)VintageBlocks.VIBRATING_TABLE.get());
            output.m_246326_((ItemLike)VintageBlocks.CENTRIFUGE.get());
            output.m_246326_((ItemLike)VintageBlocks.CURVING_PRESS.get());
            output.m_246326_((ItemLike)VintageBlocks.HELVE.get());
            output.m_246326_((ItemLike)VintageBlocks.LATHE_ROTATING.get());
            output.m_246326_((ItemLike)VintageBlocks.LASER.get());
            output.m_246326_((ItemLike)VintageItems.CONVEX_CURVING_HEAD.get());
            output.m_246326_((ItemLike)VintageItems.CONCAVE_CURVING_HEAD.get());
            output.m_246326_((ItemLike)VintageItems.W_SHAPED_CURVING_HEAD.get());
            output.m_246326_((ItemLike)VintageItems.V_SHAPED_CURVING_HEAD.get());
            output.m_246326_((ItemLike)GRINDER_BELT.get());
            output.m_246326_((ItemLike)SPRING_COILING_MACHINE_WHEEL.get());
            output.m_246326_((ItemLike)LASER_ITEM.get());
            output.m_246326_((ItemLike)VintageItems.REDSTONE_MODULE.get());
            output.m_246326_((ItemLike)SULFUR_CHUNK.get());
            output.m_246326_((ItemLike)SULFUR.get());
            output.m_246326_((ItemLike)VintageBlocks.SULFUR_BLOCK.get());
            output.m_246326_((ItemLike)VANADIUM_NUGGET.get());
            output.m_246326_((ItemLike)VANADIUM_INGOT.get());
            output.m_246326_((ItemLike)VintageBlocks.VANADIUM_BLOCK.get());
            output.m_246326_((ItemLike)VintageFluids.SULFURIC_ACID.getBucket().get());
            output.m_246326_(VintageItems.COPPER_SULFATE);
            output.m_246326_(VintageItems.RECIPE_CARD);
            output.m_246326_(VintageItems.HELVE_HAMMER_SLOT_COVER);
            if (((Boolean)VintageConfig.client().legacyMaterialsIntoCreativeTab.get()).booleanValue()) {
                output.m_246326_((ItemLike)AllItems.REFINED_RADIANCE);
                output.m_246326_((ItemLike)AllItems.SHADOW_STEEL);
            }
            if (!((Boolean)VintageConfig.client().hideSheets.get()).booleanValue()) {
                if (!((TagDependentIngredientItem)VintageItems.ALUMINUM_SHEET.get()).shouldHide() || forceItems) {
                    output.m_246326_(VintageItems.ALUMINUM_SHEET);
                }
                if (!((TagDependentIngredientItem)VintageItems.AMETHYST_BRONZE_SHEET.get()).shouldHide() || forceItems) {
                    output.m_246326_(VintageItems.AMETHYST_BRONZE_SHEET);
                }
                output.m_246326_((ItemLike)ANDESITE_SHEET.get());
                if (!((TagDependentIngredientItem)VintageItems.BRONZE_SHEET.get()).shouldHide() || forceItems) {
                    output.m_246326_(VintageItems.BRONZE_SHEET);
                }
                if (!((TagDependentIngredientItem)VintageItems.CAST_IRON_SHEET.get()).shouldHide() || forceItems) {
                    output.m_246326_(VintageItems.CAST_IRON_SHEET);
                }
                if (!((TagDependentIngredientItem)VintageItems.COBALT_SHEET.get()).shouldHide() || forceItems) {
                    output.m_246326_(VintageItems.COBALT_SHEET);
                }
                if (!((TagDependentIngredientItem)VintageItems.CONSTANTAN_SHEET.get()).shouldHide() || forceItems) {
                    output.m_246326_(VintageItems.CONSTANTAN_SHEET);
                }
                if (!((TagDependentIngredientItem)VintageItems.ENDERIUM_SHEET.get()).shouldHide() || forceItems) {
                    output.m_246326_(VintageItems.ENDERIUM_SHEET);
                }
                if (twilightForestLoaded || forceItems) {
                    output.m_246326_((ItemLike)FIERY_SHEET.get());
                }
                if (!((TagDependentIngredientItem)VintageItems.HEPATIZON_SHEET.get()).shouldHide() || forceItems) {
                    output.m_246326_(VintageItems.HEPATIZON_SHEET);
                }
                if (!((TagDependentIngredientItem)VintageItems.INVAR_SHEET.get()).shouldHide() || forceItems) {
                    output.m_246326_(VintageItems.INVAR_SHEET);
                }
                if (twilightForestLoaded || forceItems) {
                    output.m_246326_((ItemLike)IRONWOOD_SHEET.get());
                    output.m_246326_((ItemLike)KNIGHTMETAL_SHEET.get());
                }
                if (!((TagDependentIngredientItem)VintageItems.LEAD_SHEET.get()).shouldHide() || forceItems) {
                    output.m_246326_(VintageItems.LEAD_SHEET);
                }
                if (!((TagDependentIngredientItem)VintageItems.LUMIUM_SHEET.get()).shouldHide() || forceItems) {
                    output.m_246326_(VintageItems.LUMIUM_SHEET);
                }
                if (!((TagDependentIngredientItem)VintageItems.MANYULLYN_SHEET.get()).shouldHide() || forceItems) {
                    output.m_246326_(VintageItems.MANYULLYN_SHEET);
                }
                output.m_246326_((ItemLike)NETHERITE_SHEET.get());
                if (bigCannonsLoaded || forceItems) {
                    output.m_246326_((ItemLike)NETHERSTEEL_SHEET.get());
                }
                if (!((TagDependentIngredientItem)VintageItems.NICKEL_SHEET.get()).shouldHide() || forceItems) {
                    output.m_246326_(VintageItems.NICKEL_SHEET);
                }
                if (!((TagDependentIngredientItem)VintageItems.OSMIUM_SHEET.get()).shouldHide() || forceItems) {
                    output.m_246326_(VintageItems.OSMIUM_SHEET);
                }
                if (!((TagDependentIngredientItem)VintageItems.PALLADIUM_SHEET.get()).shouldHide() || forceItems) {
                    output.m_246326_((ItemLike)VintageItems.PALLADIUM_SHEET.get());
                }
                if (!((TagDependentIngredientItem)VintageItems.PIG_IRON_SHEET.get()).shouldHide() || forceItems) {
                    output.m_246326_((ItemLike)VintageItems.PIG_IRON_SHEET.get());
                }
                if (!((TagDependentIngredientItem)VintageItems.PLATINUM_SHEET.get()).shouldHide() || forceItems) {
                    output.m_246326_((ItemLike)VintageItems.PLATINUM_SHEET.get());
                }
                if (!((TagDependentIngredientItem)VintageItems.PURE_GOLD_SHEET.get()).shouldHide() || forceItems) {
                    output.m_246326_((ItemLike)VintageItems.PURE_GOLD_SHEET.get());
                }
                if (tConstructLoaded || forceItems) {
                    output.m_246326_((ItemLike)QUEENS_SLIME_SHEET.get());
                }
                if (!((TagDependentIngredientItem)VintageItems.REFINED_GLOWSTONE_SHEET.get()).shouldHide() || forceItems) {
                    output.m_246326_((ItemLike)VintageItems.REFINED_GLOWSTONE_SHEET.get());
                }
                if (!((TagDependentIngredientItem)VintageItems.REFINED_OBSIDIAN_SHEET.get()).shouldHide() || forceItems) {
                    output.m_246326_((ItemLike)VintageItems.REFINED_OBSIDIAN_SHEET.get());
                }
                if (((Boolean)VintageConfig.client().legacyMaterialsIntoCreativeTab.get()).booleanValue()) {
                    output.m_246326_((ItemLike)VintageItems.REFINED_RADIANCE_SHEET.get());
                }
                if (!((TagDependentIngredientItem)VintageItems.RHODIUM_SHEET.get()).shouldHide() || forceItems) {
                    output.m_246326_((ItemLike)VintageItems.RHODIUM_SHEET.get());
                }
                if (!((TagDependentIngredientItem)VintageItems.ROSE_GOLD_SHEET.get()).shouldHide() || forceItems) {
                    output.m_246326_((ItemLike)VintageItems.ROSE_GOLD_SHEET.get());
                }
                if (((Boolean)VintageConfig.client().legacyMaterialsIntoCreativeTab.get()).booleanValue()) {
                    output.m_246326_((ItemLike)SHADOW_STEEL_SHEET.get());
                }
                if (!((TagDependentIngredientItem)VintageItems.SIGNALUM_SHEET.get()).shouldHide() || forceItems) {
                    output.m_246326_((ItemLike)VintageItems.SIGNALUM_SHEET.get());
                }
                if (!((TagDependentIngredientItem)VintageItems.SILVER_SHEET.get()).shouldHide() || forceItems) {
                    output.m_246326_((ItemLike)VintageItems.SILVER_SHEET.get());
                }
                if (tConstructLoaded || forceItems) {
                    output.m_246326_((ItemLike)SLIMESTEEL_SHEET.get());
                }
                if (!((TagDependentIngredientItem)VintageItems.TIN_SHEET.get()).shouldHide() || forceItems) {
                    output.m_246326_((ItemLike)VintageItems.TIN_SHEET.get());
                }
                if (!((TagDependentIngredientItem)VintageItems.URANIUM_SHEET.get()).shouldHide() || forceItems) {
                    output.m_246326_((ItemLike)VintageItems.URANIUM_SHEET.get());
                }
                output.m_246326_((ItemLike)VANADIUM_SHEET.get());
                output.m_246326_((ItemLike)ZINC_SHEET.get());
            }
            if (!((Boolean)VintageConfig.client().hideRods.get()).booleanValue()) {
                if (!((TagDependentIngredientItem)VintageItems.ALUMINUM_ROD.get()).shouldHide() || forceItems) {
                    output.m_246326_(VintageItems.ALUMINUM_ROD);
                }
                if (!((TagDependentIngredientItem)VintageItems.AMETHYST_BRONZE_ROD.get()).shouldHide() || forceItems) {
                    output.m_246326_(VintageItems.AMETHYST_BRONZE_ROD);
                }
                output.m_246326_((ItemLike)ANDESITE_ROD.get());
                if (!((TagDependentIngredientItem)VintageItems.BRONZE_ROD.get()).shouldHide() || forceItems) {
                    output.m_246326_(VintageItems.BRONZE_ROD);
                }
                if (adAstraLoaded || forceItems) {
                    output.m_246326_((ItemLike)CALORITE_ROD.get());
                }
                if (!((TagDependentIngredientItem)VintageItems.CAST_IRON_ROD.get()).shouldHide() || forceItems) {
                    output.m_246326_(VintageItems.CAST_IRON_ROD);
                }
                if (!((TagDependentIngredientItem)VintageItems.COBALT_ROD.get()).shouldHide() || forceItems) {
                    output.m_246326_(VintageItems.COBALT_ROD);
                }
                if (!((TagDependentIngredientItem)VintageItems.CONSTANTAN_ROD.get()).shouldHide() || forceItems) {
                    output.m_246326_(VintageItems.CONSTANTAN_ROD);
                }
                if (adAstraLoaded || forceItems) {
                    output.m_246326_((ItemLike)DESH_ROD.get());
                }
                if (!((TagDependentIngredientItem)VintageItems.ENDERIUM_ROD.get()).shouldHide() || forceItems) {
                    output.m_246326_(VintageItems.ENDERIUM_ROD);
                }
                if (!((TagDependentIngredientItem)VintageItems.HEPATIZON_ROD.get()).shouldHide() || forceItems) {
                    output.m_246326_(VintageItems.HEPATIZON_ROD);
                }
                if (!((TagDependentIngredientItem)VintageItems.INVAR_ROD.get()).shouldHide() || forceItems) {
                    output.m_246326_(VintageItems.INVAR_ROD);
                }
                if (twilightForestLoaded || forceItems) {
                    output.m_246326_((ItemLike)IRONWOOD_ROD.get());
                    output.m_246326_((ItemLike)KNIGHTMETAL_ROD.get());
                }
                if (!((TagDependentIngredientItem)VintageItems.LEAD_ROD.get()).shouldHide() || forceItems) {
                    output.m_246326_(VintageItems.LEAD_ROD);
                }
                if (!((TagDependentIngredientItem)VintageItems.LUMIUM_ROD.get()).shouldHide() || forceItems) {
                    output.m_246326_(VintageItems.LUMIUM_ROD);
                }
                if (!((TagDependentIngredientItem)VintageItems.MANYULLYN_ROD.get()).shouldHide() || forceItems) {
                    output.m_246326_(VintageItems.MANYULLYN_ROD);
                }
                output.m_246326_((ItemLike)NETHERITE_ROD.get());
                if (bigCannonsLoaded || forceItems) {
                    output.m_246326_((ItemLike)NETHERSTEEL_ROD.get());
                }
                if (!((TagDependentIngredientItem)VintageItems.NICKEL_ROD.get()).shouldHide() || forceItems) {
                    output.m_246326_(VintageItems.NICKEL_ROD);
                }
                if (!((TagDependentIngredientItem)VintageItems.OSMIUM_ROD.get()).shouldHide() || forceItems) {
                    output.m_246326_(VintageItems.OSMIUM_ROD);
                }
                if (adAstraLoaded || forceItems) {
                    output.m_246326_((ItemLike)OSTRUM_ROD.get());
                }
                if (!((TagDependentIngredientItem)VintageItems.PALLADIUM_ROD.get()).shouldHide() || forceItems) {
                    output.m_246326_((ItemLike)VintageItems.PALLADIUM_ROD.get());
                }
                if (!((TagDependentIngredientItem)VintageItems.PIG_IRON_ROD.get()).shouldHide() || forceItems) {
                    output.m_246326_((ItemLike)VintageItems.PIG_IRON_ROD.get());
                }
                if (!((TagDependentIngredientItem)VintageItems.PLATINUM_ROD.get()).shouldHide() || forceItems) {
                    output.m_246326_((ItemLike)VintageItems.PLATINUM_ROD.get());
                }
                if (!((TagDependentIngredientItem)VintageItems.PURE_GOLD_ROD.get()).shouldHide() || forceItems) {
                    output.m_246326_((ItemLike)VintageItems.PURE_GOLD_ROD.get());
                }
                if (tConstructLoaded || forceItems) {
                    output.m_246326_((ItemLike)QUEENS_SLIME_ROD.get());
                }
                if (!((TagDependentIngredientItem)VintageItems.REFINED_GLOWSTONE_ROD.get()).shouldHide() || forceItems) {
                    output.m_246326_((ItemLike)VintageItems.REFINED_GLOWSTONE_ROD.get());
                }
                if (!((TagDependentIngredientItem)VintageItems.REFINED_OBSIDIAN_ROD.get()).shouldHide() || forceItems) {
                    output.m_246326_((ItemLike)VintageItems.REFINED_OBSIDIAN_ROD.get());
                }
                if (((Boolean)VintageConfig.client().legacyMaterialsIntoCreativeTab.get()).booleanValue()) {
                    output.m_246326_((ItemLike)VintageItems.REFINED_RADIANCE_ROD.get());
                }
                if (!((TagDependentIngredientItem)VintageItems.RHODIUM_ROD.get()).shouldHide() || forceItems) {
                    output.m_246326_((ItemLike)VintageItems.RHODIUM_ROD.get());
                }
                if (!((TagDependentIngredientItem)VintageItems.ROSE_GOLD_ROD.get()).shouldHide() || forceItems) {
                    output.m_246326_((ItemLike)VintageItems.ROSE_GOLD_ROD.get());
                }
                if (((Boolean)VintageConfig.client().legacyMaterialsIntoCreativeTab.get()).booleanValue()) {
                    output.m_246326_((ItemLike)SHADOW_STEEL_ROD.get());
                }
                if (!((TagDependentIngredientItem)VintageItems.SIGNALUM_ROD.get()).shouldHide() || forceItems) {
                    output.m_246326_((ItemLike)VintageItems.SIGNALUM_ROD.get());
                }
                if (!((TagDependentIngredientItem)VintageItems.SILVER_ROD.get()).shouldHide() || forceItems) {
                    output.m_246326_((ItemLike)VintageItems.SILVER_ROD.get());
                }
                if (tConstructLoaded || forceItems) {
                    output.m_246326_((ItemLike)SLIMESTEEL_ROD.get());
                }
                if (!((TagDependentIngredientItem)VintageItems.STEEL_ROD.get()).shouldHide() || forceItems) {
                    output.m_246326_((ItemLike)VintageItems.STEEL_ROD.get());
                }
                if (!((TagDependentIngredientItem)VintageItems.TIN_ROD.get()).shouldHide() || forceItems) {
                    output.m_246326_((ItemLike)VintageItems.TIN_ROD.get());
                }
                if (!((TagDependentIngredientItem)VintageItems.URANIUM_ROD.get()).shouldHide() || forceItems) {
                    output.m_246326_((ItemLike)VintageItems.URANIUM_ROD.get());
                }
                output.m_246326_((ItemLike)VANADIUM_ROD.get());
                output.m_246326_((ItemLike)ZINC_ROD.get());
            }
            if (!((Boolean)VintageConfig.client().hideWires.get()).booleanValue()) {
                if (!((TagDependentIngredientItem)VintageItems.ALUMINUM_WIRE.get()).shouldHide() || forceItems) {
                    output.m_246326_(VintageItems.ALUMINUM_WIRE);
                }
                if (!((TagDependentIngredientItem)VintageItems.AMETHYST_BRONZE_WIRE.get()).shouldHide() || forceItems) {
                    output.m_246326_(VintageItems.AMETHYST_BRONZE_WIRE);
                }
                output.m_246326_((ItemLike)ANDESITE_WIRE.get());
                output.m_246326_((ItemLike)BRASS_WIRE.get());
                if (!((TagDependentIngredientItem)VintageItems.BRONZE_WIRE.get()).shouldHide() || forceItems) {
                    output.m_246326_(VintageItems.BRONZE_WIRE);
                }
                if (adAstraLoaded || forceItems) {
                    output.m_246326_((ItemLike)CALORITE_WIRE.get());
                }
                if (!((TagDependentIngredientItem)VintageItems.CAST_IRON_WIRE.get()).shouldHide() || forceItems) {
                    output.m_246326_(VintageItems.CAST_IRON_WIRE);
                }
                if (!((TagDependentIngredientItem)VintageItems.COBALT_WIRE.get()).shouldHide() || forceItems) {
                    output.m_246326_(VintageItems.COBALT_WIRE);
                }
                if (!((TagDependentIngredientItem)VintageItems.CONSTANTAN_WIRE.get()).shouldHide() || forceItems) {
                    output.m_246326_(VintageItems.CONSTANTAN_WIRE);
                }
                if (adAstraLoaded || forceItems) {
                    output.m_246326_((ItemLike)DESH_WIRE.get());
                }
                if (!((TagDependentIngredientItem)VintageItems.ENDERIUM_WIRE.get()).shouldHide() || forceItems) {
                    output.m_246326_(VintageItems.ENDERIUM_WIRE);
                }
                if (twilightForestLoaded || forceItems) {
                    output.m_246326_((ItemLike)FIERY_WIRE.get());
                }
                if (!((TagDependentIngredientItem)VintageItems.HEPATIZON_WIRE.get()).shouldHide() || forceItems) {
                    output.m_246326_(VintageItems.HEPATIZON_WIRE);
                }
                if (!((TagDependentIngredientItem)VintageItems.INVAR_WIRE.get()).shouldHide() || forceItems) {
                    output.m_246326_(VintageItems.INVAR_WIRE);
                }
                if (twilightForestLoaded || forceItems) {
                    output.m_246326_((ItemLike)IRONWOOD_WIRE.get());
                    output.m_246326_((ItemLike)KNIGHTMETAL_WIRE.get());
                }
                if (!((TagDependentIngredientItem)VintageItems.LEAD_WIRE.get()).shouldHide() || forceItems) {
                    output.m_246326_(VintageItems.LEAD_WIRE);
                }
                if (!((TagDependentIngredientItem)VintageItems.LUMIUM_WIRE.get()).shouldHide() || forceItems) {
                    output.m_246326_(VintageItems.LUMIUM_WIRE);
                }
                if (!((TagDependentIngredientItem)VintageItems.MANYULLYN_WIRE.get()).shouldHide() || forceItems) {
                    output.m_246326_(VintageItems.MANYULLYN_WIRE);
                }
                output.m_246326_((ItemLike)NETHERITE_WIRE.get());
                if (bigCannonsLoaded || forceItems) {
                    output.m_246326_((ItemLike)NETHERSTEEL_WIRE.get());
                }
                if (!((TagDependentIngredientItem)VintageItems.NICKEL_WIRE.get()).shouldHide() || forceItems) {
                    output.m_246326_(VintageItems.NICKEL_WIRE);
                }
                if (!((TagDependentIngredientItem)VintageItems.OSMIUM_WIRE.get()).shouldHide() || forceItems) {
                    output.m_246326_(VintageItems.OSMIUM_WIRE);
                }
                if (adAstraLoaded || forceItems) {
                    output.m_246326_((ItemLike)OSTRUM_WIRE.get());
                }
                if (!((TagDependentIngredientItem)VintageItems.PALLADIUM_WIRE.get()).shouldHide() || forceItems) {
                    output.m_246326_((ItemLike)VintageItems.PALLADIUM_WIRE.get());
                }
                if (!((TagDependentIngredientItem)VintageItems.PIG_IRON_WIRE.get()).shouldHide() || forceItems) {
                    output.m_246326_((ItemLike)VintageItems.PIG_IRON_WIRE.get());
                }
                if (!((TagDependentIngredientItem)VintageItems.PLATINUM_WIRE.get()).shouldHide() || forceItems) {
                    output.m_246326_((ItemLike)VintageItems.PLATINUM_WIRE.get());
                }
                if (!((TagDependentIngredientItem)VintageItems.PURE_GOLD_WIRE.get()).shouldHide() || forceItems) {
                    output.m_246326_((ItemLike)VintageItems.PURE_GOLD_WIRE.get());
                }
                if (tConstructLoaded || forceItems) {
                    output.m_246326_((ItemLike)QUEENS_SLIME_WIRE.get());
                }
                if (!((TagDependentIngredientItem)VintageItems.REFINED_GLOWSTONE_WIRE.get()).shouldHide() || forceItems) {
                    output.m_246326_((ItemLike)VintageItems.REFINED_GLOWSTONE_WIRE.get());
                }
                if (!((TagDependentIngredientItem)VintageItems.REFINED_OBSIDIAN_WIRE.get()).shouldHide() || forceItems) {
                    output.m_246326_((ItemLike)VintageItems.REFINED_OBSIDIAN_WIRE.get());
                }
                if (((Boolean)VintageConfig.client().legacyMaterialsIntoCreativeTab.get()).booleanValue()) {
                    output.m_246326_((ItemLike)VintageItems.REFINED_RADIANCE_WIRE.get());
                }
                if (!((TagDependentIngredientItem)VintageItems.RHODIUM_WIRE.get()).shouldHide() || forceItems) {
                    output.m_246326_((ItemLike)VintageItems.RHODIUM_WIRE.get());
                }
                if (!((TagDependentIngredientItem)VintageItems.ROSE_GOLD_WIRE.get()).shouldHide() || forceItems) {
                    output.m_246326_((ItemLike)VintageItems.ROSE_GOLD_WIRE.get());
                }
                if (((Boolean)VintageConfig.client().legacyMaterialsIntoCreativeTab.get()).booleanValue()) {
                    output.m_246326_((ItemLike)SHADOW_STEEL_WIRE.get());
                }
                if (!((TagDependentIngredientItem)VintageItems.SIGNALUM_WIRE.get()).shouldHide() || forceItems) {
                    output.m_246326_((ItemLike)VintageItems.SIGNALUM_WIRE.get());
                }
                if (!((TagDependentIngredientItem)VintageItems.SILVER_WIRE.get()).shouldHide() || forceItems) {
                    output.m_246326_((ItemLike)VintageItems.SILVER_WIRE.get());
                }
                if (tConstructLoaded || forceItems) {
                    output.m_246326_((ItemLike)SLIMESTEEL_WIRE.get());
                }
                if (!((TagDependentIngredientItem)VintageItems.STEEL_WIRE.get()).shouldHide() || forceItems) {
                    output.m_246326_((ItemLike)VintageItems.STEEL_WIRE.get());
                }
                if (!((TagDependentIngredientItem)VintageItems.TIN_WIRE.get()).shouldHide() || forceItems) {
                    output.m_246326_((ItemLike)VintageItems.TIN_WIRE.get());
                }
                if (!((TagDependentIngredientItem)VintageItems.URANIUM_WIRE.get()).shouldHide() || forceItems) {
                    output.m_246326_((ItemLike)VintageItems.URANIUM_WIRE.get());
                }
                output.m_246326_((ItemLike)VANADIUM_WIRE.get());
                output.m_246326_((ItemLike)ZINC_WIRE.get());
            }
            if (!((Boolean)VintageConfig.client().hideSprings.get()).booleanValue()) {
                if (!((TagDependentSpringItem)((Object)((Object)((Object)VintageItems.ALUMINUM_SPRING.get())))).shouldHide() || forceItems) {
                    output.m_246326_(VintageItems.ALUMINUM_SPRING);
                }
                if (!((TagDependentSpringItem)((Object)((Object)((Object)VintageItems.AMETHYST_BRONZE_SPRING.get())))).shouldHide() || forceItems) {
                    output.m_246326_(VintageItems.AMETHYST_BRONZE_SPRING);
                }
                output.m_246326_((ItemLike)VintageItems.ANDESITE_SPRING.get());
                output.m_246326_((ItemLike)VintageItems.BLAZE_SPRING.get());
                output.m_246326_(VintageItems.BRASS_SPRING);
                if (!((TagDependentSpringItem)((Object)((Object)((Object)VintageItems.BRONZE_SPRING.get())))).shouldHide() || forceItems) {
                    output.m_246326_(VintageItems.BRONZE_SPRING);
                }
                if (adAstraLoaded || forceItems) {
                    output.m_246326_((ItemLike)VintageItems.CALORITE_SPRING.get());
                }
                if (!((TagDependentSpringItem)((Object)((Object)((Object)VintageItems.CAST_IRON_SPRING.get())))).shouldHide() || forceItems) {
                    output.m_246326_(VintageItems.CAST_IRON_SPRING);
                }
                if (!((TagDependentSpringItem)((Object)((Object)((Object)VintageItems.COBALT_SPRING.get())))).shouldHide() || forceItems) {
                    output.m_246326_(VintageItems.COBALT_SPRING);
                }
                if (!((TagDependentSpringItem)((Object)((Object)((Object)VintageItems.CONSTANTAN_SPRING.get())))).shouldHide() || forceItems) {
                    output.m_246326_(VintageItems.CONSTANTAN_SPRING);
                }
                output.m_246326_(VintageItems.COPPER_SPRING);
                if (adAstraLoaded || forceItems) {
                    output.m_246326_((ItemLike)VintageItems.DESH_SPRING.get());
                }
                if (!((TagDependentSpringItem)((Object)((Object)((Object)VintageItems.ELECTRUM_SPRING.get())))).shouldHide() || forceItems) {
                    output.m_246326_(VintageItems.ELECTRUM_SPRING);
                }
                if (!((TagDependentSpringItem)((Object)((Object)((Object)VintageItems.ENDERIUM_SPRING.get())))).shouldHide() || forceItems) {
                    output.m_246326_(VintageItems.ENDERIUM_SPRING);
                }
                output.m_246326_((ItemLike)VintageItems.GOLDEN_SPRING.get());
                if (!((TagDependentSpringItem)((Object)((Object)((Object)VintageItems.HEPATIZON_SPRING.get())))).shouldHide() || forceItems) {
                    output.m_246326_(VintageItems.HEPATIZON_SPRING);
                }
                if (!((TagDependentSpringItem)((Object)((Object)((Object)VintageItems.INVAR_SPRING.get())))).shouldHide() || forceItems) {
                    output.m_246326_(VintageItems.INVAR_SPRING);
                }
                output.m_246326_(VintageItems.IRON_SPRING);
                if (twilightForestLoaded || forceItems) {
                    output.m_246326_((ItemLike)VintageItems.IRONWOOD_SPRING.get());
                    output.m_246326_((ItemLike)VintageItems.KNIGHTMETAL_SPRING.get());
                }
                if (!((TagDependentSpringItem)((Object)((Object)((Object)VintageItems.LEAD_SPRING.get())))).shouldHide() || forceItems) {
                    output.m_246326_(VintageItems.LEAD_SPRING);
                }
                if (!((TagDependentSpringItem)((Object)((Object)((Object)VintageItems.LUMIUM_SPRING.get())))).shouldHide() || forceItems) {
                    output.m_246326_(VintageItems.LUMIUM_SPRING);
                }
                if (!((TagDependentSpringItem)((Object)((Object)((Object)VintageItems.MANYULLYN_SPRING.get())))).shouldHide() || forceItems) {
                    output.m_246326_(VintageItems.MANYULLYN_SPRING);
                }
                output.m_246326_((ItemLike)VintageItems.NETHERITE_SPRING.get());
                if (bigCannonsLoaded || forceItems) {
                    output.m_246326_((ItemLike)VintageItems.NETHERSTEEL_SPRING.get());
                }
                if (!((TagDependentSpringItem)((Object)((Object)((Object)VintageItems.NICKEL_SPRING.get())))).shouldHide() || forceItems) {
                    output.m_246326_(VintageItems.NICKEL_SPRING);
                }
                if (!((TagDependentSpringItem)((Object)((Object)((Object)VintageItems.OSMIUM_SPRING.get())))).shouldHide() || forceItems) {
                    output.m_246326_(VintageItems.OSMIUM_SPRING);
                }
                if (adAstraLoaded || forceItems) {
                    output.m_246326_((ItemLike)VintageItems.OSTRUM_SPRING.get());
                }
                if (!((TagDependentSpringItem)((Object)((Object)((Object)VintageItems.PALLADIUM_SPRING.get())))).shouldHide() || forceItems) {
                    output.m_246326_((ItemLike)VintageItems.PALLADIUM_SPRING.get());
                }
                if (!((TagDependentSpringItem)((Object)((Object)((Object)VintageItems.PIG_IRON_SPRING.get())))).shouldHide() || forceItems) {
                    output.m_246326_((ItemLike)VintageItems.PIG_IRON_SPRING.get());
                }
                if (!((TagDependentSpringItem)((Object)((Object)((Object)VintageItems.PLATINUM_SPRING.get())))).shouldHide() || forceItems) {
                    output.m_246326_((ItemLike)VintageItems.PLATINUM_SPRING.get());
                }
                if (!((TagDependentSpringItem)((Object)((Object)((Object)VintageItems.PURE_GOLD_SPRING.get())))).shouldHide() || forceItems) {
                    output.m_246326_((ItemLike)VintageItems.PURE_GOLD_SPRING.get());
                }
                if (tConstructLoaded || forceItems) {
                    output.m_246326_((ItemLike)VintageItems.QUEENS_SLIME_SPRING.get());
                }
                if (!((TagDependentSpringItem)((Object)((Object)((Object)VintageItems.REFINED_GLOWSTONE_SPRING.get())))).shouldHide() || forceItems) {
                    output.m_246326_((ItemLike)VintageItems.REFINED_GLOWSTONE_SPRING.get());
                }
                if (!((TagDependentSpringItem)((Object)((Object)((Object)VintageItems.REFINED_OBSIDIAN_SPRING.get())))).shouldHide() || forceItems) {
                    output.m_246326_((ItemLike)VintageItems.REFINED_OBSIDIAN_SPRING.get());
                }
                if (((Boolean)VintageConfig.client().legacyMaterialsIntoCreativeTab.get()).booleanValue()) {
                    output.m_246326_((ItemLike)VintageItems.REFINED_RADIANCE_SPRING.get());
                }
                if (!((TagDependentSpringItem)((Object)((Object)((Object)VintageItems.RHODIUM_SPRING.get())))).shouldHide() || forceItems) {
                    output.m_246326_((ItemLike)VintageItems.RHODIUM_SPRING.get());
                }
                if (!((TagDependentSpringItem)((Object)((Object)((Object)VintageItems.ROSE_GOLD_SPRING.get())))).shouldHide() || forceItems) {
                    output.m_246326_((ItemLike)VintageItems.ROSE_GOLD_SPRING.get());
                }
                if (((Boolean)VintageConfig.client().legacyMaterialsIntoCreativeTab.get()).booleanValue()) {
                    output.m_246326_((ItemLike)VintageItems.SHADOW_STEEL_SPRING.get());
                }
                if (!((TagDependentSpringItem)((Object)((Object)((Object)VintageItems.SIGNALUM_SPRING.get())))).shouldHide() || forceItems) {
                    output.m_246326_((ItemLike)VintageItems.SIGNALUM_SPRING.get());
                }
                if (!((TagDependentSpringItem)((Object)((Object)((Object)VintageItems.SILVER_SPRING.get())))).shouldHide() || forceItems) {
                    output.m_246326_((ItemLike)VintageItems.SILVER_SPRING.get());
                }
                if (tConstructLoaded || forceItems) {
                    output.m_246326_((ItemLike)VintageItems.SLIMESTEEL_SPRING.get());
                }
                if (!((TagDependentSpringItem)((Object)((Object)((Object)VintageItems.STEEL_SPRING.get())))).shouldHide() || forceItems) {
                    output.m_246326_((ItemLike)VintageItems.STEEL_SPRING.get());
                }
                if (!((TagDependentSpringItem)((Object)((Object)((Object)VintageItems.TIN_SPRING.get())))).shouldHide() || forceItems) {
                    output.m_246326_((ItemLike)VintageItems.TIN_SPRING.get());
                }
                if (!((TagDependentSpringItem)((Object)((Object)((Object)VintageItems.URANIUM_SPRING.get())))).shouldHide() || forceItems) {
                    output.m_246326_((ItemLike)VintageItems.URANIUM_SPRING.get());
                }
                output.m_246326_((ItemLike)VintageItems.VANADIUM_SPRING.get());
                output.m_246326_((ItemLike)VintageItems.ZINC_SPRING.get());
            }
            if (!((Boolean)VintageConfig.client().hideSmallSprings.get()).booleanValue()) {
                if (!((TagDependentSpringItem)((Object)((Object)((Object)VintageItems.SMALL_ALUMINUM_SPRING.get())))).shouldHide() || forceItems) {
                    output.m_246326_(VintageItems.SMALL_ALUMINUM_SPRING);
                }
                if (!((TagDependentSpringItem)((Object)((Object)((Object)VintageItems.SMALL_AMETHYST_BRONZE_SPRING.get())))).shouldHide() || forceItems) {
                    output.m_246326_(VintageItems.SMALL_AMETHYST_BRONZE_SPRING);
                }
                output.m_246326_((ItemLike)VintageItems.SMALL_ANDESITE_SPRING.get());
                output.m_246326_((ItemLike)VintageItems.SMALL_BRASS_SPRING.get());
                if (!((TagDependentSpringItem)((Object)((Object)((Object)VintageItems.SMALL_BRONZE_SPRING.get())))).shouldHide() || forceItems) {
                    output.m_246326_(VintageItems.SMALL_BRONZE_SPRING);
                }
                if (adAstraLoaded || forceItems) {
                    output.m_246326_((ItemLike)VintageItems.SMALL_CALORITE_SPRING.get());
                }
                if (!((TagDependentSpringItem)((Object)((Object)((Object)VintageItems.SMALL_CAST_IRON_SPRING.get())))).shouldHide() || forceItems) {
                    output.m_246326_(VintageItems.SMALL_CAST_IRON_SPRING);
                }
                if (!((TagDependentSpringItem)((Object)((Object)((Object)VintageItems.SMALL_COBALT_SPRING.get())))).shouldHide() || forceItems) {
                    output.m_246326_(VintageItems.SMALL_COBALT_SPRING);
                }
                if (!((TagDependentSpringItem)((Object)((Object)((Object)VintageItems.SMALL_CONSTANTAN_SPRING.get())))).shouldHide() || forceItems) {
                    output.m_246326_(VintageItems.SMALL_CONSTANTAN_SPRING);
                }
                output.m_246326_((ItemLike)VintageItems.SMALL_COPPER_SPRING.get());
                if (adAstraLoaded || forceItems) {
                    output.m_246326_((ItemLike)VintageItems.SMALL_DESH_SPRING.get());
                }
                if (!((TagDependentSpringItem)((Object)((Object)((Object)VintageItems.SMALL_ELECTRUM_SPRING.get())))).shouldHide() || forceItems) {
                    output.m_246326_(VintageItems.SMALL_ELECTRUM_SPRING);
                }
                if (!((TagDependentSpringItem)((Object)((Object)((Object)VintageItems.SMALL_ENDERIUM_SPRING.get())))).shouldHide() || forceItems) {
                    output.m_246326_(VintageItems.SMALL_ENDERIUM_SPRING);
                }
                if (twilightForestLoaded || forceItems) {
                    output.m_246326_((ItemLike)VintageItems.SMALL_FIERY_SPRING.get());
                }
                output.m_246326_((ItemLike)VintageItems.SMALL_GOLDEN_SPRING.get());
                if (!((TagDependentSpringItem)((Object)((Object)((Object)VintageItems.SMALL_HEPATIZON_SPRING.get())))).shouldHide() || forceItems) {
                    output.m_246326_(VintageItems.SMALL_HEPATIZON_SPRING);
                }
                if (!((TagDependentSpringItem)((Object)((Object)((Object)VintageItems.SMALL_INVAR_SPRING.get())))).shouldHide() || forceItems) {
                    output.m_246326_(VintageItems.SMALL_INVAR_SPRING);
                }
                output.m_246326_((ItemLike)VintageItems.SMALL_IRON_SPRING.get());
                if (twilightForestLoaded || forceItems) {
                    output.m_246326_((ItemLike)VintageItems.SMALL_IRONWOOD_SPRING.get());
                    output.m_246326_((ItemLike)VintageItems.SMALL_KNIGHTMETAL_SPRING.get());
                }
                if (!((TagDependentSpringItem)((Object)((Object)((Object)VintageItems.SMALL_LEAD_SPRING.get())))).shouldHide() || forceItems) {
                    output.m_246326_(VintageItems.SMALL_LEAD_SPRING);
                }
                if (!((TagDependentSpringItem)((Object)((Object)((Object)VintageItems.SMALL_LUMIUM_SPRING.get())))).shouldHide() || forceItems) {
                    output.m_246326_(VintageItems.SMALL_LUMIUM_SPRING);
                }
                if (!((TagDependentSpringItem)((Object)((Object)((Object)VintageItems.SMALL_MANYULLYN_SPRING.get())))).shouldHide() || forceItems) {
                    output.m_246326_(VintageItems.SMALL_MANYULLYN_SPRING);
                }
                output.m_246326_((ItemLike)VintageItems.SMALL_NETHERITE_SPRING.get());
                if (bigCannonsLoaded || forceItems) {
                    output.m_246326_((ItemLike)VintageItems.SMALL_NETHERSTEEL_SPRING.get());
                }
                if (!((TagDependentSpringItem)((Object)((Object)((Object)VintageItems.SMALL_NICKEL_SPRING.get())))).shouldHide() || forceItems) {
                    output.m_246326_(VintageItems.SMALL_NICKEL_SPRING);
                }
                if (!((TagDependentSpringItem)((Object)((Object)((Object)VintageItems.SMALL_OSMIUM_SPRING.get())))).shouldHide() || forceItems) {
                    output.m_246326_(VintageItems.SMALL_OSMIUM_SPRING);
                }
                if (adAstraLoaded || forceItems) {
                    output.m_246326_((ItemLike)VintageItems.SMALL_OSTRUM_SPRING.get());
                }
                if (!((TagDependentSpringItem)((Object)((Object)((Object)VintageItems.SMALL_PALLADIUM_SPRING.get())))).shouldHide() || forceItems) {
                    output.m_246326_((ItemLike)VintageItems.SMALL_PALLADIUM_SPRING.get());
                }
                if (!((TagDependentSpringItem)((Object)((Object)((Object)VintageItems.SMALL_PIG_IRON_SPRING.get())))).shouldHide() || forceItems) {
                    output.m_246326_((ItemLike)VintageItems.SMALL_PIG_IRON_SPRING.get());
                }
                if (!((TagDependentSpringItem)((Object)((Object)((Object)VintageItems.SMALL_PLATINUM_SPRING.get())))).shouldHide() || forceItems) {
                    output.m_246326_((ItemLike)VintageItems.SMALL_PLATINUM_SPRING.get());
                }
                if (!((TagDependentSpringItem)((Object)((Object)((Object)VintageItems.SMALL_PURE_GOLD_SPRING.get())))).shouldHide() || forceItems) {
                    output.m_246326_((ItemLike)VintageItems.SMALL_PURE_GOLD_SPRING.get());
                }
                if (tConstructLoaded || forceItems) {
                    output.m_246326_((ItemLike)VintageItems.SMALL_QUEENS_SLIME_SPRING.get());
                }
                if (!((TagDependentSpringItem)((Object)((Object)((Object)VintageItems.SMALL_REFINED_GLOWSTONE_SPRING.get())))).shouldHide() || forceItems) {
                    output.m_246326_((ItemLike)VintageItems.SMALL_REFINED_GLOWSTONE_SPRING.get());
                }
                if (!((TagDependentSpringItem)((Object)((Object)((Object)VintageItems.SMALL_REFINED_OBSIDIAN_SPRING.get())))).shouldHide() || forceItems) {
                    output.m_246326_((ItemLike)VintageItems.SMALL_REFINED_OBSIDIAN_SPRING.get());
                }
                if (((Boolean)VintageConfig.client().legacyMaterialsIntoCreativeTab.get()).booleanValue()) {
                    output.m_246326_((ItemLike)VintageItems.SMALL_REFINED_RADIANCE_SPRING.get());
                }
                if (!((TagDependentSpringItem)((Object)((Object)((Object)VintageItems.SMALL_RHODIUM_SPRING.get())))).shouldHide() || forceItems) {
                    output.m_246326_((ItemLike)VintageItems.SMALL_RHODIUM_SPRING.get());
                }
                if (!((TagDependentSpringItem)((Object)((Object)((Object)VintageItems.SMALL_ROSE_GOLD_SPRING.get())))).shouldHide() || forceItems) {
                    output.m_246326_((ItemLike)VintageItems.SMALL_ROSE_GOLD_SPRING.get());
                }
                if (((Boolean)VintageConfig.client().legacyMaterialsIntoCreativeTab.get()).booleanValue()) {
                    output.m_246326_((ItemLike)VintageItems.SMALL_SHADOW_STEEL_SPRING.get());
                }
                if (!((TagDependentSpringItem)((Object)((Object)((Object)VintageItems.SMALL_SIGNALUM_SPRING.get())))).shouldHide() || forceItems) {
                    output.m_246326_((ItemLike)VintageItems.SMALL_SIGNALUM_SPRING.get());
                }
                if (!((TagDependentSpringItem)((Object)((Object)((Object)VintageItems.SMALL_SILVER_SPRING.get())))).shouldHide() || forceItems) {
                    output.m_246326_((ItemLike)VintageItems.SMALL_SILVER_SPRING.get());
                }
                if (tConstructLoaded || forceItems) {
                    output.m_246326_((ItemLike)VintageItems.SMALL_SLIMESTEEL_SPRING.get());
                }
                if (!((TagDependentSpringItem)((Object)((Object)((Object)VintageItems.SMALL_STEEL_SPRING.get())))).shouldHide() || forceItems) {
                    output.m_246326_((ItemLike)VintageItems.SMALL_STEEL_SPRING.get());
                }
                if (!((TagDependentSpringItem)((Object)((Object)((Object)VintageItems.SMALL_TIN_SPRING.get())))).shouldHide() || forceItems) {
                    output.m_246326_((ItemLike)VintageItems.SMALL_TIN_SPRING.get());
                }
                if (!((TagDependentSpringItem)((Object)((Object)((Object)VintageItems.SMALL_URANIUM_SPRING.get())))).shouldHide() || forceItems) {
                    output.m_246326_((ItemLike)VintageItems.SMALL_URANIUM_SPRING.get());
                }
                output.m_246326_((ItemLike)VintageItems.SMALL_VANADIUM_SPRING.get());
                output.m_246326_((ItemLike)VintageItems.SMALL_ZINC_SPRING.get());
            }
        }).m_257652_());
    }

    @Mod.EventBusSubscriber(modid="vintage", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public static class ClientModEvents {
        @SubscribeEvent
        public static void onClientSetup(FMLClientSetupEvent event) {
            PonderIndex.addPlugin((PonderPlugin)new VintagePonderPlugin());
        }
    }
}

