/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.inventoryessentials.client;

import com.mojang.blaze3d.platform.InputConstants;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import net.blay09.mods.inventoryessentials.InventoryEssentialsConfig;
import net.blay09.mods.inventoryessentials.InventoryEssentialsIgnores;
import net.blay09.mods.inventoryessentials.client.InventoryEssentialsClient;
import net.blay09.mods.inventoryessentials.mixin.AbstractContainerScreenAccessor;
import net.blay09.mods.kuma.api.InputBinding;
import net.blay09.mods.kuma.api.KeyConflictContext;
import net.blay09.mods.kuma.api.KeyModifier;
import net.blay09.mods.kuma.api.KeyModifiers;
import net.blay09.mods.kuma.api.Kuma;
import net.blay09.mods.kuma.api.ManagedKeyMapping;
import net.blay09.mods.kuma.api.ScreenInputEvent;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.Slot;

public class ModKeyMappings {
    public static ManagedKeyMapping keySingleTransfer;
    public static ManagedKeyMapping keyBulkTransfer;
    public static ManagedKeyMapping keyBulkTransferSingle;
    public static ManagedKeyMapping keyBulkTransferAll;
    public static ManagedKeyMapping keyBulkDrop;
    public static ManagedKeyMapping keyScreenBulkDrop;
    public static ManagedKeyMapping keyDragTransfer;
    public static ManagedKeyMapping keySortInventory;

    public static void initialize() {
        keySingleTransfer = Kuma.createKeyMapping((ResourceLocation)new ResourceLocation("inventoryessentials", "single_transfer")).withDefault(InputBinding.mouse((int)0, (KeyModifiers)KeyModifiers.of((KeyModifier[])new KeyModifier[]{KeyModifier.CONTROL}))).handleScreenInput(event -> ModKeyMappings.handleSlotInput(event, () -> InventoryEssentialsConfig.getActive().enableSingleTransfer, (screen, slot) -> InventoryEssentialsClient.getInventoryControls((Screen)screen).singleTransfer((AbstractContainerScreen<?>)screen, (Slot)slot))).build();
        keyBulkTransfer = Kuma.createKeyMapping((ResourceLocation)new ResourceLocation("inventoryessentials", "bulk_transfer")).withDefault(InputBinding.mouse((int)0, (KeyModifiers)KeyModifiers.of((KeyModifier[])new KeyModifier[]{KeyModifier.SHIFT, KeyModifier.CONTROL}))).handleScreenInput(event -> ModKeyMappings.handleSlotInput(event, () -> InventoryEssentialsConfig.getActive().enableBulkTransfer, (screen, slot) -> InventoryEssentialsClient.getInventoryControls((Screen)screen).bulkTransferByType((AbstractContainerScreen<?>)screen, (Slot)slot))).build();
        keyBulkTransferSingle = Kuma.createKeyMapping((ResourceLocation)new ResourceLocation("inventoryessentials", "bulk_transfer_single")).withDefault(InputBinding.mouse((int)1, (KeyModifiers)KeyModifiers.ofCustom((InputConstants.Key[])new InputConstants.Key[]{InputConstants.m_84827_((int)32, (int)-1)}))).handleScreenInput(event -> ModKeyMappings.handleSlotInput(event, () -> InventoryEssentialsConfig.getActive().enableBulkTransferSingle, (screen, slot) -> InventoryEssentialsClient.getInventoryControls((Screen)screen).bulkTransferSingle((AbstractContainerScreen<?>)screen, (Slot)slot))).build();
        keyBulkTransferAll = Kuma.createKeyMapping((ResourceLocation)new ResourceLocation("inventoryessentials", "bulk_transfer_all")).withDefault(InputBinding.mouse((int)0, (KeyModifiers)KeyModifiers.ofCustom((InputConstants.Key[])new InputConstants.Key[]{InputConstants.m_84827_((int)32, (int)-1)}))).handleScreenInput(event -> ModKeyMappings.handleSlotInput(event, () -> InventoryEssentialsConfig.getActive().enableBulkTransferAll, (screen, slot) -> InventoryEssentialsClient.getInventoryControls((Screen)screen).bulkTransferAll((AbstractContainerScreen<?>)screen, (Slot)slot))).build();
        keyBulkDrop = Kuma.createKeyMapping((ResourceLocation)new ResourceLocation("inventoryessentials", "bulk_drop")).withDefault(InputBinding.key((int)81, (KeyModifiers)KeyModifiers.of((KeyModifier[])new KeyModifier[]{KeyModifier.SHIFT, KeyModifier.CONTROL}))).handleScreenInput(event -> ModKeyMappings.handleSlotInput(event, () -> InventoryEssentialsConfig.getActive().enableBulkDrop, (screen, slot) -> InventoryEssentialsClient.getInventoryControls((Screen)screen).dropByType((AbstractContainerScreen<?>)screen, (Slot)slot))).build();
        keyScreenBulkDrop = Kuma.createKeyMapping((ResourceLocation)new ResourceLocation("inventoryessentials", "screen_bulk_drop")).withDefault(InputBinding.mouse((int)0, (KeyModifiers)KeyModifiers.of((KeyModifier[])new KeyModifier[]{KeyModifier.SHIFT}))).handleScreenInput(event -> {
            if (!InventoryEssentialsConfig.getActive().enableBulkDrop) {
                return false;
            }
            if (InventoryEssentialsIgnores.shouldIgnoreScreen(event.screen())) {
                return false;
            }
            Screen patt4530$temp = event.screen();
            if (!(patt4530$temp instanceof AbstractContainerScreen)) {
                return false;
            }
            AbstractContainerScreen containerScreen = (AbstractContainerScreen)patt4530$temp;
            AbstractContainerScreenAccessor accessor = (AbstractContainerScreenAccessor)containerScreen;
            int button = keyScreenBulkDrop.getBinding().key().m_84873_();
            boolean clickedOutside = accessor.callHasClickedOutside(event.mouseX(), event.mouseY(), accessor.getLeftPos(), accessor.getTopPos(), button);
            return clickedOutside && InventoryEssentialsClient.getInventoryControls((Screen)containerScreen).dropByType(containerScreen, containerScreen.m_6262_().m_142621_());
        }).build();
        keyDragTransfer = Kuma.createKeyMapping((ResourceLocation)new ResourceLocation("inventoryessentials", "drag_transfer")).withDefault(InputBinding.key((int)340)).withContext(KeyConflictContext.SCREEN).forceVirtual().build();
        keySortInventory = Kuma.createKeyMapping((ResourceLocation)new ResourceLocation("inventoryessentials", "sort_inventory")).withDefault(InputBinding.mouse((int)2)).handleScreenInput(event -> ModKeyMappings.handleSlotInput(event, () -> InventoryEssentialsConfig.getActive().enableMiddleClickSort, (screen, slot) -> InventoryEssentialsClient.getInventoryControls((Screen)screen).sort((AbstractContainerScreen<?>)screen, (Slot)slot))).build();
    }

    private static boolean handleSlotInput(ScreenInputEvent event, Supplier<Boolean> predicate, BiFunction<AbstractContainerScreen<?>, Slot, Boolean> handler) {
        if (!predicate.get().booleanValue()) {
            return false;
        }
        if (InventoryEssentialsIgnores.shouldIgnoreScreen(event.screen())) {
            return false;
        }
        Screen screen = event.screen();
        if (!(screen instanceof AbstractContainerScreen)) {
            return false;
        }
        AbstractContainerScreen containerScreen = (AbstractContainerScreen)screen;
        Slot hoverSlot = ((AbstractContainerScreenAccessor)containerScreen).getHoveredSlot();
        if (InventoryEssentialsIgnores.shouldIgnoreSlot(containerScreen, hoverSlot)) {
            return false;
        }
        return handler.apply(containerScreen, hoverSlot);
    }
}

