/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.inventoryessentials.client;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.blay09.mods.inventoryessentials.InventoryEssentialsConfig;
import net.blay09.mods.inventoryessentials.InventoryUtils;
import net.blay09.mods.inventoryessentials.client.ClientInventorySorting;
import net.blay09.mods.inventoryessentials.client.InventoryControls;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.multiplayer.MultiPlayerGameMode;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Equipable;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class ClientOnlyInventoryControls
implements InventoryControls {
    @Override
    public boolean singleTransfer(AbstractContainerScreen<?> screen, Slot clickedSlot) {
        AbstractContainerMenu menu = screen.m_6262_();
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return false;
        }
        if (!clickedSlot.m_8010_((Player)player)) {
            return false;
        }
        ItemStack targetStack = clickedSlot.m_7993_().m_41777_();
        if (targetStack.m_41613_() == 1) {
            this.slotClick(menu, clickedSlot, 0, ClickType.QUICK_MOVE);
            return true;
        }
        Slot fallbackSlot = null;
        for (Slot slot : menu.f_38839_) {
            ItemStack stack = slot.m_7993_();
            if (!this.isValidTargetSlot(slot) || slot == clickedSlot || !slot.m_5857_(targetStack) || InventoryUtils.isSameInventory(clickedSlot, slot) || stack.m_41613_() >= Math.min(slot.m_6641_(), slot.m_5866_(stack))) continue;
            if (ItemStack.m_150942_((ItemStack)targetStack, (ItemStack)stack)) {
                this.slotClick(menu, clickedSlot, 1, ClickType.PICKUP);
                this.slotClick(menu, slot, 1, ClickType.PICKUP);
                this.slotClick(menu, clickedSlot, 0, ClickType.PICKUP);
                return true;
            }
            if (slot.m_6657_() || fallbackSlot != null) continue;
            fallbackSlot = slot;
        }
        if (fallbackSlot != null) {
            this.slotClick(menu, clickedSlot, 1, ClickType.PICKUP);
            this.slotClick(menu, fallbackSlot, 1, ClickType.PICKUP);
            this.slotClick(menu, clickedSlot, 0, ClickType.PICKUP);
            return true;
        }
        return false;
    }

    @Override
    public boolean bulkTransferByType(AbstractContainerScreen<?> screen, Slot clickedSlot) {
        ItemStack clickedStackCopy = clickedSlot.m_7993_().m_41777_();
        clickedStackCopy.m_41721_(0);
        AbstractContainerMenu menu = screen.m_6262_();
        ArrayList<Slot> transferSlots = new ArrayList<Slot>();
        transferSlots.add(clickedSlot);
        for (Slot slot : menu.f_38839_) {
            if (slot == clickedSlot || !this.isValidTargetSlot(slot) || !InventoryUtils.isSameInventory(slot, clickedSlot)) continue;
            ItemStack slotStackCopy = slot.m_7993_().m_41777_();
            slotStackCopy.m_41721_(0);
            if (!ItemStack.m_150942_((ItemStack)clickedStackCopy, (ItemStack)slotStackCopy)) continue;
            transferSlots.add(slot);
        }
        for (Slot transferSlot : transferSlots) {
            this.slotClick(menu, transferSlot, 0, ClickType.QUICK_MOVE);
        }
        return true;
    }

    @Override
    public boolean bulkTransferSingle(AbstractContainerScreen<?> screen, Slot clickedSlot) {
        Equipable equipable;
        Item item;
        if (!clickedSlot.m_6657_() && !InventoryEssentialsConfig.getActive().allowBulkTransferAllOnEmptySlot) {
            return false;
        }
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return false;
        }
        AbstractContainerMenu menu = screen.m_6262_();
        boolean isProbablyMovingToPlayerInventory = false;
        if (!(clickedSlot.f_40218_ instanceof Inventory)) {
            isProbablyMovingToPlayerInventory = InventoryUtils.containerContainsPlayerInventory(menu);
        }
        boolean clickedAnArmorItem = (item = clickedSlot.m_7993_().m_41720_()) instanceof Equipable && (equipable = (Equipable)item).m_40402_().m_254934_();
        boolean isInsideInventory = menu instanceof InventoryMenu;
        boolean movedAny = false;
        if (isProbablyMovingToPlayerInventory) {
            ArrayDeque<Slot> emptySlots = new ArrayDeque<Slot>();
            ArrayList<Slot> nonEmptySlots = new ArrayList<Slot>();
            for (Slot slot : menu.f_38839_) {
                if (InventoryUtils.isSameInventory(slot, clickedSlot) || !(slot.f_40218_ instanceof Inventory) || !this.isValidTargetSlot(slot)) continue;
                if (slot.m_6657_()) {
                    nonEmptySlots.add(slot);
                    continue;
                }
                if (Inventory.m_36045_((int)slot.m_150661_())) continue;
                emptySlots.add(slot);
            }
            for (Slot slot : menu.f_38839_) {
                if (!slot.m_8010_((Player)player) || !InventoryUtils.isSameInventory(slot, clickedSlot, true) || !this.quickTransferSingle(menu, emptySlots, nonEmptySlots, slot)) continue;
                movedAny = true;
            }
        } else if (clickedAnArmorItem && isInsideInventory) {
            if (!InventoryEssentialsConfig.getActive().bulkTransferArmorSets) {
                return false;
            }
            if (!menu.m_142621_().m_41619_()) {
                return false;
            }
            if (clickedSlot.f_40219_ >= 5 && clickedSlot.f_40219_ < 9) {
                for (int i = 5; i < 9; ++i) {
                    this.slotClick(menu, i, 0, ClickType.QUICK_MOVE);
                }
                return true;
            }
            Map<EquipmentSlot, Slot> armorSlots = InventoryUtils.findMatchingArmorSetSlots(menu, clickedSlot);
            List<EquipmentSlot> equipmentSlots = List.of(EquipmentSlot.HEAD, EquipmentSlot.CHEST, EquipmentSlot.LEGS, EquipmentSlot.FEET);
            for (int i = 5; i < 9; ++i) {
                EquipmentSlot equipmentSlot = equipmentSlots.get(i - 5);
                Slot swapSlot = armorSlots.get(equipmentSlot);
                if (swapSlot == null) continue;
                this.slotClick(menu, i, 0, ClickType.PICKUP);
                this.slotClick(menu, swapSlot, 0, ClickType.PICKUP);
                this.slotClick(menu, i, 0, ClickType.PICKUP);
            }
            movedAny = true;
        } else {
            for (Slot slot : menu.f_38839_) {
                if (!slot.m_8010_((Player)player) || !this.isValidTargetSlot(slot) || !InventoryUtils.isSameInventory(slot, clickedSlot, true)) continue;
                this.singleTransfer(screen, slot);
                movedAny = true;
            }
        }
        return movedAny;
    }

    @Override
    public boolean bulkTransferAll(AbstractContainerScreen<?> screen, Slot clickedSlot) {
        Equipable equipable;
        Item item;
        if (!clickedSlot.m_6657_() && !InventoryEssentialsConfig.getActive().allowBulkTransferAllOnEmptySlot) {
            return false;
        }
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return false;
        }
        AbstractContainerMenu menu = screen.m_6262_();
        boolean isProbablyMovingToPlayerInventory = false;
        if (!(clickedSlot.f_40218_ instanceof Inventory)) {
            isProbablyMovingToPlayerInventory = InventoryUtils.containerContainsPlayerInventory(menu);
        }
        boolean clickedAnArmorItem = (item = clickedSlot.m_7993_().m_41720_()) instanceof Equipable && (equipable = (Equipable)item).m_40402_().m_254934_();
        boolean isInsideInventory = menu instanceof InventoryMenu;
        boolean movedAny = false;
        if (isProbablyMovingToPlayerInventory) {
            ArrayDeque<Slot> emptySlots = new ArrayDeque<Slot>();
            ArrayList<Slot> nonEmptySlots = new ArrayList<Slot>();
            for (Slot slot : menu.f_38839_) {
                if (InventoryUtils.isSameInventory(slot, clickedSlot) || !(slot.f_40218_ instanceof Inventory) || !this.isValidTargetSlot(slot)) continue;
                if (slot.m_6657_()) {
                    nonEmptySlots.add(slot);
                    continue;
                }
                if (Inventory.m_36045_((int)slot.m_150661_())) continue;
                emptySlots.add(slot);
            }
            for (Slot slot : menu.f_38839_) {
                if (!slot.m_8010_((Player)player) || !InventoryUtils.isSameInventory(slot, clickedSlot, true) || !this.quickTransferStack(menu, emptySlots, nonEmptySlots, slot)) continue;
                movedAny = true;
            }
        } else if (clickedAnArmorItem && isInsideInventory) {
            if (!InventoryEssentialsConfig.getActive().bulkTransferArmorSets) {
                return false;
            }
            if (!menu.m_142621_().m_41619_()) {
                return false;
            }
            if (clickedSlot.f_40219_ >= 5 && clickedSlot.f_40219_ < 9) {
                for (int i = 5; i < 9; ++i) {
                    this.slotClick(menu, i, 0, ClickType.QUICK_MOVE);
                }
                return true;
            }
            Map<EquipmentSlot, Slot> armorSlots = InventoryUtils.findMatchingArmorSetSlots(menu, clickedSlot);
            List<EquipmentSlot> equipmentSlots = List.of(EquipmentSlot.HEAD, EquipmentSlot.CHEST, EquipmentSlot.LEGS, EquipmentSlot.FEET);
            for (int i = 5; i < 9; ++i) {
                EquipmentSlot equipmentSlot = equipmentSlots.get(i - 5);
                Slot swapSlot = armorSlots.get(equipmentSlot);
                if (swapSlot == null) continue;
                this.slotClick(menu, i, 0, ClickType.PICKUP);
                this.slotClick(menu, swapSlot, 0, ClickType.PICKUP);
                this.slotClick(menu, i, 0, ClickType.PICKUP);
            }
            movedAny = true;
        } else {
            for (Slot slot : menu.f_38839_) {
                if (!slot.m_8010_((Player)player) || !this.isValidTargetSlot(slot) || !InventoryUtils.isSameInventory(slot, clickedSlot, true)) continue;
                this.slotClick(menu, slot, 0, ClickType.QUICK_MOVE);
                movedAny = true;
            }
        }
        return movedAny;
    }

    private boolean quickTransferStack(AbstractContainerMenu menu, Deque<Slot> emptySlots, List<Slot> nonEmptySlots, Slot slot) {
        ItemStack targetStack = slot.m_7993_().m_41777_();
        if (targetStack.m_41619_()) {
            return false;
        }
        this.slotClick(menu, slot, 0, ClickType.PICKUP);
        for (Slot nonEmptySlot : nonEmptySlots) {
            boolean hasSpaceLeft;
            ItemStack stack = nonEmptySlot.m_7993_();
            if (!ItemStack.m_150942_((ItemStack)targetStack, (ItemStack)stack)) continue;
            boolean bl = hasSpaceLeft = stack.m_41613_() < Math.min(nonEmptySlot.m_6641_(), nonEmptySlot.m_5866_(stack));
            if (!hasSpaceLeft) continue;
            this.slotClick(menu, nonEmptySlot, 0, ClickType.PICKUP);
            ItemStack mouseItem = menu.m_142621_();
            if (!mouseItem.m_41619_()) continue;
            return true;
        }
        Iterator<Slot> iterator = emptySlots.iterator();
        while (iterator.hasNext()) {
            ItemStack mouseItem;
            Slot emptySlot = iterator.next();
            this.slotClick(menu, emptySlot, 0, ClickType.PICKUP);
            if (emptySlot.m_6657_()) {
                nonEmptySlots.add(emptySlot);
                iterator.remove();
            }
            if (!(mouseItem = menu.m_142621_()).m_41619_()) continue;
            return true;
        }
        ItemStack mouseItem = menu.m_142621_();
        if (!mouseItem.m_41619_()) {
            this.slotClick(menu, slot, 0, ClickType.PICKUP);
        }
        return false;
    }

    private boolean quickTransferSingle(AbstractContainerMenu menu, Deque<Slot> emptySlots, List<Slot> nonEmptySlots, Slot slot) {
        ItemStack targetStack = slot.m_7993_().m_41777_();
        if (targetStack.m_41619_()) {
            return false;
        }
        this.slotClick(menu, slot, 0, ClickType.PICKUP);
        for (Slot nonEmptySlot : nonEmptySlots) {
            boolean hasSpaceLeft;
            ItemStack stack = nonEmptySlot.m_7993_();
            if (!ItemStack.m_150942_((ItemStack)targetStack, (ItemStack)stack)) continue;
            boolean bl = hasSpaceLeft = stack.m_41613_() < Math.min(nonEmptySlot.m_6641_(), nonEmptySlot.m_5866_(stack));
            if (!hasSpaceLeft) continue;
            this.slotClick(menu, nonEmptySlot, 1, ClickType.PICKUP);
            ItemStack mouseItem = menu.m_142621_();
            if (mouseItem.m_41613_() >= targetStack.m_41613_()) continue;
            this.slotClick(menu, slot, 0, ClickType.PICKUP);
            return true;
        }
        Iterator<Slot> iterator = emptySlots.iterator();
        while (iterator.hasNext()) {
            ItemStack mouseItem;
            Slot emptySlot = iterator.next();
            this.slotClick(menu, emptySlot, 1, ClickType.PICKUP);
            if (emptySlot.m_6657_()) {
                nonEmptySlots.add(emptySlot);
                iterator.remove();
            }
            if ((mouseItem = menu.m_142621_()).m_41613_() >= targetStack.m_41613_()) continue;
            this.slotClick(menu, slot, 0, ClickType.PICKUP);
            return true;
        }
        ItemStack mouseItem = menu.m_142621_();
        if (!mouseItem.m_41619_()) {
            this.slotClick(menu, slot, 0, ClickType.PICKUP);
        }
        return false;
    }

    @Override
    public void dragTransfer(AbstractContainerScreen<?> screen, Slot clickedSlot) {
        this.slotClick(screen.m_6262_(), clickedSlot, 0, ClickType.QUICK_MOVE);
    }

    @Override
    public boolean sort(AbstractContainerScreen<?> screen, Slot baseSlot) {
        AbstractContainerMenu menu = screen.m_6262_();
        return ClientInventorySorting.sort(menu, baseSlot, this::slotClick);
    }

    protected void slotClick(AbstractContainerMenu menu, Slot slot, int mouseButton, ClickType clickType) {
        this.slotClick(menu, slot.f_40219_, mouseButton, clickType);
    }

    protected void slotClick(AbstractContainerMenu menu, int slotIndex, int mouseButton, ClickType clickType) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        MultiPlayerGameMode gameMode = Minecraft.m_91087_().f_91072_;
        if (player != null && gameMode != null && (slotIndex >= 0 && slotIndex < menu.f_38839_.size() || slotIndex == -999)) {
            gameMode.m_171799_(menu.f_38840_, slotIndex, mouseButton, clickType, (Player)player);
        }
    }

    @Override
    public boolean dropByType(AbstractContainerScreen<?> screen, Slot hoverSlot) {
        ItemStack targetStack = hoverSlot.m_7993_().m_41777_();
        AbstractContainerMenu menu = screen.m_6262_();
        ArrayList<Slot> transferSlots = new ArrayList<Slot>();
        transferSlots.add(hoverSlot);
        for (Slot slot : menu.f_38839_) {
            ItemStack stack;
            if (slot == hoverSlot || !this.isValidTargetSlot(slot) || !InventoryUtils.isSameInventory(slot, hoverSlot) || !ItemStack.m_150942_((ItemStack)targetStack, (ItemStack)(stack = slot.m_7993_()))) continue;
            transferSlots.add(slot);
        }
        for (Slot transferSlot : transferSlots) {
            this.slotClick(menu, transferSlot, 1, ClickType.THROW);
        }
        return true;
    }

    @Override
    public boolean dropByType(AbstractContainerScreen<?> screen, ItemStack targetStack) {
        if (targetStack.m_41619_()) {
            return false;
        }
        AbstractContainerMenu menu = screen.m_6262_();
        ArrayList<Slot> transferSlots = new ArrayList<Slot>();
        for (Slot slot : menu.f_38839_) {
            ItemStack stack = slot.m_7993_();
            if (!ItemStack.m_150942_((ItemStack)targetStack, (ItemStack)stack) || !this.isValidTargetSlot(slot)) continue;
            transferSlots.add(slot);
        }
        this.slotClick(menu, -999, 0, ClickType.PICKUP);
        for (Slot transferSlot : transferSlots) {
            this.slotClick(menu, transferSlot, 1, ClickType.THROW);
        }
        return true;
    }

    protected boolean isValidTargetSlot(Slot slot) {
        return true;
    }
}

