/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.common.entity;

import cofh.core.client.particle.options.ColorParticleOptions;
import cofh.core.common.effect.ChilledMobEffect;
import cofh.core.init.CoreEntities;
import cofh.core.init.CoreParticles;
import cofh.core.util.AreaUtils;
import cofh.core.util.helpers.vfx.Color;
import cofh.lib.common.entity.AbstractFieldSpell;
import cofh.lib.util.helpers.MathHelper;
import java.util.function.Predicate;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class FrostField
extends AbstractFieldSpell {
    public FrostField(EntityType<? extends FrostField> type, Level level) {
        super((EntityType<? extends AbstractFieldSpell>)type, level);
    }

    public FrostField(Level level, Vec3 pos, LivingEntity owner, float power, int duration, float radius) {
        super((EntityType<? extends AbstractFieldSpell>)((EntityType)CoreEntities.FROST_FIELD.get()), level, pos, (Entity)owner, power, duration, radius);
    }

    @Override
    public void activeTick() {
        block4: {
            float r;
            Vec3 center;
            block3: {
                center = this.m_20182_();
                r = Math.min((float)this.f_19797_ * 12.0f / (float)this.duration, 1.0f);
                float n = MathHelper.ceil(r * 4.0f);
                r *= this.getRadius();
                if (!this.f_19853_.m_5776_()) break block3;
                int i = 0;
                while ((float)i < n) {
                    this.addParticle(new ColorParticleOptions((ParticleType<? extends ColorParticleOptions>)((ParticleType)CoreParticles.MIST.get()), this.rand.nextFloat(1.0f, 3.0f), this.rand.nextFloat(50.0f, 70.0f), 0.0f, Color.fromRGBA(this.rand.nextInt(153, 180), this.rand.nextInt(192, 216), 255, 48).toRGBA()), center, r);
                    this.addParticle((ParticleOptions)CoreParticles.FROST.get(), center, r);
                    ++i;
                }
                break block4;
            }
            if (this.f_19797_ % 6 != 0) break block4;
            Predicate<Entity> filter = EntitySelector.f_20403_;
            if (this.owner != null) {
                filter = filter.and(entity -> !entity.m_20365_(this.owner));
            }
            for (Entity target : AreaUtils.getEntitiesInCylinder(this.f_19853_, center, r, this.m_20206_(), this, filter)) {
                ChilledMobEffect.applyChilled(target, this.power, this.rand);
            }
        }
    }

    protected void addParticle(ParticleOptions options, Vec3 center, float radius) {
        float var = 0.01f;
        Vec3 pos = this.randomOffsetRadial(center, radius, 0.5f);
        this.f_19853_.m_7106_(options, pos.f_82479_, pos.f_82480_, pos.f_82481_, (double)this.rand.nextFloat(-var, var), (double)this.rand.nextFloat(-var, var), (double)this.rand.nextFloat(-var, var));
    }

    protected Vec3 randomOffsetRadial(Vec3 center, float radius, float height) {
        double r = (double)radius * Math.sqrt(this.rand.nextFloat());
        float angle = this.rand.nextFloat((float)Math.PI * 2);
        return center.m_82520_(r * (double)MathHelper.cos(angle), (double)this.rand.nextFloat(height), r * (double)MathHelper.sin(angle));
    }
}

