/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.client.particle.impl;

import cofh.core.client.particle.PointToPointParticle;
import cofh.core.client.particle.options.BiColorParticleOptions;
import cofh.core.util.helpers.vfx.VFXHelper;
import cofh.lib.util.helpers.MathHelper;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import javax.annotation.Nonnull;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.renderer.MultiBufferSource;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class BeamParticle
extends PointToPointParticle {
    protected Vector3f disp;

    private BeamParticle(BiColorParticleOptions data, ClientLevel level, double sx, double sy, double sz, double ex, double ey, double ez) {
        super(data, level, sx, sy, sz, ex, ey, ez);
        this.disp = new Vector3f((float)(ex - sx), (float)(ey - sy), (float)(ez - sz));
    }

    public void m_5989_() {
        if (this.f_107224_++ >= this.f_107225_) {
            this.m_107274_();
        }
    }

    @Override
    public void render(PoseStack stack, MultiBufferSource buffer, VertexConsumer consumer, int packedLight, float time, float pTicks) {
        float progress = time / this.duration;
        float rad = progress * (float)Math.PI;
        float easeCos = 0.5f * MathHelper.cos(rad * 0.5f) + 0.5f;
        float easeCub = 1.0f - MathHelper.easeInCubic(progress);
        Vector3f end = new Vector3f((Vector3fc)this.disp);
        end.mul(Math.min(time * 12.0f / VFXHelper.length(end), 1.0f));
        VFXHelper.alignVertical(stack, MathHelper.ZERO, end);
        VFXHelper.renderBeam(stack, buffer, packedLight, this.size * easeCos, this.c0.scaleAlpha(easeCub), this.c1.scaleAlpha(easeCub));
    }

    @Override
    public int m_6355_(float pTicks) {
        return 0xF000F0;
    }

    @Override
    public int getLightColor(float pTicks, double x, double y, double z) {
        return 0xF000F0;
    }

    @Nonnull
    public static ParticleProvider<BiColorParticleOptions> factory(SpriteSet spriteSet) {
        return BeamParticle::new;
    }
}

