/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.client.gui.element;

import cofh.core.client.gui.GuiColor;
import cofh.core.client.gui.IGuiAccess;
import cofh.core.client.gui.element.ElementBase;
import cofh.core.client.gui.element.listbox.IListBoxElement;
import cofh.core.util.helpers.RenderHelper;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import org.lwjgl.opengl.GL11;

public class ElementListBox
extends ElementBase {
    public int borderColor = new GuiColor(120, 120, 120, 255).getColor();
    public int backgroundColor = new GuiColor(0, 0, 0, 255).getColor();
    public int selectedLineColor = new GuiColor(0, 0, 0, 255).getColor();
    public int textColor = new GuiColor(150, 150, 150, 255).getColor();
    public int selectedTextColor = new GuiColor(255, 255, 255, 255).getColor();
    protected int marginTop = 2;
    protected int marginLeft = 2;
    protected int marginRight = 2;
    protected int marginBottom = 2;
    protected final List<IListBoxElement> elements = new LinkedList<IListBoxElement>();
    protected int firstIndexDisplayed;
    protected int selectedIndex;
    protected int scrollHoriz;

    public ElementListBox(IGuiAccess containerScreen, int x, int y, int width, int height) {
        super(containerScreen, x, y, width, height);
    }

    public void add(IListBoxElement element) {
        this.elements.add(element);
    }

    public void add(Collection<? extends IListBoxElement> elements) {
        this.elements.addAll(elements);
    }

    public void remove(IListBoxElement element) {
        int e = this.elements.indexOf(element);
        if (this.elements.remove(element)) {
            if (e < this.firstIndexDisplayed) {
                --this.firstIndexDisplayed;
            }
            if (e < this.selectedIndex) {
                --this.selectedIndex;
            }
        }
    }

    public void removeAt(int index) {
        this.scrollHoriz = 0;
        this.firstIndexDisplayed = 0;
        this.selectedIndex = -1;
        this.elements.remove(index);
    }

    public void removeAll() {
        this.elements.clear();
    }

    public int getInternalWidth() {
        int width = 0;
        for (int i = 0; i < this.elements.size(); ++i) {
            width = Math.max(this.elements.get(i).getWidth(), width);
        }
        return width;
    }

    public int getInternalHeight() {
        int height = 0;
        for (int i = 0; i < this.elements.size(); ++i) {
            height += this.elements.get(i).getHeight();
        }
        return height;
    }

    public int getContentWidth() {
        return this.width - this.marginLeft - this.marginRight;
    }

    public int getContentHeight() {
        return this.height - this.marginTop - this.marginBottom;
    }

    public int getContentTop() {
        return this.posY() + this.marginTop;
    }

    public int getContentLeft() {
        return this.posX() + this.marginLeft;
    }

    public final int getContentBottom() {
        return this.getContentTop() + this.getContentHeight();
    }

    public final int getContentRight() {
        return this.getContentLeft() + this.getContentWidth();
    }

    public ElementListBox setTextColor(Number textColor, Number selectedTextColor) {
        if (textColor != null) {
            this.textColor = textColor.intValue();
        }
        if (selectedTextColor != null) {
            this.selectedTextColor = selectedTextColor.intValue();
        }
        return this;
    }

    public ElementListBox setSelectionColor(Number selectedLineColor) {
        if (selectedLineColor != null) {
            this.selectedLineColor = selectedLineColor.intValue();
        }
        return this;
    }

    public ElementListBox setBackgroundColor(Number backgroundColor, Number borderColor) {
        if (backgroundColor != null) {
            this.backgroundColor = backgroundColor.intValue();
        }
        if (borderColor != null) {
            this.borderColor = borderColor.intValue();
        }
        return this;
    }

    @Override
    public void drawBackground(GuiGraphics pGuiGraphics, int mouseX, int mouseY) {
        this.drawColoredModalRect(pGuiGraphics.m_280168_(), this.posX() - 1, this.posY() - 1, this.posX() + this.width + 1, this.posY() + this.height + 1, this.borderColor);
        this.drawColoredModalRect(pGuiGraphics.m_280168_(), this.posX(), this.posY(), this.posX() + this.width, this.posY() + this.height, this.backgroundColor);
    }

    @Override
    public void drawForeground(GuiGraphics pGuiGraphics, int mouseX, int mouseY) {
        PoseStack poseStack = pGuiGraphics.m_280168_();
        int heightDrawn = 0;
        GL11.glEnable((int)2960);
        RenderHelper.drawStencil(poseStack, this.getContentLeft(), this.getContentTop(), this.getContentRight(), this.getContentBottom(), 1);
        poseStack.m_85836_();
        poseStack.m_252880_((float)(-this.scrollHoriz), 0.0f, 0.0f);
        int e = this.elements.size();
        for (int nextElement = this.firstIndexDisplayed; nextElement < e && heightDrawn <= this.getContentHeight(); heightDrawn += this.drawElement(pGuiGraphics, nextElement, this.getContentLeft(), this.getContentTop() + heightDrawn), ++nextElement) {
        }
        poseStack.m_85849_();
        GL11.glDisable((int)2960);
    }

    protected int drawElement(GuiGraphics pGuiGraphics, int elementIndex, int x, int y) {
        IListBoxElement element = this.elements.get(elementIndex);
        if (elementIndex == this.selectedIndex) {
            element.draw(pGuiGraphics, this, x, y, this.selectedLineColor, this.selectedTextColor);
        } else {
            element.draw(pGuiGraphics, this, x, y, this.backgroundColor, this.textColor);
        }
        return element.getHeight();
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
        int elementHeight;
        int heightChecked = 0;
        for (int i = this.firstIndexDisplayed; i < this.elements.size() && heightChecked <= this.getContentHeight(); heightChecked += elementHeight, ++i) {
            elementHeight = this.elements.get(i).getHeight();
            if (!((double)(this.getContentTop() + heightChecked) <= mouseY) || !((double)(this.getContentTop() + heightChecked + elementHeight) >= mouseY)) continue;
            this.setSelectedIndex(i);
            this.onElementClicked(this.elements.get(i));
            break;
        }
        return true;
    }

    @Override
    public boolean mouseWheel(double mouseX, double mouseY, double movement) {
        if (Screen.m_96637_()) {
            if (movement > 0.0) {
                this.scrollLeft();
            } else if (movement < 0.0) {
                this.scrollRight();
            }
        } else if (movement > 0.0) {
            this.scrollUp();
        } else if (movement < 0.0) {
            this.scrollDown();
        }
        return true;
    }

    public void scrollDown() {
        int heightDisplayed = 0;
        int elementsDisplayed = 0;
        for (int i = this.firstIndexDisplayed; i < this.elements.size() && heightDisplayed + this.elements.get(i).getHeight() <= this.height; ++i) {
            heightDisplayed += this.elements.get(i).getHeight();
            ++elementsDisplayed;
        }
        if (this.firstIndexDisplayed + elementsDisplayed < this.elements.size()) {
            ++this.firstIndexDisplayed;
        }
        this.onScrollV(this.firstIndexDisplayed);
    }

    public void scrollUp() {
        if (this.firstIndexDisplayed > 0) {
            --this.firstIndexDisplayed;
        }
        this.onScrollV(this.firstIndexDisplayed);
    }

    public void scrollLeft() {
        this.scrollHoriz = Math.max(this.scrollHoriz - 15, 0);
        this.onScrollH(this.scrollHoriz);
    }

    public void scrollRight() {
        this.scrollHoriz = Math.min(this.scrollHoriz + 15, this.getLastScrollPositionH());
        this.onScrollH(this.scrollHoriz);
    }

    public int getLastScrollPosition() {
        int heightUsed;
        int position = this.elements.size() - 1;
        if (position < 0) {
            return 0;
        }
        for (heightUsed = 0; position >= 0 && heightUsed < this.height; heightUsed += this.elements.get(position--).getHeight()) {
        }
        if (heightUsed > this.height) {
            ++position;
        }
        return position + 1;
    }

    public int getLastScrollPositionH() {
        return Math.max(this.getInternalWidth() - this.getContentWidth(), 0);
    }

    public int getSelectedIndex() {
        return this.selectedIndex;
    }

    public int getIndexOf(Object value) {
        for (int i = 0; i < this.elements.size(); ++i) {
            if (!this.elements.get(i).getValue().equals(value)) continue;
            return i;
        }
        return -1;
    }

    public IListBoxElement getSelectedElement() {
        if (this.selectedIndex == -1 || this.selectedIndex >= this.elements.size()) {
            return null;
        }
        return this.elements.get(this.selectedIndex);
    }

    public void setSelectedIndex(int index) {
        if (index >= -1 && index != this.selectedIndex && index < this.elements.size()) {
            this.selectedIndex = index;
            this.onSelectionChanged(this.selectedIndex, this.getSelectedElement());
        }
    }

    public IListBoxElement getElement(int index) {
        return this.elements.get(index);
    }

    public int getElementCount() {
        return this.elements.size();
    }

    public void scrollToV(int index) {
        if (index >= 0 && index < this.elements.size()) {
            this.firstIndexDisplayed = index;
        }
    }

    public void scrollToH(int index) {
        if (index >= 0 && index <= this.getLastScrollPositionH()) {
            this.scrollHoriz = index;
        }
    }

    protected void onElementClicked(IListBoxElement element) {
    }

    protected void onScrollV(int newStartIndex) {
    }

    protected void onScrollH(int newStartIndex) {
    }

    protected void onSelectionChanged(int newIndex, IListBoxElement newElement) {
    }
}

