/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.utils;

import com.gregtechceu.gtceu.api.machine.trait.NotifiableFluidTank;
import com.gregtechceu.gtceu.api.transfer.fluid.FluidHandlerList;
import com.gregtechceu.gtceu.utils.GTHashMaps;
import com.gregtechceu.gtceu.utils.OverlayedItemHandler;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GTTransferUtils {
    public static LazyOptional<IFluidHandler> getAdjacentFluidHandler(Level level, BlockPos pos, Direction facing) {
        return FluidUtil.getFluidHandler((Level)level, (BlockPos)pos.m_121945_(facing), (Direction)facing.m_122424_());
    }

    public static boolean hasAdjacentFluidHandler(Level level, BlockPos pos, Direction facing) {
        return GTTransferUtils.getAdjacentFluidHandler(level, pos, facing).isPresent();
    }

    public static LazyOptional<IItemHandler> getItemHandler(Level level, BlockPos pos, @Nullable Direction side) {
        BlockEntity blockEntity;
        BlockState state = level.m_8055_(pos);
        if (state.m_155947_() && (blockEntity = level.m_7702_(pos)) != null) {
            return blockEntity.getCapability(ForgeCapabilities.ITEM_HANDLER, side);
        }
        return LazyOptional.empty();
    }

    public static LazyOptional<IItemHandler> getAdjacentItemHandler(Level level, BlockPos pos, Direction facing) {
        return GTTransferUtils.getItemHandler(level, pos.m_121945_(facing), facing.m_122424_());
    }

    public static boolean hasAdjacentItemHandler(Level level, BlockPos pos, Direction facing) {
        return GTTransferUtils.getAdjacentItemHandler(level, pos, facing).isPresent();
    }

    public static int transferFluidsFiltered(@NotNull IFluidHandler source, @NotNull IFluidHandler dest, @NotNull Predicate<FluidStack> filter, int transferLimit) {
        FluidStack transferred;
        FluidStack fluid;
        int toTransfer = transferLimit;
        for (int i = 0; i < source.getTanks() && ((fluid = source.getFluidInTank(i)).isEmpty() || !filter.test(fluid) || (toTransfer -= (transferred = FluidUtil.tryFluidTransfer((IFluidHandler)dest, (IFluidHandler)source, (FluidStack)(fluid = new FluidStack(fluid, toTransfer)), (boolean)true)).getAmount()) > 0); ++i) {
        }
        return transferLimit - toTransfer;
    }

    public static void transferFluidsFiltered(@NotNull IFluidHandler source, @NotNull IFluidHandler dest, @NotNull Predicate<FluidStack> filter) {
        GTTransferUtils.transferFluidsFiltered(source, dest, filter, Integer.MAX_VALUE);
    }

    public static int transferItemsFiltered(@NotNull IItemHandler source, @NotNull IItemHandler dest, @NotNull Predicate<ItemStack> filter, int transferLimit) {
        ItemStack extracted;
        ItemStack remainder;
        int canInsert;
        ItemStack canExtract;
        ItemStack stack;
        int toTransfer = transferLimit;
        for (int i = 0; i < source.getSlots() && ((stack = source.getStackInSlot(i)).m_41619_() || !filter.test(stack) || (canExtract = source.extractItem(i, toTransfer, true)).m_41619_() || (canInsert = canExtract.m_41613_() - ItemHandlerHelper.insertItemStacked((IItemHandler)dest, (ItemStack)canExtract, (boolean)true).m_41613_()) <= 0 || (toTransfer -= canInsert - (remainder = ItemHandlerHelper.insertItemStacked((IItemHandler)dest, (ItemStack)(extracted = source.extractItem(i, canInsert, false)), (boolean)false)).m_41613_()) > 0); ++i) {
        }
        return transferLimit - toTransfer;
    }

    public static void transferItemsFiltered(@NotNull IItemHandler source, @NotNull IItemHandler dest, @NotNull Predicate<ItemStack> filter) {
        GTTransferUtils.transferItemsFiltered(source, dest, filter, Integer.MAX_VALUE);
    }

    public static void moveInventoryItems(IItemHandlerModifiable sourceInventory, IItemHandlerModifiable targetInventory) {
        for (int srcIndex = 0; srcIndex < sourceInventory.getSlots(); ++srcIndex) {
            ItemStack sourceStack = sourceInventory.extractItem(srcIndex, Integer.MAX_VALUE, true);
            if (sourceStack.m_41619_()) continue;
            ItemStack remainder = GTTransferUtils.insertItem((IItemHandler)targetInventory, sourceStack, true);
            int amountToInsert = sourceStack.m_41613_() - remainder.m_41613_();
            if (amountToInsert <= 0) continue;
            sourceStack = sourceInventory.extractItem(srcIndex, amountToInsert, false);
            GTTransferUtils.insertItem((IItemHandler)targetInventory, sourceStack, false);
        }
    }

    public static boolean addItemsToItemHandler(IItemHandlerModifiable handler, boolean simulate, List<ItemStack> items) {
        if (simulate) {
            OverlayedItemHandler overlayedItemHandler = new OverlayedItemHandler(handler);
            Object2IntMap<ItemStack> stackKeyMap = GTHashMaps.fromItemStackCollection(items);
            for (Object2IntMap.Entry entry : stackKeyMap.object2IntEntrySet()) {
                int amountToInsert = entry.getIntValue();
                int amount = overlayedItemHandler.insertStackedItemStack((ItemStack)entry.getKey(), amountToInsert);
                if (amount <= 0) continue;
                return false;
            }
            return true;
        }
        items.forEach(stack -> ItemHandlerHelper.insertItemStacked((IItemHandler)handler, (ItemStack)stack, (boolean)false));
        return true;
    }

    public static int fillFluidAccountNotifiableList(IFluidHandler fluidHandler, FluidStack stack, IFluidHandler.FluidAction action) {
        if (stack.isEmpty()) {
            return 0;
        }
        if (fluidHandler instanceof FluidHandlerList) {
            FluidHandlerList handlerList = (FluidHandlerList)fluidHandler;
            FluidStack copied = stack.copy();
            for (IFluidHandler handler : handlerList.handlers) {
                FluidStack candidate = copied.copy();
                if (handler instanceof NotifiableFluidTank) {
                    NotifiableFluidTank notifiable = (NotifiableFluidTank)handler;
                    copied.shrink(notifiable.fillInternal(candidate, action));
                } else {
                    copied.shrink(handler.fill(candidate, action));
                }
                if (copied.isEmpty()) break;
            }
            return stack.getAmount() - copied.getAmount();
        }
        return fluidHandler.fill(stack, action);
    }

    public static FluidStack drainFluidAccountNotifiableList(IFluidHandler fluidHandler, FluidStack stack, IFluidHandler.FluidAction action) {
        if (stack.isEmpty()) {
            return FluidStack.EMPTY;
        }
        if (fluidHandler instanceof FluidHandlerList) {
            FluidHandlerList handlerList = (FluidHandlerList)fluidHandler;
            FluidStack copied = stack.copy();
            for (IFluidHandler handler : handlerList.handlers) {
                FluidStack candidate = copied.copy();
                if (handler instanceof NotifiableFluidTank) {
                    NotifiableFluidTank notifiable = (NotifiableFluidTank)handler;
                    copied.shrink(notifiable.drainInternal(candidate, action).getAmount());
                } else {
                    copied.shrink(handler.drain(candidate, action).getAmount());
                }
                if (copied.isEmpty()) break;
            }
            copied.setAmount(stack.getAmount() - copied.getAmount());
            return copied;
        }
        return fluidHandler.drain(stack, action);
    }

    public static boolean transferExactFluidStack(@NotNull IFluidHandler sourceHandler, @NotNull IFluidHandler destHandler, FluidStack fluidStack) {
        int amount = fluidStack.getAmount();
        FluidStack sourceFluid = sourceHandler.drain(fluidStack, IFluidHandler.FluidAction.SIMULATE);
        if (sourceFluid == FluidStack.EMPTY || sourceFluid.getAmount() != amount) {
            return false;
        }
        int canInsertAmount = destHandler.fill(sourceFluid, IFluidHandler.FluidAction.SIMULATE);
        if (canInsertAmount == amount && (sourceFluid = sourceHandler.drain(sourceFluid, IFluidHandler.FluidAction.EXECUTE)) != FluidStack.EMPTY && sourceFluid.getAmount() > 0) {
            destHandler.fill(sourceFluid, IFluidHandler.FluidAction.EXECUTE);
            return true;
        }
        return false;
    }

    public static ItemStack insertItem(IItemHandler handler, ItemStack stack, boolean simulate) {
        if (handler == null || stack.m_41619_()) {
            return stack;
        }
        if (!stack.m_41753_()) {
            return GTTransferUtils.insertToEmpty(handler, stack, simulate);
        }
        IntArrayList emptySlots = new IntArrayList();
        int slots = handler.getSlots();
        for (int i = 0; i < slots; ++i) {
            ItemStack slotStack = handler.getStackInSlot(i);
            if (slotStack.m_41619_()) {
                emptySlots.add(i);
                continue;
            }
            if (!ItemHandlerHelper.canItemStacksStack((ItemStack)stack, (ItemStack)slotStack) || !(stack = handler.insertItem(i, stack, simulate)).m_41619_()) continue;
            return ItemStack.f_41583_;
        }
        IntListIterator intListIterator = emptySlots.iterator();
        while (intListIterator.hasNext()) {
            int slot = (Integer)intListIterator.next();
            stack = handler.insertItem(slot, stack, simulate);
            if (!stack.m_41619_()) continue;
            return ItemStack.f_41583_;
        }
        return stack;
    }

    public static ItemStack insertToEmpty(IItemHandler handler, ItemStack stack, boolean simulate) {
        if (handler == null || stack.m_41619_()) {
            return stack;
        }
        int slots = handler.getSlots();
        for (int i = 0; i < slots; ++i) {
            ItemStack slotStack = handler.getStackInSlot(i);
            if (!slotStack.m_41619_() || !(stack = handler.insertItem(i, stack, simulate)).m_41619_()) continue;
            return ItemStack.f_41583_;
        }
        return stack;
    }
}

