/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.utils;

import it.unimi.dsi.fastutil.Hash;
import java.util.Objects;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.Nullable;

public interface FluidStackHashStrategy
extends Hash.Strategy<FluidStack> {
    public static FluidStackHashStrategyBuilder builder() {
        return new FluidStackHashStrategyBuilder();
    }

    public static FluidStackHashStrategy comparingAll() {
        return FluidStackHashStrategy.builder().compareFluid(true).compareCount(true).compareTag(true).build();
    }

    public static FluidStackHashStrategy comparingAllButAmount() {
        return FluidStackHashStrategy.builder().compareFluid(true).compareTag(true).build();
    }

    public static class FluidStackHashStrategyBuilder {
        private boolean fluid;
        private boolean amount;
        private boolean damage;
        private boolean tag;

        public FluidStackHashStrategyBuilder compareFluid(boolean choice) {
            this.fluid = choice;
            return this;
        }

        public FluidStackHashStrategyBuilder compareCount(boolean choice) {
            this.amount = choice;
            return this;
        }

        public FluidStackHashStrategyBuilder compareTag(boolean choice) {
            this.tag = choice;
            return this;
        }

        public FluidStackHashStrategy build() {
            return new FluidStackHashStrategy(){

                public int hashCode(@Nullable FluidStack o) {
                    return o == null || o.isEmpty() ? 0 : Objects.hash(fluid ? o.getFluid() : null, amount ? Integer.valueOf(o.getAmount()) : null, tag ? o.getTag() : null);
                }

                public boolean equals(@Nullable FluidStack a, @Nullable FluidStack b) {
                    if (a == null || a.isEmpty()) {
                        return b == null || b.isEmpty();
                    }
                    if (b == null || b.isEmpty()) {
                        return false;
                    }
                    return !(fluid && a.getFluid() != b.getFluid() || amount && a.getAmount() != b.getAmount() || tag && !Objects.equals(a.getTag(), b.getTag()));
                }
            };
        }
    }
}

