/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.integration.top.provider;

import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.api.machine.steam.SteamBoilerMachine;
import com.gregtechceu.gtceu.integration.top.provider.CapabilityInfoProvider;
import mcjty.theoneprobe.api.ElementAlignment;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.Nullable;

public class SteamBoilerInfoProvider
extends CapabilityInfoProvider<SteamBoilerMachine> {
    @Override
    @Nullable
    protected SteamBoilerMachine getCapability(Level level, BlockPos blockPos, @Nullable Direction side) {
        MetaMachine metaMachine = MetaMachine.getMachine((BlockGetter)level, blockPos);
        if (metaMachine instanceof SteamBoilerMachine) {
            SteamBoilerMachine steamBoilerMachine = (SteamBoilerMachine)metaMachine;
            return steamBoilerMachine;
        }
        return null;
    }

    @Override
    protected void addProbeInfo(SteamBoilerMachine capability, IProbeInfo probeInfo, Player player, BlockEntity blockEntity, IProbeHitData data) {
        boolean producingSteam;
        IProbeInfo horizontalPane = probeInfo.horizontal(probeInfo.defaultLayoutStyle().alignment(ElementAlignment.ALIGN_CENTER));
        boolean bl = producingSteam = !capability.isHasNoWater() && capability.getCurrentTemperature() >= 100;
        if (capability.getRecipeLogic().isWorking()) {
            horizontalPane.text("gtceu.machine.boiler.info.heating.up", new Object[]{producingSteam ? Component.m_237115_((String)"gtceu.machine.boiler.info.producing.steam") : ""});
        } else if (capability.getCurrentTemperature() > 0) {
            horizontalPane.text("gtceu.machine.boiler.info.cooling.down", new Object[]{producingSteam ? Component.m_237115_((String)"gtceu.machine.boiler.info.producing.steam") : ""});
        }
    }

    public ResourceLocation getID() {
        return GTCEu.id("steam_boiler_info");
    }
}

