/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.integration.top.provider;

import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.capability.GTCapabilityHelper;
import com.gregtechceu.gtceu.api.capability.recipe.FluidRecipeCapability;
import com.gregtechceu.gtceu.api.capability.recipe.ItemRecipeCapability;
import com.gregtechceu.gtceu.api.machine.trait.RecipeLogic;
import com.gregtechceu.gtceu.api.recipe.GTRecipe;
import com.gregtechceu.gtceu.api.recipe.RecipeHelper;
import com.gregtechceu.gtceu.api.recipe.chance.boost.ChanceBoostFunction;
import com.gregtechceu.gtceu.api.recipe.content.Content;
import com.gregtechceu.gtceu.api.recipe.ingredient.FluidIngredient;
import com.gregtechceu.gtceu.integration.top.element.FluidStackElement;
import com.gregtechceu.gtceu.integration.top.element.FluidStyle;
import com.gregtechceu.gtceu.integration.top.provider.CapabilityInfoProvider;
import java.util.ArrayList;
import java.util.List;
import mcjty.theoneprobe.api.CompoundText;
import mcjty.theoneprobe.api.ElementAlignment;
import mcjty.theoneprobe.api.IElement;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.apiimpl.styles.ItemStyle;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.Nullable;

public class RecipeOutputProvider
extends CapabilityInfoProvider<RecipeLogic> {
    public ResourceLocation getID() {
        return GTCEu.id("recipe_output_info");
    }

    @Override
    @Nullable
    protected RecipeLogic getCapability(Level level, BlockPos blockPos, @Nullable Direction direction) {
        return GTCapabilityHelper.getRecipeLogic(level, blockPos, direction);
    }

    @Override
    protected void addProbeInfo(RecipeLogic recipeLogic, IProbeInfo iProbeInfo, Player player, BlockEntity blockEntity, IProbeHitData iProbeHitData) {
        GTRecipe recipe;
        if (recipeLogic.isWorking() && (recipe = recipeLogic.getLastRecipe()) != null) {
            int recipeTier = RecipeHelper.getPreOCRecipeEuTier(recipe);
            int chanceTier = recipeTier + recipe.ocLevel;
            ChanceBoostFunction function = recipe.getType().getChanceFunction();
            List<Content> itemContents = recipe.getOutputContents(ItemRecipeCapability.CAP);
            List<Content> fluidContents = recipe.getOutputContents(FluidRecipeCapability.CAP);
            ArrayList<ItemStack> itemOutputs = new ArrayList<ItemStack>();
            for (Content content : itemContents) {
                ItemStack[] stacks = ((Ingredient)ItemRecipeCapability.CAP.of(content.content)).m_43908_();
                if (stacks.length == 0 || stacks[0].m_41619_()) continue;
                ItemStack stack = stacks[0].m_41777_();
                if (content.chance < content.maxChance) {
                    int count = stack.m_41613_();
                    double countD = (double)count * (double)recipe.parallels * (double)function.getBoostedChance(content, recipeTier, chanceTier) / (double)content.maxChance;
                    count = countD < 1.0 ? 1 : (int)Math.round(countD);
                    stack.m_41764_(count);
                }
                itemOutputs.add(stack);
            }
            ArrayList<FluidStack> fluidOutputs = new ArrayList<FluidStack>();
            for (Content fluid : fluidContents) {
                FluidStack[] stacks = ((FluidIngredient)FluidRecipeCapability.CAP.of(fluid.content)).getStacks();
                if (stacks.length == 0 || stacks[0].isEmpty()) continue;
                FluidStack stack = stacks[0].copy();
                if (fluid.chance < fluid.maxChance) {
                    int amount = stack.getAmount();
                    double amountD = (double)amount * (double)recipe.parallels * (double)function.getBoostedChance(fluid, recipeTier, chanceTier) / (double)fluid.maxChance;
                    amount = amountD < 1.0 ? 1 : (int)Math.round(amountD);
                    stack.setAmount(amount);
                }
                fluidOutputs.add(stack);
            }
            if (!itemOutputs.isEmpty() || !fluidOutputs.isEmpty()) {
                IProbeInfo iProbeInfo2 = iProbeInfo.vertical(iProbeInfo.defaultLayoutStyle().spacing(0));
                iProbeInfo2.text(CompoundText.create().info((Component)Component.m_237115_((String)"gtceu.top.recipe_output").m_130946_(" ")));
                this.addItemInfo(iProbeInfo2, itemOutputs);
                this.addFluidInfo(iProbeInfo2, fluidOutputs);
            }
        }
    }

    private void addItemInfo(IProbeInfo verticalPane, List<ItemStack> outputItems) {
        for (ItemStack itemOutput : outputItems) {
            if (itemOutput == null || itemOutput.m_41619_()) continue;
            IProbeInfo horizontalPane = verticalPane.horizontal(verticalPane.defaultLayoutStyle().alignment(ElementAlignment.ALIGN_CENTER));
            horizontalPane.item(itemOutput, new ItemStyle().width(16).height(16)).text(" ").itemLabel(itemOutput);
        }
    }

    private void addFluidInfo(IProbeInfo verticalPane, List<FluidStack> outputFluids) {
        for (FluidStack fluidOutput : outputFluids) {
            if (fluidOutput == null || fluidOutput.isEmpty()) continue;
            IProbeInfo horizontalPane = verticalPane.horizontal(verticalPane.defaultLayoutStyle().alignment(ElementAlignment.ALIGN_CENTER));
            horizontalPane.element((IElement)new FluidStackElement(fluidOutput, new FluidStyle())).text(" ").text(fluidOutput.getDisplayName());
        }
    }
}

