/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.integration.kjs.recipe.components;

import com.google.gson.JsonElement;
import com.gregtechceu.gtceu.api.recipe.ingredient.IntProviderIngredient;
import com.gregtechceu.gtceu.api.recipe.ingredient.SizedIngredient;
import dev.latvian.mods.kubejs.core.IngredientKJS;
import dev.latvian.mods.kubejs.item.InputItem;
import dev.latvian.mods.kubejs.item.OutputItem;
import dev.latvian.mods.kubejs.recipe.OutputReplacement;
import dev.latvian.mods.kubejs.recipe.RecipeJS;
import dev.latvian.mods.kubejs.recipe.ReplacementMatch;
import dev.latvian.mods.kubejs.util.ConsoleJS;
import dev.latvian.mods.rhino.NativeObject;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraftforge.common.crafting.StrictNBTIngredient;

public class ExtendedOutputItem
extends OutputItem
implements OutputReplacement {
    public SizedIngredient ingredient;

    public ExtendedOutputItem(Ingredient ingredient, int count) {
        super(((IngredientKJS)ingredient).kjs$getFirst().m_255036_(count), Double.NaN, null);
        if (ingredient instanceof IntProviderIngredient) {
            IntProviderIngredient intProvider = (IntProviderIngredient)ingredient;
            intProvider.setItemStacks(null);
            intProvider.setSampledCount(null);
        }
        this.ingredient = SizedIngredient.create(ingredient, count);
    }

    public ExtendedOutputItem(ItemStack stack) {
        super(stack, Double.NaN, null);
        this.ingredient = SizedIngredient.create((Ingredient)StrictNBTIngredient.of((ItemStack)stack));
    }

    private ExtendedOutputItem(OutputItem item) {
        this(Ingredient.m_43927_((ItemStack[])new ItemStack[]{item.item}), item.getCount());
    }

    public static ExtendedOutputItem of(Object o) {
        if (o instanceof ExtendedOutputItem) {
            ExtendedOutputItem extendedOutput = (ExtendedOutputItem)((Object)o);
            return extendedOutput;
        }
        if (o instanceof ItemStack) {
            ItemStack stack = (ItemStack)o;
            if (stack.m_41782_()) {
                return new ExtendedOutputItem((Ingredient)StrictNBTIngredient.of((ItemStack)stack), stack.m_41613_());
            }
            return new ExtendedOutputItem(Ingredient.m_43927_((ItemStack[])new ItemStack[]{stack}), stack.m_41613_());
        }
        if (o instanceof InputItem) {
            InputItem input = (InputItem)o;
            return new ExtendedOutputItem(input.ingredient, input.count);
        }
        if (o instanceof OutputItem) {
            OutputItem output = (OutputItem)o;
            return ExtendedOutputItem.fromOutputItem(output);
        }
        if (o instanceof NativeObject) {
            NativeObject nativeObject = (NativeObject)o;
            InputItem input = InputItem.of((Object)nativeObject);
            return new ExtendedOutputItem(input.ingredient, input.count);
        }
        if (o instanceof JsonElement) {
            JsonElement json = (JsonElement)o;
            InputItem input = InputItem.of((Object)json);
            return new ExtendedOutputItem(input.ingredient, input.count);
        }
        if (o instanceof CompoundTag) {
            CompoundTag tag = (CompoundTag)o;
            InputItem input = InputItem.of((Object)tag);
            return new ExtendedOutputItem(input.ingredient, input.count);
        }
        if (o instanceof Map) {
            Map map = (Map)o;
            InputItem input = InputItem.of((Object)map);
            return new ExtendedOutputItem(input.ingredient, input.count);
        }
        OutputItem output = OutputItem.of((Object)o);
        if (output.item.m_41782_()) {
            return new ExtendedOutputItem((Ingredient)StrictNBTIngredient.of((ItemStack)output.item), output.getCount());
        }
        return new ExtendedOutputItem(output);
    }

    public static ExtendedOutputItem fromOutputItem(OutputItem item) {
        if (item instanceof ExtendedOutputItem) {
            ExtendedOutputItem extended = (ExtendedOutputItem)item;
            return extended;
        }
        return new ExtendedOutputItem(item);
    }

    public OutputItem withCount(int count) {
        this.ingredient = SizedIngredient.create(this.ingredient.getInner(), count);
        return super.withCount(count);
    }

    public OutputItem withRolls(IntProvider rolls) {
        IntProviderIngredient ingredient;
        Ingredient ingredient2 = this.ingredient.getInner();
        if (ingredient2 instanceof IntProviderIngredient) {
            IntProviderIngredient intProvider = (IntProviderIngredient)ingredient2;
            ingredient = new IntProviderIngredient(intProvider.getInner(), rolls);
        } else {
            ingredient = new IntProviderIngredient(this.ingredient.getInner(), rolls);
        }
        return new ExtendedOutputItem(ingredient, this.ingredient.getAmount());
    }

    public int getCount() {
        return this.ingredient.getAmount();
    }

    public Object replaceOutput(RecipeJS recipe, ReplacementMatch match, OutputReplacement original) {
        if (original instanceof ExtendedOutputItem) {
            ExtendedOutputItem o = (ExtendedOutputItem)original;
            return new ExtendedOutputItem(this.ingredient, o.getCount());
        }
        return super.replaceOutput(recipe, match, original);
    }

    public InputItem ignoreNBT() {
        ConsoleJS console = ConsoleJS.getCurrent((ConsoleJS)ConsoleJS.SERVER);
        console.warn((Object)"You don't need to call .ignoreNBT() anymore, all item ingredients ignore NBT by default!");
        return InputItem.of((Ingredient)this.ingredient.getInner(), (int)this.ingredient.getAmount());
    }
}

