/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.integration.kjs.builders.machine;

import com.google.common.base.Preconditions;
import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.api.machine.IMachineBlockEntity;
import com.gregtechceu.gtceu.api.machine.MultiblockMachineDefinition;
import com.gregtechceu.gtceu.api.machine.multiblock.MultiblockControllerMachine;
import com.gregtechceu.gtceu.api.registry.registrate.BuilderBase;
import com.gregtechceu.gtceu.api.registry.registrate.MachineBuilder;
import com.gregtechceu.gtceu.api.registry.registrate.MultiblockMachineBuilder;
import com.gregtechceu.gtceu.common.data.machines.GTMachineUtils;
import com.gregtechceu.gtceu.common.registry.GTRegistration;
import dev.latvian.mods.kubejs.client.LangEventJS;
import java.util.Locale;
import lombok.Generated;
import net.minecraft.resources.ResourceLocation;

public class KJSTieredMultiblockBuilder
extends BuilderBase<MultiblockMachineDefinition[]> {
    public volatile int[] tiers = GTMachineUtils.ELECTRIC_TIERS;
    public volatile TieredCreationFunction machine;
    public volatile DefinitionFunction definition = (tier, def) -> def.tier(tier);

    public KJSTieredMultiblockBuilder(ResourceLocation id) {
        super(id);
    }

    public KJSTieredMultiblockBuilder(ResourceLocation id, TieredCreationFunction machine) {
        super(id);
        this.machine = machine;
    }

    @Override
    public void generateLang(LangEventJS lang) {
        super.generateLang(lang);
        for (int tier : this.tiers) {
            MultiblockMachineDefinition def = ((MultiblockMachineDefinition[])this.value)[tier];
            if (def.getLangValue() == null) continue;
            lang.add("gtceu", def.getDescriptionId(), def.getLangValue());
        }
    }

    @Override
    public MultiblockMachineDefinition[] register() {
        Preconditions.checkNotNull((Object)this.tiers, (Object)"Tiers can't be null!");
        Preconditions.checkArgument((this.tiers.length > 0 ? 1 : 0) != 0, (Object)"tiers must have at least one tier!");
        Preconditions.checkNotNull((Object)this.machine, (Object)"You must set a machine creation function! example: `builder.machine((holder, tier) => new SimpleTieredMachine(holder, tier, t => t * 3200)`");
        Preconditions.checkNotNull((Object)this.definition, (Object)"You must set a definition function! See GTMachines for examples");
        MultiblockMachineDefinition[] definitions = new MultiblockMachineDefinition[GTValues.TIER_COUNT];
        for (int tier : this.tiers) {
            String tierName = GTValues.VN[tier].toLowerCase(Locale.ROOT);
            MultiblockMachineBuilder builder = GTRegistration.REGISTRATE.multiblock(String.format("%s_%s", tierName, this.id.m_135815_()), holder -> this.machine.create((IMachineBlockEntity)holder, tier));
            builder.workableTieredHullRenderer(this.id.m_246208_("block/machines/")).tier(tier);
            this.definition.apply(tier, builder);
            definitions[tier] = builder.register();
        }
        this.value = definitions;
        return definitions;
    }

    @Generated
    public KJSTieredMultiblockBuilder tiers(int[] tiers) {
        this.tiers = tiers;
        return this;
    }

    @Generated
    public KJSTieredMultiblockBuilder machine(TieredCreationFunction machine) {
        this.machine = machine;
        return this;
    }

    @Generated
    public KJSTieredMultiblockBuilder definition(DefinitionFunction definition) {
        this.definition = definition;
        return this;
    }

    @FunctionalInterface
    public static interface DefinitionFunction {
        public void apply(int var1, MachineBuilder<?> var2);
    }

    @FunctionalInterface
    public static interface TieredCreationFunction {
        public MultiblockControllerMachine create(IMachineBlockEntity var1, int var2);
    }
}

