/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.integration.kjs.builders.machine;

import com.gregtechceu.gtceu.api.machine.IMachineBlockEntity;
import com.gregtechceu.gtceu.api.machine.MachineDefinition;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.api.machine.steam.SimpleSteamMachine;
import com.gregtechceu.gtceu.api.registry.registrate.BuilderBase;
import com.gregtechceu.gtceu.api.registry.registrate.MachineBuilder;
import com.gregtechceu.gtceu.client.renderer.machine.WorkableSteamMachineRenderer;
import com.gregtechceu.gtceu.common.registry.GTRegistration;
import com.gregtechceu.gtceu.utils.FormattingUtil;
import dev.latvian.mods.kubejs.client.LangEventJS;
import lombok.Generated;
import net.minecraft.resources.ResourceLocation;

public class KJSSteamMachineBuilder
extends BuilderBase<MachineDefinition> {
    public volatile boolean hasHighPressure = true;
    public volatile SteamCreationFunction machine = (x$0, x$1) -> new SimpleSteamMachine(x$0, x$1, new Object[0]);
    public volatile SteamDefinitionFunction definition = (isHP, def) -> def.tier(isHP ? 1 : 0);
    private volatile MachineDefinition hp = null;

    public KJSSteamMachineBuilder(ResourceLocation id) {
        super(id);
    }

    @Override
    public MachineDefinition register() {
        MachineBuilder<MachineDefinition> lowPressureBuilder = GTRegistration.REGISTRATE.machine(String.format("lp_%s", this.id.m_135815_()), holder -> this.machine.create((IMachineBlockEntity)holder, false));
        lowPressureBuilder.langValue("Low Pressure " + FormattingUtil.toEnglishName(this.id.m_135815_())).tier(0).recipeModifier(SimpleSteamMachine::recipeModifier).renderer(() -> new WorkableSteamMachineRenderer(false, this.id.m_246208_("block/machines/")));
        this.definition.apply(false, lowPressureBuilder);
        Object lowPressure = lowPressureBuilder.register();
        if (this.hasHighPressure) {
            MachineBuilder<MachineDefinition> highPressureBuilder = GTRegistration.REGISTRATE.machine(String.format("hp_%s", this.id.m_135815_()), holder -> this.machine.create((IMachineBlockEntity)holder, true));
            highPressureBuilder.langValue("High Pressure " + FormattingUtil.toEnglishName(this.id.m_135815_())).tier(1).recipeModifier(SimpleSteamMachine::recipeModifier).renderer(() -> new WorkableSteamMachineRenderer(true, this.id.m_246208_("block/machines/")));
            this.definition.apply(true, highPressureBuilder);
            this.hp = highPressureBuilder.register();
        }
        this.value = lowPressure;
        return (MachineDefinition)this.value;
    }

    @Override
    public void generateLang(LangEventJS lang) {
        super.generateLang(lang);
        lang.add("gtceu", ((MachineDefinition)this.value).getDescriptionId(), ((MachineDefinition)this.value).getLangValue());
        if (this.hp != null) {
            lang.add("gtceu", this.hp.getDescriptionId(), this.hp.getLangValue());
        }
    }

    @Generated
    public KJSSteamMachineBuilder hasHighPressure(boolean hasHighPressure) {
        this.hasHighPressure = hasHighPressure;
        return this;
    }

    @Generated
    public KJSSteamMachineBuilder machine(SteamCreationFunction machine) {
        this.machine = machine;
        return this;
    }

    @Generated
    public KJSSteamMachineBuilder definition(SteamDefinitionFunction definition) {
        this.definition = definition;
        return this;
    }

    @FunctionalInterface
    public static interface SteamCreationFunction {
        public MetaMachine create(IMachineBlockEntity var1, boolean var2);
    }

    @FunctionalInterface
    public static interface SteamDefinitionFunction {
        public void apply(boolean var1, MachineBuilder<?> var2);
    }
}

