/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.integration.kjs.builders.block;

import com.gregtechceu.gtceu.api.GTCEuAPI;
import com.gregtechceu.gtceu.api.block.ActiveBlock;
import com.gregtechceu.gtceu.api.block.SimpleCoilType;
import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.common.block.CoilBlock;
import dev.latvian.mods.kubejs.block.BlockBuilder;
import dev.latvian.mods.kubejs.client.VariantBlockStateGenerator;
import dev.latvian.mods.kubejs.generator.AssetJsonGenerator;
import java.util.function.Supplier;
import lombok.Generated;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CoilBlockBuilder
extends BlockBuilder {
    public transient int temperature = 0;
    public transient int level = 0;
    public transient int energyDiscount = 1;
    public transient int tier = 0;
    public transient @NotNull Supplier<@Nullable Material> material = () -> null;
    public transient String texture = "minecraft:missingno";

    public CoilBlockBuilder(ResourceLocation i) {
        super(i);
        this.property((Property)ActiveBlock.ACTIVE);
        this.renderType("cutout_mipped");
        this.noValidSpawns(true);
    }

    protected void generateBlockStateJson(VariantBlockStateGenerator bs) {
        bs.simpleVariant("active=false", this.newID("block/", "").toString());
        bs.simpleVariant("active=true", this.newID("block/", "_active").toString());
    }

    protected void generateBlockModelJsons(AssetJsonGenerator generator) {
        generator.blockModel(this.id, m -> {
            m.parent("minecraft:block/cube_all");
            m.texture("all", this.texture);
        });
        generator.blockModel(this.id.m_266382_("_active"), m -> {
            m.parent("gtceu:block/cube_2_layer/all");
            m.texture("bot_all", this.texture);
            m.texture("top_all", this.texture + "_bloom");
        });
    }

    public CoilBlockBuilder coilMaterial(@NotNull Supplier<@Nullable Material> material) {
        this.material = material;
        return this;
    }

    public Block createObject() {
        SimpleCoilType coilType = new SimpleCoilType(this.id.m_135815_(), this.temperature, this.level, this.energyDiscount, this.tier, this.material, new ResourceLocation(this.texture));
        CoilBlock result = new CoilBlock(this.createProperties(), coilType);
        GTCEuAPI.HEATING_COILS.put(coilType, () -> result);
        return result;
    }

    @Generated
    public CoilBlockBuilder temperature(int temperature) {
        this.temperature = temperature;
        return this;
    }

    @Generated
    public CoilBlockBuilder level(int level) {
        this.level = level;
        return this;
    }

    @Generated
    public CoilBlockBuilder energyDiscount(int energyDiscount) {
        this.energyDiscount = energyDiscount;
        return this;
    }

    @Generated
    public CoilBlockBuilder tier(int tier) {
        this.tier = tier;
        return this;
    }

    @Generated
    public CoilBlockBuilder texture(String texture) {
        this.texture = texture;
        return this;
    }
}

