/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.integration.ae2.machine;

import appeng.api.crafting.IPatternDetails;
import appeng.api.crafting.PatternDetailsHelper;
import appeng.api.implementations.blockentities.PatternContainerGroup;
import appeng.api.inventories.InternalInventory;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridNodeListener;
import appeng.api.networking.IGridNodeService;
import appeng.api.networking.IManagedGridNode;
import appeng.api.networking.crafting.ICraftingProvider;
import appeng.api.networking.energy.IEnergyService;
import appeng.api.networking.energy.IEnergySource;
import appeng.api.networking.security.IActionSource;
import appeng.api.stacks.AEFluidKey;
import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.AEKeyType;
import appeng.api.stacks.KeyCounter;
import appeng.api.storage.MEStorage;
import appeng.api.storage.StorageHelper;
import appeng.crafting.pattern.EncodedPatternItem;
import appeng.crafting.pattern.ProcessingPatternItem;
import appeng.helpers.patternprovider.PatternContainer;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.capability.recipe.IO;
import com.gregtechceu.gtceu.api.capability.recipe.ItemRecipeCapability;
import com.gregtechceu.gtceu.api.gui.GuiTextures;
import com.gregtechceu.gtceu.api.gui.fancy.ConfiguratorPanel;
import com.gregtechceu.gtceu.api.machine.IMachineBlockEntity;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.api.machine.MultiblockMachineDefinition;
import com.gregtechceu.gtceu.api.machine.TickableSubscription;
import com.gregtechceu.gtceu.api.machine.fancyconfigurator.ButtonConfigurator;
import com.gregtechceu.gtceu.api.machine.fancyconfigurator.CircuitFancyConfigurator;
import com.gregtechceu.gtceu.api.machine.fancyconfigurator.FancyInvConfigurator;
import com.gregtechceu.gtceu.api.machine.fancyconfigurator.FancyTankConfigurator;
import com.gregtechceu.gtceu.api.machine.feature.IDataStickInteractable;
import com.gregtechceu.gtceu.api.machine.feature.IHasCircuitSlot;
import com.gregtechceu.gtceu.api.machine.feature.multiblock.IMultiController;
import com.gregtechceu.gtceu.api.machine.trait.NotifiableFluidTank;
import com.gregtechceu.gtceu.api.machine.trait.NotifiableItemStackHandler;
import com.gregtechceu.gtceu.api.recipe.ingredient.FluidIngredient;
import com.gregtechceu.gtceu.api.transfer.item.CustomItemStackHandler;
import com.gregtechceu.gtceu.common.data.machines.GTAEMachines;
import com.gregtechceu.gtceu.common.item.IntCircuitBehaviour;
import com.gregtechceu.gtceu.integration.ae2.gui.widget.AETextInputButtonWidget;
import com.gregtechceu.gtceu.integration.ae2.gui.widget.slot.AEPatternViewSlotWidget;
import com.gregtechceu.gtceu.integration.ae2.machine.MEBusPartMachine;
import com.gregtechceu.gtceu.integration.ae2.machine.MEPatternBufferProxyPartMachine;
import com.gregtechceu.gtceu.integration.ae2.machine.trait.MEPatternBufferRecipeHandler;
import com.gregtechceu.gtceu.integration.ae2.utils.AEUtil;
import com.gregtechceu.gtceu.utils.GTMath;
import com.gregtechceu.gtceu.utils.GTUtil;
import com.lowdragmc.lowdraglib.gui.texture.GuiTextureGroup;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.util.ClickData;
import com.lowdragmc.lowdraglib.gui.widget.LabelWidget;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import com.lowdragmc.lowdraglib.syncdata.IContentChangeAware;
import com.lowdragmc.lowdraglib.syncdata.ITagSerializable;
import com.lowdragmc.lowdraglib.syncdata.annotation.DescSynced;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import com.lowdragmc.lowdraglib.syncdata.field.ManagedFieldHolder;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.annotation.ParametersAreNonnullByDefault;
import lombok.Generated;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.TickTask;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.items.IItemHandlerModifiable;
import org.apache.commons.lang3.ArrayUtils;
import org.jetbrains.annotations.Nullable;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class MEPatternBufferPartMachine
extends MEBusPartMachine
implements ICraftingProvider,
PatternContainer,
IHasCircuitSlot,
IDataStickInteractable {
    protected static final ManagedFieldHolder MANAGED_FIELD_HOLDER = new ManagedFieldHolder(MEPatternBufferPartMachine.class, MEBusPartMachine.MANAGED_FIELD_HOLDER);
    protected static final int MAX_PATTERN_COUNT = 27;
    private final InternalInventory internalPatternInventory = new InternalInventory(){

        public int size() {
            return 27;
        }

        public ItemStack getStackInSlot(int slotIndex) {
            return MEPatternBufferPartMachine.this.patternInventory.getStackInSlot(slotIndex);
        }

        public void setItemDirect(int slotIndex, ItemStack stack) {
            MEPatternBufferPartMachine.this.patternInventory.setStackInSlot(slotIndex, stack);
            MEPatternBufferPartMachine.this.patternInventory.onContentsChanged(slotIndex);
            MEPatternBufferPartMachine.this.onPatternChange(slotIndex);
        }
    };
    @Persisted
    @DescSynced
    private final CustomItemStackHandler patternInventory = new CustomItemStackHandler(27);
    @Persisted
    protected final NotifiableItemStackHandler circuitInventorySimulated;
    @Persisted
    protected final NotifiableItemStackHandler shareInventory;
    @Persisted
    protected final NotifiableFluidTank shareTank;
    @Persisted
    protected final InternalSlot[] internalInventory = new InternalSlot[27];
    private final BiMap<IPatternDetails, InternalSlot> detailsSlotMap = HashBiMap.create((int)27);
    @DescSynced
    @Persisted
    private String customName = "";
    private boolean needPatternSync;
    @Persisted
    private HashSet<BlockPos> proxies = new HashSet();
    protected final MEPatternBufferRecipeHandler recipeHandler = new MEPatternBufferRecipeHandler(this);
    @Nullable
    protected TickableSubscription updateSubs;

    @Override
    public NotifiableItemStackHandler getCircuitInventory() {
        return this.getCircuitInventorySimulated();
    }

    @Override
    public boolean isWorkingEnabled() {
        return true;
    }

    @Override
    public void setWorkingEnabled(boolean ignored) {
    }

    public MEPatternBufferPartMachine(IMachineBlockEntity holder, Object ... args) {
        super(holder, IO.IN, args);
        this.patternInventory.setFilter(stack -> stack.m_41720_() instanceof ProcessingPatternItem);
        for (int i = 0; i < this.internalInventory.length; ++i) {
            this.internalInventory[i] = new InternalSlot();
        }
        this.getMainNode().addService(ICraftingProvider.class, (IGridNodeService)this);
        this.circuitInventorySimulated = new NotifiableItemStackHandler(this, 1, IO.IN, IO.NONE).setFilter(IntCircuitBehaviour::isIntegratedCircuit);
        this.shareInventory = new NotifiableItemStackHandler(this, 9, IO.IN, IO.NONE);
        this.shareTank = new NotifiableFluidTank(this, 9, 8000, IO.IN, IO.NONE);
    }

    @Override
    public void onLoad() {
        super.onLoad();
        Level level = this.getLevel();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.m_7654_().m_6937_((Runnable)new TickTask(1, () -> {
                for (int i = 0; i < this.patternInventory.getSlots(); ++i) {
                    ItemStack pattern = this.patternInventory.getStackInSlot(i);
                    IPatternDetails patternDetails = PatternDetailsHelper.decodePattern((ItemStack)pattern, (Level)this.getLevel());
                    if (patternDetails == null) continue;
                    this.detailsSlotMap.put((Object)patternDetails, (Object)this.internalInventory[i]);
                }
            }));
        }
        this.getRecipeHandlers().forEach(handler -> handler.addChangedListener(() -> this.getProxies().forEach(proxy -> {
            if (handler.getCapability() == ItemRecipeCapability.CAP) {
                proxy.itemProxyHandler.notifyListeners();
            } else {
                proxy.fluidProxyHandler.notifyListeners();
            }
        })));
    }

    @Override
    public void onMainNodeStateChanged(IGridNodeListener.State reason) {
        super.onMainNodeStateChanged(reason);
        this.updateSubscription();
    }

    protected void updateSubscription() {
        if (this.getMainNode().isOnline()) {
            this.updateSubs = this.subscribeServerTick(this.updateSubs, this::update);
        } else if (this.updateSubs != null) {
            this.updateSubs.unsubscribe();
            this.updateSubs = null;
        }
    }

    protected void update() {
        if (this.needPatternSync) {
            ICraftingProvider.requestUpdate((IManagedGridNode)this.getMainNode());
            this.needPatternSync = false;
        }
    }

    public void addProxy(MEPatternBufferProxyPartMachine proxy) {
        this.proxies.add(proxy.getPos());
    }

    public void removeProxy(MEPatternBufferProxyPartMachine proxy) {
        this.proxies.remove(proxy.getPos());
    }

    public Set<MEPatternBufferProxyPartMachine> getProxies() {
        HashSet<MEPatternBufferProxyPartMachine> proxies1 = new HashSet<MEPatternBufferProxyPartMachine>();
        for (BlockPos pos : this.proxies) {
            MetaMachine metaMachine = MetaMachine.getMachine((BlockGetter)this.getLevel(), pos);
            if (!(metaMachine instanceof MEPatternBufferProxyPartMachine)) continue;
            MEPatternBufferProxyPartMachine p = (MEPatternBufferProxyPartMachine)metaMachine;
            proxies1.add(p);
        }
        return proxies1;
    }

    private void refundAll(ClickData clickData) {
        if (!clickData.isRemote) {
            for (InternalSlot internalSlot : this.internalInventory) {
                internalSlot.refund();
            }
        }
    }

    private void onPatternChange(int index) {
        if (this.isRemote()) {
            return;
        }
        InternalSlot internalInv = this.internalInventory[index];
        ItemStack newPattern = this.patternInventory.getStackInSlot(index);
        IPatternDetails newPatternDetails = PatternDetailsHelper.decodePattern((ItemStack)newPattern, (Level)this.getLevel());
        IPatternDetails oldPatternDetails = (IPatternDetails)this.detailsSlotMap.inverse().get((Object)internalInv);
        this.detailsSlotMap.forcePut((Object)newPatternDetails, (Object)internalInv);
        if (oldPatternDetails != null && !oldPatternDetails.equals(newPatternDetails)) {
            internalInv.refund();
        }
        this.needPatternSync = true;
    }

    @Override
    public void attachConfigurators(ConfiguratorPanel configuratorPanel) {
        configuratorPanel.attachConfigurators(new ButtonConfigurator((IGuiTexture)new GuiTextureGroup(new IGuiTexture[]{GuiTextures.BUTTON, GuiTextures.REFUND_OVERLAY}), this::refundAll).setTooltips(List.of(Component.m_237115_((String)"gui.gtceu.refund_all.desc"))));
        configuratorPanel.attachConfigurators(new CircuitFancyConfigurator(this.circuitInventorySimulated.storage));
        configuratorPanel.attachConfigurators(new FancyInvConfigurator(this.shareInventory.storage, (Component)Component.m_237115_((String)"gui.gtceu.share_inventory.title")).setTooltips(List.of(Component.m_237115_((String)"gui.gtceu.share_inventory.desc.0"), Component.m_237115_((String)"gui.gtceu.share_inventory.desc.1"))));
        configuratorPanel.attachConfigurators(new FancyTankConfigurator(this.shareTank.getStorages(), (Component)Component.m_237115_((String)"gui.gtceu.share_tank.title")).setTooltips(List.of(Component.m_237115_((String)"gui.gtceu.share_tank.desc.0"), Component.m_237115_((String)"gui.gtceu.share_inventory.desc.1"))));
    }

    @Override
    public Widget createUIWidget() {
        int rowSize = 9;
        int colSize = 3;
        WidgetGroup group = new WidgetGroup(0, 0, 18 * rowSize + 16, 18 * colSize + 16);
        int index = 0;
        for (int y = 0; y < colSize; ++y) {
            for (int x = 0; x < rowSize; ++x) {
                int finalI = index;
                Widget slot = new AEPatternViewSlotWidget((IItemHandlerModifiable)this.patternInventory, index++, 8 + x * 18, 14 + y * 18).setOccupiedTexture(new IGuiTexture[]{GuiTextures.SLOT}).setItemHook(stack -> {
                    EncodedPatternItem iep;
                    ItemStack out;
                    Item patt12610$temp;
                    if (!stack.m_41619_() && (patt12610$temp = stack.m_41720_()) instanceof EncodedPatternItem && !(out = (iep = (EncodedPatternItem)patt12610$temp).getOutput(stack)).m_41619_()) {
                        return out;
                    }
                    return stack;
                }).setChangeListener(() -> this.onPatternChange(finalI)).setBackground(new IGuiTexture[]{GuiTextures.SLOT, GuiTextures.PATTERN_OVERLAY});
                group.addWidget(slot);
            }
        }
        group.addWidget((Widget)new LabelWidget(8, 2, () -> this.isOnline ? "gtceu.gui.me_network.online" : "gtceu.gui.me_network.offline"));
        group.addWidget((Widget)new AETextInputButtonWidget(18 * rowSize + 8 - 70, 2, 70, 10).setText(this.customName).setOnConfirm(this::setCustomName).setButtonTooltips(new Component[]{Component.m_237115_((String)"gui.gtceu.rename.desc")}));
        return group;
    }

    public List<IPatternDetails> getAvailablePatterns() {
        return this.detailsSlotMap.keySet().stream().filter(Objects::nonNull).toList();
    }

    public boolean pushPattern(IPatternDetails patternDetails, KeyCounter[] inputHolder) {
        if (!(this.getMainNode().isActive() && this.detailsSlotMap.containsKey((Object)patternDetails) && this.checkInput(inputHolder))) {
            return false;
        }
        InternalSlot slot = (InternalSlot)this.detailsSlotMap.get((Object)patternDetails);
        if (slot != null) {
            slot.pushPattern(patternDetails, inputHolder);
            this.recipeHandler.onChanged();
            return true;
        }
        return false;
    }

    public boolean isBusy() {
        return false;
    }

    private boolean checkInput(KeyCounter[] inputHolder) {
        for (KeyCounter input : inputHolder) {
            boolean illegal = input.keySet().stream().map(AEKey::getType).map(AEKeyType::getId).anyMatch(id -> !id.equals((Object)AEKeyType.items().getId()) && !id.equals((Object)AEKeyType.fluids().getId()));
            if (!illegal) continue;
            return false;
        }
        return true;
    }

    @Override
    public ManagedFieldHolder getFieldHolder() {
        return MANAGED_FIELD_HOLDER;
    }

    @Nullable
    public IGrid getGrid() {
        return this.getMainNode().getGrid();
    }

    public InternalInventory getTerminalPatternInventory() {
        return this.internalPatternInventory;
    }

    public PatternContainerGroup getTerminalGroup() {
        if (this.isFormed()) {
            IMultiController controller = this.getControllers().first();
            MultiblockMachineDefinition controllerDefinition = controller.self().getDefinition();
            if (!this.customName.isEmpty()) {
                return new PatternContainerGroup(AEItemKey.of((ItemStack)controllerDefinition.asStack()), (Component)Component.m_237113_((String)this.customName), Collections.emptyList());
            }
            ItemStack circuitStack = this.circuitInventorySimulated.storage.getStackInSlot(0);
            int circuitConfiguration = circuitStack.m_41619_() ? -1 : IntCircuitBehaviour.getCircuitConfiguration(circuitStack);
            MutableComponent groupName = circuitConfiguration != -1 ? Component.m_237115_((String)controllerDefinition.getDescriptionId()).m_130946_(" - " + circuitConfiguration) : Component.m_237115_((String)controllerDefinition.getDescriptionId());
            return new PatternContainerGroup(AEItemKey.of((ItemStack)controllerDefinition.asStack()), (Component)groupName, Collections.emptyList());
        }
        if (!this.customName.isEmpty()) {
            return new PatternContainerGroup(AEItemKey.of((ItemLike)GTAEMachines.ME_PATTERN_BUFFER.getItem()), (Component)Component.m_237113_((String)this.customName), Collections.emptyList());
        }
        return new PatternContainerGroup(AEItemKey.of((ItemLike)GTAEMachines.ME_PATTERN_BUFFER.getItem()), GTAEMachines.ME_PATTERN_BUFFER.get().getDefinition().getItem().m_41466_(), Collections.emptyList());
    }

    @Override
    public void onMachineRemoved() {
        this.clearInventory((IItemHandlerModifiable)this.patternInventory);
        this.clearInventory(this.shareInventory);
    }

    @Override
    public InteractionResult onDataStickShiftUse(Player player, ItemStack dataStick) {
        dataStick.m_41784_().m_128385_("pos", new int[]{this.getPos().m_123341_(), this.getPos().m_123342_(), this.getPos().m_123343_()});
        return InteractionResult.SUCCESS;
    }

    @Generated
    public CustomItemStackHandler getPatternInventory() {
        return this.patternInventory;
    }

    @Generated
    public NotifiableItemStackHandler getCircuitInventorySimulated() {
        return this.circuitInventorySimulated;
    }

    @Generated
    public NotifiableItemStackHandler getShareInventory() {
        return this.shareInventory;
    }

    @Generated
    public NotifiableFluidTank getShareTank() {
        return this.shareTank;
    }

    @Generated
    public InternalSlot[] getInternalInventory() {
        return this.internalInventory;
    }

    @Generated
    public void setCustomName(String customName) {
        this.customName = customName;
    }

    public class InternalSlot
    implements ITagSerializable<CompoundTag>,
    IContentChangeAware {
        protected Runnable onContentsChanged = () -> {};
        private final Set<ItemStack> itemInventory = new HashSet<ItemStack>();
        private final Set<FluidStack> fluidInventory = new HashSet<FluidStack>();

        public boolean isItemEmpty() {
            return this.itemInventory.isEmpty();
        }

        public boolean isFluidEmpty() {
            return this.fluidInventory.isEmpty();
        }

        private void addItem(AEItemKey key, long amount) {
            if (amount <= 0L) {
                return;
            }
            for (ItemStack item : this.itemInventory) {
                if (!key.matches(item)) continue;
                long sum = (long)item.m_41613_() + amount;
                if (sum <= Integer.MAX_VALUE) {
                    item.m_41769_((int)amount);
                } else {
                    this.itemInventory.remove(item);
                    this.itemInventory.addAll(List.of(AEUtil.toItemStacks(key, sum)));
                }
                return;
            }
            this.itemInventory.addAll(List.of(AEUtil.toItemStacks(key, amount)));
            MEPatternBufferPartMachine.this.recipeHandler.getItemInputHandler().notifyListeners();
        }

        private void addFluid(AEFluidKey key, int amount) {
            if ((long)amount <= 0L) {
                return;
            }
            for (FluidStack fluid : this.fluidInventory) {
                if (!key.matches(fluid)) continue;
                int free = Integer.MAX_VALUE - fluid.getAmount();
                if (amount <= free) {
                    fluid.grow(amount);
                } else {
                    fluid.setAmount(Integer.MAX_VALUE);
                    this.fluidInventory.add(AEUtil.toFluidStack(key, amount - free));
                }
                return;
            }
            this.fluidInventory.add(AEUtil.toFluidStack(key, amount));
            MEPatternBufferPartMachine.this.recipeHandler.getFluidInputHandler().notifyListeners();
        }

        public ItemStack[] getItemInputs() {
            return (ItemStack[])ArrayUtils.addAll((Object[])this.itemInventory.toArray(new ItemStack[0]), (Object[])new ItemStack[0]);
        }

        public FluidStack[] getFluidInputs() {
            return (FluidStack[])ArrayUtils.addAll((Object[])this.fluidInventory.toArray(new FluidStack[0]), (Object[])new FluidStack[0]);
        }

        public void refund() {
            IGrid network = MEPatternBufferPartMachine.this.getMainNode().getGrid();
            if (network != null) {
                MEStorage networkInv = network.getStorageService().getInventory();
                IEnergyService energy = network.getEnergyService();
                for (ItemStack itemStack : this.itemInventory) {
                    long inserted;
                    AEItemKey key;
                    if (itemStack == null || (key = AEItemKey.of((ItemStack)itemStack)) == null || (inserted = StorageHelper.poweredInsert((IEnergySource)energy, (MEStorage)networkInv, (AEKey)key, (long)itemStack.m_41613_(), (IActionSource)MEPatternBufferPartMachine.this.actionSource)) <= 0L) continue;
                    itemStack.m_41774_((int)inserted);
                    if (!itemStack.m_41619_()) continue;
                    this.itemInventory.remove(itemStack);
                }
                for (FluidStack fluidStack : this.fluidInventory) {
                    int inserted;
                    if (fluidStack == null || fluidStack.isEmpty() || (inserted = GTMath.saturatedCast(StorageHelper.poweredInsert((IEnergySource)energy, (MEStorage)networkInv, (AEKey)AEFluidKey.of((Fluid)fluidStack.getFluid(), (CompoundTag)fluidStack.getTag()), (long)fluidStack.getAmount(), (IActionSource)MEPatternBufferPartMachine.this.actionSource))) <= 0) continue;
                    fluidStack.shrink(inserted);
                    if (!fluidStack.isEmpty()) continue;
                    this.fluidInventory.remove(fluidStack);
                }
                this.onContentsChanged.run();
            }
        }

        public void pushPattern(IPatternDetails patternDetails, KeyCounter[] inputHolder) {
            patternDetails.pushInputsToExternalInventory(inputHolder, (what, amount) -> {
                AEFluidKey key;
                if (what instanceof AEFluidKey) {
                    key = (AEFluidKey)what;
                    this.addFluid(key, GTMath.saturatedCast(amount));
                }
                if (what instanceof AEItemKey) {
                    key = (AEItemKey)what;
                    this.addItem((AEItemKey)key, amount);
                }
            });
            this.onContentsChanged.run();
        }

        @Nullable
        public List<Ingredient> handleItemInternal(List<Ingredient> left, boolean simulate) {
            Iterator<Ingredient> iterator = left.iterator();
            block0: while (iterator.hasNext()) {
                Ingredient ingredient = iterator.next();
                for (ItemStack stack : this.itemInventory) {
                    ItemStack[] ingredientStacks;
                    if (!ingredient.test(stack)) continue;
                    for (ItemStack ingredientStack : ingredientStacks = ingredient.m_43908_()) {
                        if (!ingredientStack.m_150930_(stack.m_41720_())) continue;
                        int extracted = Math.min(ingredientStack.m_41613_(), stack.m_41613_());
                        if (!simulate) {
                            stack.m_41774_(extracted);
                            if (stack.m_41619_()) {
                                this.itemInventory.remove(stack);
                            }
                            this.onContentsChanged.run();
                        }
                        ingredientStack.m_41774_(extracted);
                        if (!ingredientStack.m_41619_()) continue;
                        iterator.remove();
                        continue block0;
                    }
                }
            }
            return left.isEmpty() ? null : left;
        }

        @Nullable
        public List<FluidIngredient> handleFluidInternal(List<FluidIngredient> left, boolean simulate) {
            Iterator<FluidIngredient> iterator = left.iterator();
            while (iterator.hasNext()) {
                FluidIngredient fluidStack = iterator.next();
                if (fluidStack.isEmpty()) {
                    iterator.remove();
                    continue;
                }
                boolean found = false;
                FluidStack foundStack = null;
                for (FluidStack stack : this.fluidInventory) {
                    if (!fluidStack.test(stack)) continue;
                    found = true;
                    foundStack = stack;
                }
                if (!found) continue;
                int drained = Math.min(foundStack.getAmount(), fluidStack.getAmount());
                if (!simulate) {
                    foundStack.shrink(drained);
                    if (foundStack.isEmpty()) {
                        this.fluidInventory.remove(foundStack);
                    }
                    this.onContentsChanged.run();
                }
                fluidStack.setAmount(fluidStack.getAmount() - drained);
                if (fluidStack.getAmount() > 0) continue;
                iterator.remove();
            }
            return left.isEmpty() ? null : left;
        }

        public CompoundTag serializeNBT() {
            CompoundTag tag = new CompoundTag();
            ListTag itemInventoryTag = new ListTag();
            for (ItemStack itemStack : this.itemInventory) {
                itemInventoryTag.add((Object)GTUtil.saveItemStack(itemStack, new CompoundTag()));
            }
            tag.m_128365_("inventory", (Tag)itemInventoryTag);
            ListTag fluidInventoryTag = new ListTag();
            for (FluidStack fluidStack : this.fluidInventory) {
                fluidInventoryTag.add((Object)fluidStack.writeToNBT(new CompoundTag()));
            }
            tag.m_128365_("fluidInventory", (Tag)fluidInventoryTag);
            return tag;
        }

        public void deserializeNBT(CompoundTag tag) {
            ListTag inv = tag.m_128437_("inventory", 10);
            for (int i = 0; i < inv.size(); ++i) {
                CompoundTag tagItemStack = inv.m_128728_(i);
                ItemStack item = GTUtil.loadItemStack(tagItemStack);
                if (item != null) {
                    if (item.m_41619_()) continue;
                    this.itemInventory.add(item);
                    continue;
                }
                GTCEu.LOGGER.warn("An error occurred while loading contents of ME Crafting Input Bus. This item has been voided: " + String.valueOf(tagItemStack));
            }
            ListTag fluidInv = tag.m_128437_("fluidInventory", 10);
            for (int i = 0; i < fluidInv.size(); ++i) {
                CompoundTag tagFluidStack = fluidInv.m_128728_(i);
                FluidStack fluid = FluidStack.loadFluidStackFromNBT((CompoundTag)tagFluidStack);
                if (fluid != null) {
                    if (fluid.isEmpty()) continue;
                    this.fluidInventory.add(fluid);
                    continue;
                }
                GTCEu.LOGGER.warn("An error occurred while loading contents of ME Crafting Input Bus. This fluid has been voided: " + String.valueOf(tagFluidStack));
            }
        }

        @Generated
        public Runnable getOnContentsChanged() {
            return this.onContentsChanged;
        }

        @Generated
        public void setOnContentsChanged(Runnable onContentsChanged) {
            this.onContentsChanged = onContentsChanged;
        }
    }
}

