/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.data.recipe.misc;

import com.gregtechceu.gtceu.api.data.tag.TagPrefix;
import com.gregtechceu.gtceu.common.data.GTBlocks;
import com.gregtechceu.gtceu.common.data.GTMaterials;
import com.gregtechceu.gtceu.common.data.GTRecipeCategories;
import com.gregtechceu.gtceu.common.data.GTRecipeTypes;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.world.item.DyeColor;

public class DecorationRecipes {
    private DecorationRecipes() {
    }

    public static void init(Consumer<FinishedRecipe> provider) {
        DecorationRecipes.assemblerRecipes(provider);
        DecorationRecipes.dyeRecipes(provider);
    }

    private static void assemblerRecipes(Consumer<FinishedRecipe> provider) {
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("metal_sheet_white", new Object[0]).inputItems(TagPrefix.block, GTMaterials.Concrete, 5).inputItems(TagPrefix.plate, GTMaterials.Iron, 2).circuitMeta(8).outputItems((Supplier)GTBlocks.METAL_SHEETS.get(DyeColor.WHITE), 32).EUt(4L).duration(20).save(provider);
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("large_metal_sheet_white", new Object[0]).inputItems(TagPrefix.block, GTMaterials.Concrete, 5).inputItems(TagPrefix.plate, GTMaterials.Iron, 4).circuitMeta(9).outputItems((Supplier)GTBlocks.LARGE_METAL_SHEETS.get(DyeColor.WHITE), 32).EUt(4L).duration(20).save(provider);
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("studs_black", new Object[0]).inputItems(TagPrefix.block, GTMaterials.Concrete, 3).inputItems(TagPrefix.plate, GTMaterials.Rubber, 3).circuitMeta(8).outputItems((Supplier)GTBlocks.STUDS.get(DyeColor.BLACK), 32).EUt(4L).duration(20).save(provider);
    }

    private static void dyeRecipes(Consumer<FinishedRecipe> provider) {
        for (int i = 0; i < GTMaterials.CHEMICAL_DYES.length; ++i) {
            DyeColor color = DyeColor.values()[i];
            String colorName = color.m_41065_();
            GTRecipeTypes.CHEMICAL_BATH_RECIPES.recipeBuilder("metal_sheet_%s".formatted(colorName), new Object[0]).inputItems(GTBlocks.METAL_SHEETS.get(DyeColor.WHITE).asStack()).inputFluids(GTMaterials.CHEMICAL_DYES[i].getFluid(9)).outputItems((Supplier)GTBlocks.METAL_SHEETS.get(color)).EUt(2L).duration(10).category(GTRecipeCategories.CHEM_DYES).save(provider);
            GTRecipeTypes.CHEMICAL_BATH_RECIPES.recipeBuilder("large_metal_sheet_%s".formatted(colorName), new Object[0]).inputItems(GTBlocks.LARGE_METAL_SHEETS.get(DyeColor.WHITE).asStack()).inputFluids(GTMaterials.CHEMICAL_DYES[i].getFluid(9)).outputItems((Supplier)GTBlocks.LARGE_METAL_SHEETS.get(color)).EUt(2L).duration(10).category(GTRecipeCategories.CHEM_DYES).save(provider);
            GTRecipeTypes.CHEMICAL_BATH_RECIPES.recipeBuilder("studs_%s".formatted(colorName), new Object[0]).inputItems(GTBlocks.STUDS.get(DyeColor.BLACK).asStack()).inputFluids(GTMaterials.CHEMICAL_DYES[i].getFluid(9)).outputItems((Supplier)GTBlocks.STUDS.get(color)).EUt(2L).duration(10).category(GTRecipeCategories.CHEM_DYES).save(provider);
        }
    }
}

