/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.data.recipe.generated;

import com.google.common.collect.ImmutableMap;
import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.api.data.chemical.ChemicalHelper;
import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.api.data.chemical.material.info.MaterialFlags;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.PropertyKey;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.WireProperties;
import com.gregtechceu.gtceu.api.data.chemical.material.stack.UnificationEntry;
import com.gregtechceu.gtceu.api.data.tag.TagPrefix;
import com.gregtechceu.gtceu.common.data.GTItems;
import com.gregtechceu.gtceu.common.data.GTMaterials;
import com.gregtechceu.gtceu.common.data.GTRecipeTypes;
import com.gregtechceu.gtceu.data.recipe.VanillaRecipeHelper;
import com.gregtechceu.gtceu.data.recipe.builder.GTRecipeBuilder;
import com.gregtechceu.gtceu.utils.GTUtil;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.world.item.Item;

public class WireRecipeHandler {
    private static final Map<TagPrefix, Integer> INSULATION_AMOUNT = ImmutableMap.of((Object)TagPrefix.cableGtSingle, (Object)1, (Object)TagPrefix.cableGtDouble, (Object)1, (Object)TagPrefix.cableGtQuadruple, (Object)2, (Object)TagPrefix.cableGtOctal, (Object)3, (Object)TagPrefix.cableGtHex, (Object)5);
    private static final TagPrefix[] wireSizes = new TagPrefix[]{TagPrefix.wireGtDouble, TagPrefix.wireGtQuadruple, TagPrefix.wireGtOctal, TagPrefix.wireGtHex};

    public static void init(Consumer<FinishedRecipe> provider) {
        TagPrefix.wireGtSingle.executeHandler(provider, PropertyKey.WIRE, WireRecipeHandler::processWires);
        TagPrefix.wireGtSingle.executeHandler(provider, PropertyKey.WIRE, WireRecipeHandler::generateCableCovering);
        TagPrefix.wireGtDouble.executeHandler(provider, PropertyKey.WIRE, WireRecipeHandler::generateCableCovering);
        TagPrefix.wireGtQuadruple.executeHandler(provider, PropertyKey.WIRE, WireRecipeHandler::generateCableCovering);
        TagPrefix.wireGtOctal.executeHandler(provider, PropertyKey.WIRE, WireRecipeHandler::generateCableCovering);
        TagPrefix.wireGtHex.executeHandler(provider, PropertyKey.WIRE, WireRecipeHandler::generateCableCovering);
    }

    public static void processWires(TagPrefix wirePrefix, Material material, WireProperties property, Consumer<FinishedRecipe> provider) {
        TagPrefix prefix = material.hasProperty(PropertyKey.INGOT) ? TagPrefix.ingot : (material.hasProperty(PropertyKey.GEM) ? TagPrefix.gem : TagPrefix.dust);
        GTRecipeTypes.EXTRUDER_RECIPES.recipeBuilder("extrude_" + material.getName() + "_wire", new Object[0]).inputItems(prefix, material).notConsumable((Supplier<? extends Item>)GTItems.SHAPE_EXTRUDER_WIRE).outputItems(TagPrefix.wireGtSingle, material, 2).duration((int)material.getMass() * 2).EUt(6L * (long)WireRecipeHandler.getVoltageMultiplier(material)).save(provider);
        GTRecipeTypes.WIREMILL_RECIPES.recipeBuilder("mill_" + material.getName() + "_wire", new Object[0]).inputItems(prefix, material).circuitMeta(1).outputItems(TagPrefix.wireGtSingle, material, 2).duration((int)material.getMass()).EUt(WireRecipeHandler.getVoltageMultiplier(material)).save(provider);
        for (TagPrefix wireSize : wireSizes) {
            int multiplier = (int)(wireSize.getMaterialAmount(material) / 3628800L);
            GTRecipeTypes.WIREMILL_RECIPES.recipeBuilder("mill_" + material.getName() + "_wire_" + multiplier * 2, new Object[0]).inputItems(prefix, material, multiplier).circuitMeta(multiplier * 2).outputItems(wireSize, material).duration((int)material.getMass() * multiplier).EUt(WireRecipeHandler.getVoltageMultiplier(material)).save(provider);
        }
        if (material.hasFlag(MaterialFlags.GENERATE_FINE_WIRE)) {
            GTRecipeTypes.WIREMILL_RECIPES.recipeBuilder("mill_" + material.getName() + "_wire_fine", new Object[0]).inputItems(prefix, material, 1).circuitMeta(3).outputItems(TagPrefix.wireFine, material, 8).duration((int)material.getMass() * 3).EUt(WireRecipeHandler.getVoltageMultiplier(material)).save(provider);
        }
        if (!material.hasFlag(MaterialFlags.NO_WORKING) && material.hasFlag(MaterialFlags.GENERATE_PLATE)) {
            VanillaRecipeHelper.addShapedRecipe(provider, String.format("%s_wire_single", material.getName()), ChemicalHelper.get(TagPrefix.wireGtSingle, material), "Xx", Character.valueOf('X'), new UnificationEntry(TagPrefix.plate, material));
        }
    }

    public static void generateCableCovering(TagPrefix wirePrefix, Material material, WireProperties property, Consumer<FinishedRecipe> provider) {
        GTRecipeBuilder builder;
        if (property.isSuperconductor()) {
            return;
        }
        int cableAmount = (int)(wirePrefix.getMaterialAmount(material) * 2L / 3628800L);
        TagPrefix cablePrefix = TagPrefix.get("cable" + wirePrefix.name().substring(4));
        byte voltageTier = GTUtil.getTierByVoltage(property.getVoltage());
        int insulationAmount = INSULATION_AMOUNT.get(cablePrefix);
        if (voltageTier <= 1) {
            WireRecipeHandler.generateManualRecipe(wirePrefix, material, cablePrefix, cableAmount, provider);
        }
        if (voltageTier <= 4) {
            builder = GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("cover_" + material.getName() + "_" + String.valueOf(wirePrefix) + "_rubber", new Object[0]).EUt(GTValues.VA[0]).duration(100).inputItems(wirePrefix, material).outputItems(cablePrefix, material).inputFluids(GTMaterials.Rubber.getFluid(144 * insulationAmount));
            if (voltageTier == 4) {
                builder.inputItems(TagPrefix.foil, GTMaterials.PolyvinylChloride, insulationAmount);
            }
            builder.save(provider);
        }
        builder = GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("cover_" + material.getName() + "_" + String.valueOf(wirePrefix) + "_silicone", new Object[0]).EUt(GTValues.VA[0]).duration(100).inputItems(wirePrefix, material).outputItems(cablePrefix, material);
        if (voltageTier >= 6) {
            builder.inputItems(TagPrefix.foil, GTMaterials.PolyphenyleneSulfide, insulationAmount);
        }
        if (voltageTier >= 4) {
            builder.inputItems(TagPrefix.foil, GTMaterials.PolyvinylChloride, insulationAmount);
        }
        builder.inputFluids(GTMaterials.SiliconeRubber.getFluid(144 * insulationAmount / 2)).save(provider);
        builder = GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("cover_" + material.getName() + "_" + String.valueOf(wirePrefix) + "_styrene_butadiene", new Object[0]).EUt(GTValues.VA[0]).duration(100).inputItems(wirePrefix, material).outputItems(cablePrefix, material);
        if (voltageTier >= 6) {
            builder.inputItems(TagPrefix.foil, GTMaterials.PolyphenyleneSulfide, insulationAmount);
        }
        if (voltageTier >= 4) {
            builder.inputItems(TagPrefix.foil, GTMaterials.PolyvinylChloride, insulationAmount);
        }
        builder.inputFluids(GTMaterials.StyreneButadieneRubber.getFluid(144 * insulationAmount / 4)).save(provider);
    }

    private static void generateManualRecipe(TagPrefix wirePrefix, Material material, TagPrefix cablePrefix, int cableAmount, Consumer<FinishedRecipe> provider) {
        int insulationAmount = INSULATION_AMOUNT.get(cablePrefix);
        Object[] ingredients = new Object[insulationAmount + 1];
        ingredients[0] = new UnificationEntry(wirePrefix, material);
        for (int i = 1; i <= insulationAmount; ++i) {
            ingredients[i] = ChemicalHelper.get(TagPrefix.plate, GTMaterials.Rubber);
        }
        VanillaRecipeHelper.addShapelessRecipe(provider, String.format("%s_cable_%d", material.getName(), cableAmount), ChemicalHelper.get(cablePrefix, material), ingredients);
        GTRecipeTypes.PACKER_RECIPES.recipeBuilder("cover_" + material.getName() + "_" + String.valueOf(wirePrefix), new Object[0]).inputItems(wirePrefix, material).inputItems(TagPrefix.plate, GTMaterials.Rubber, insulationAmount).outputItems(cablePrefix, material).duration(100).EUt(GTValues.VA[0]).save(provider);
    }

    private static int getVoltageMultiplier(Material material) {
        return material.getBlastTemperature() >= 2800 ? GTValues.VA[1] : GTValues.VA[0];
    }
}

