/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.data.recipe.generated;

import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.api.data.chemical.ChemicalHelper;
import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.api.data.chemical.material.info.MaterialFlags;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.FluidPipeProperties;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.IMaterialProperty;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.ItemPipeProperties;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.PropertyKey;
import com.gregtechceu.gtceu.api.data.chemical.material.stack.UnificationEntry;
import com.gregtechceu.gtceu.api.data.tag.TagPrefix;
import com.gregtechceu.gtceu.common.data.GTBlocks;
import com.gregtechceu.gtceu.common.data.GTItems;
import com.gregtechceu.gtceu.common.data.GTMaterials;
import com.gregtechceu.gtceu.common.data.GTRecipeTypes;
import com.gregtechceu.gtceu.common.pipelike.duct.DuctPipeType;
import com.gregtechceu.gtceu.data.recipe.VanillaRecipeHelper;
import com.gregtechceu.gtceu.utils.FormattingUtil;
import com.gregtechceu.gtceu.utils.GTUtil;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class PipeRecipeHandler {
    public static void init(Consumer<FinishedRecipe> provider) {
        TagPrefix.pipeTinyFluid.executeHandler(provider, PropertyKey.FLUID_PIPE, PipeRecipeHandler::processPipeTiny);
        TagPrefix.pipeSmallFluid.executeHandler(provider, PropertyKey.FLUID_PIPE, PipeRecipeHandler::processPipeSmall);
        TagPrefix.pipeNormalFluid.executeHandler(provider, PropertyKey.FLUID_PIPE, PipeRecipeHandler::processPipeNormal);
        TagPrefix.pipeLargeFluid.executeHandler(provider, PropertyKey.FLUID_PIPE, PipeRecipeHandler::processPipeLarge);
        TagPrefix.pipeHugeFluid.executeHandler(provider, PropertyKey.FLUID_PIPE, PipeRecipeHandler::processPipeHuge);
        TagPrefix.pipeQuadrupleFluid.executeHandler(provider, PropertyKey.FLUID_PIPE, PipeRecipeHandler::processPipeQuadruple);
        TagPrefix.pipeNonupleFluid.executeHandler(provider, PropertyKey.FLUID_PIPE, PipeRecipeHandler::processPipeNonuple);
        TagPrefix.pipeSmallItem.executeHandler(provider, PropertyKey.ITEM_PIPE, PipeRecipeHandler::processPipeSmall);
        TagPrefix.pipeNormalItem.executeHandler(provider, PropertyKey.ITEM_PIPE, PipeRecipeHandler::processPipeNormal);
        TagPrefix.pipeLargeItem.executeHandler(provider, PropertyKey.ITEM_PIPE, PipeRecipeHandler::processPipeLarge);
        TagPrefix.pipeHugeItem.executeHandler(provider, PropertyKey.ITEM_PIPE, PipeRecipeHandler::processPipeHuge);
        TagPrefix.pipeSmallRestrictive.executeHandler(provider, PropertyKey.ITEM_PIPE, PipeRecipeHandler::processRestrictivePipe);
        TagPrefix.pipeNormalRestrictive.executeHandler(provider, PropertyKey.ITEM_PIPE, PipeRecipeHandler::processRestrictivePipe);
        TagPrefix.pipeLargeRestrictive.executeHandler(provider, PropertyKey.ITEM_PIPE, PipeRecipeHandler::processRestrictivePipe);
        TagPrefix.pipeHugeRestrictive.executeHandler(provider, PropertyKey.ITEM_PIPE, PipeRecipeHandler::processRestrictivePipe);
        PipeRecipeHandler.addDuctRecipes(provider, GTMaterials.Steel, 2);
        PipeRecipeHandler.addDuctRecipes(provider, GTMaterials.StainlessSteel, 4);
        PipeRecipeHandler.addDuctRecipes(provider, GTMaterials.TungstenSteel, 8);
    }

    private static void processRestrictivePipe(TagPrefix pipePrefix, Material material, ItemPipeProperties property, Consumer<FinishedRecipe> provider) {
        TagPrefix unrestrictive;
        if (pipePrefix == TagPrefix.pipeSmallRestrictive) {
            unrestrictive = TagPrefix.pipeSmallItem;
        } else if (pipePrefix == TagPrefix.pipeNormalRestrictive) {
            unrestrictive = TagPrefix.pipeNormalItem;
        } else if (pipePrefix == TagPrefix.pipeLargeRestrictive) {
            unrestrictive = TagPrefix.pipeLargeItem;
        } else if (pipePrefix == TagPrefix.pipeHugeRestrictive) {
            unrestrictive = TagPrefix.pipeHugeItem;
        } else {
            return;
        }
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("assemble_" + material.getName() + "_" + pipePrefix.name, new Object[0]).inputItems(unrestrictive, material).inputItems(TagPrefix.ring, GTMaterials.Iron, 2).outputItems(pipePrefix, material).duration(20).EUt(GTValues.VA[0]).save(provider);
        VanillaRecipeHelper.addShapedRecipe(provider, FormattingUtil.toLowerCaseUnder(pipePrefix.toString() + "_" + material.getName()), ChemicalHelper.get(pipePrefix, material), "PR", "Rh", Character.valueOf('P'), new UnificationEntry(unrestrictive, material), Character.valueOf('R'), ChemicalHelper.get(TagPrefix.ring, GTMaterials.Iron));
    }

    private static void processPipeTiny(TagPrefix pipePrefix, Material material, IMaterialProperty property, Consumer<FinishedRecipe> provider) {
        if (material.hasProperty(PropertyKey.WOOD)) {
            return;
        }
        ItemStack pipeStack = ChemicalHelper.get(pipePrefix, material);
        GTRecipeTypes.EXTRUDER_RECIPES.recipeBuilder("extrude_" + material.getName() + "_tiny_pipe", new Object[0]).inputItems(TagPrefix.ingot, material, 1).notConsumable((Supplier<? extends Item>)GTItems.SHAPE_EXTRUDER_PIPE_TINY).outputItems(GTUtil.copyAmount(2, pipeStack)).duration((int)material.getMass()).EUt(6L * (long)PipeRecipeHandler.getVoltageMultiplier(material)).save(provider);
        if (material.hasFlag(MaterialFlags.NO_SMASHING)) {
            GTRecipeTypes.EXTRUDER_RECIPES.recipeBuilder("extrude_" + material.getName() + "_tiny_pipe_dust", new Object[0]).inputItems(TagPrefix.dust, material, 1).notConsumable((Supplier<? extends Item>)GTItems.SHAPE_EXTRUDER_PIPE_TINY).outputItems(GTUtil.copyAmount(2, pipeStack)).duration((int)material.getMass()).EUt(6L * (long)PipeRecipeHandler.getVoltageMultiplier(material)).save(provider);
        } else {
            VanillaRecipeHelper.addShapedRecipe(provider, String.format("tiny_%s_pipe", material.getName()), GTUtil.copyAmount(2, pipeStack), " s ", "hXw", Character.valueOf('X'), new UnificationEntry(TagPrefix.plate, material));
        }
    }

    private static void processPipeSmall(TagPrefix pipePrefix, Material material, IMaterialProperty property, Consumer<FinishedRecipe> provider) {
        if (material.hasProperty(PropertyKey.WOOD)) {
            return;
        }
        ItemStack pipeStack = ChemicalHelper.get(pipePrefix, material);
        GTRecipeTypes.EXTRUDER_RECIPES.recipeBuilder("extrude_" + material.getName() + "_small_pipe", new Object[0]).inputItems(TagPrefix.ingot, material, 1).notConsumable((Supplier<? extends Item>)GTItems.SHAPE_EXTRUDER_PIPE_SMALL).outputItems(pipeStack).duration((int)material.getMass()).EUt(6L * (long)PipeRecipeHandler.getVoltageMultiplier(material)).save(provider);
        if (material.hasFlag(MaterialFlags.NO_SMASHING)) {
            GTRecipeTypes.EXTRUDER_RECIPES.recipeBuilder("extrude_" + material.getName() + "_small_pipe_dust", new Object[0]).inputItems(TagPrefix.dust, material, 1).notConsumable((Supplier<? extends Item>)GTItems.SHAPE_EXTRUDER_PIPE_SMALL).outputItems(pipeStack).duration((int)material.getMass()).EUt(6L * (long)PipeRecipeHandler.getVoltageMultiplier(material)).save(provider);
        } else {
            VanillaRecipeHelper.addShapedRecipe(provider, String.format("small_%s_pipe", material.getName()), pipeStack, "wXh", Character.valueOf('X'), new UnificationEntry(TagPrefix.plate, material));
        }
    }

    private static void processPipeNormal(TagPrefix pipePrefix, Material material, IMaterialProperty property, Consumer<FinishedRecipe> provider) {
        if (material.hasProperty(PropertyKey.WOOD)) {
            return;
        }
        ItemStack pipeStack = ChemicalHelper.get(pipePrefix, material);
        GTRecipeTypes.EXTRUDER_RECIPES.recipeBuilder("extrude_" + material.getName() + "_pipe", new Object[0]).inputItems(TagPrefix.ingot, material, 3).notConsumable((Supplier<? extends Item>)GTItems.SHAPE_EXTRUDER_PIPE_NORMAL).outputItems(pipeStack).duration((int)material.getMass() * 3).EUt(6L * (long)PipeRecipeHandler.getVoltageMultiplier(material)).save(provider);
        if (material.hasFlag(MaterialFlags.NO_SMASHING)) {
            GTRecipeTypes.EXTRUDER_RECIPES.recipeBuilder("extrude_" + material.getName() + "_pipe_dust", new Object[0]).inputItems(TagPrefix.dust, material, 3).notConsumable((Supplier<? extends Item>)GTItems.SHAPE_EXTRUDER_PIPE_NORMAL).outputItems(pipeStack).duration((int)material.getMass() * 3).EUt(6L * (long)PipeRecipeHandler.getVoltageMultiplier(material)).save(provider);
        } else {
            VanillaRecipeHelper.addShapedRecipe(provider, String.format("medium_%s_pipe", material.getName()), pipeStack, "XXX", "w h", Character.valueOf('X'), new UnificationEntry(TagPrefix.plate, material));
        }
    }

    private static void processPipeLarge(TagPrefix pipePrefix, Material material, IMaterialProperty property, Consumer<FinishedRecipe> provider) {
        if (material.hasProperty(PropertyKey.WOOD)) {
            return;
        }
        ItemStack pipeStack = ChemicalHelper.get(pipePrefix, material);
        GTRecipeTypes.EXTRUDER_RECIPES.recipeBuilder("extrude_" + material.getName() + "_large_pipe", new Object[0]).inputItems(TagPrefix.ingot, material, 6).notConsumable((Supplier<? extends Item>)GTItems.SHAPE_EXTRUDER_PIPE_LARGE).outputItems(pipeStack).duration((int)material.getMass() * 6).EUt(6L * (long)PipeRecipeHandler.getVoltageMultiplier(material)).save(provider);
        if (material.hasFlag(MaterialFlags.NO_SMASHING)) {
            GTRecipeTypes.EXTRUDER_RECIPES.recipeBuilder("extrude_" + material.getName() + "_large_pipe_dust", new Object[0]).inputItems(TagPrefix.dust, material, 6).notConsumable((Supplier<? extends Item>)GTItems.SHAPE_EXTRUDER_PIPE_LARGE).outputItems(pipeStack).duration((int)material.getMass() * 6).EUt(6L * (long)PipeRecipeHandler.getVoltageMultiplier(material)).save(provider);
        } else {
            VanillaRecipeHelper.addShapedRecipe(provider, String.format("large_%s_pipe", material.getName()), pipeStack, "XXX", "w h", "XXX", Character.valueOf('X'), new UnificationEntry(TagPrefix.plate, material));
        }
    }

    private static void processPipeHuge(TagPrefix pipePrefix, Material material, IMaterialProperty property, Consumer<FinishedRecipe> provider) {
        if (material.hasProperty(PropertyKey.WOOD)) {
            return;
        }
        ItemStack pipeStack = ChemicalHelper.get(pipePrefix, material);
        GTRecipeTypes.EXTRUDER_RECIPES.recipeBuilder("extrude_" + material.getName() + "_huge_pipe", new Object[0]).inputItems(TagPrefix.ingot, material, 12).notConsumable((Supplier<? extends Item>)GTItems.SHAPE_EXTRUDER_PIPE_HUGE).outputItems(pipeStack).duration((int)material.getMass() * 24).EUt(6L * (long)PipeRecipeHandler.getVoltageMultiplier(material)).save(provider);
        if (material.hasFlag(MaterialFlags.NO_SMASHING)) {
            GTRecipeTypes.EXTRUDER_RECIPES.recipeBuilder("extrude_" + material.getName() + "_huge_pipe_dust", new Object[0]).inputItems(TagPrefix.dust, material, 12).notConsumable((Supplier<? extends Item>)GTItems.SHAPE_EXTRUDER_PIPE_HUGE).outputItems(pipeStack).duration((int)material.getMass() * 24).EUt(6L * (long)PipeRecipeHandler.getVoltageMultiplier(material)).save(provider);
        } else if (TagPrefix.plateDouble.doGenerateItem(material)) {
            VanillaRecipeHelper.addShapedRecipe(provider, String.format("huge_%s_pipe", material.getName()), pipeStack, "XXX", "w h", "XXX", Character.valueOf('X'), new UnificationEntry(TagPrefix.plateDouble, material));
        }
    }

    private static void processPipeQuadruple(TagPrefix pipePrefix, Material material, FluidPipeProperties property, Consumer<FinishedRecipe> provider) {
        if (material.hasProperty(PropertyKey.WOOD)) {
            return;
        }
        ItemStack smallPipe = ChemicalHelper.get(TagPrefix.pipeSmallFluid, material);
        ItemStack quadPipe = ChemicalHelper.get(pipePrefix, material);
        VanillaRecipeHelper.addShapedRecipe(provider, String.format("quadruple_%s_pipe", material.getName()), quadPipe, "XX", "XX", Character.valueOf('X'), smallPipe);
        GTRecipeTypes.PACKER_RECIPES.recipeBuilder("package_" + material.getName() + "_quadruple_pipe", new Object[0]).inputItems(GTUtil.copyAmount(4, smallPipe)).circuitMeta(4).outputItems(quadPipe).duration(30).EUt(GTValues.VA[0]).save(provider);
    }

    private static void processPipeNonuple(TagPrefix pipePrefix, Material material, FluidPipeProperties property, Consumer<FinishedRecipe> provider) {
        if (material.hasProperty(PropertyKey.WOOD)) {
            return;
        }
        ItemStack smallPipe = ChemicalHelper.get(TagPrefix.pipeSmallFluid, material);
        ItemStack nonuplePipe = ChemicalHelper.get(pipePrefix, material);
        VanillaRecipeHelper.addShapedRecipe(provider, String.format("nonuple_%s_pipe", material.getName()), nonuplePipe, "XXX", "XXX", "XXX", Character.valueOf('X'), smallPipe);
        GTRecipeTypes.PACKER_RECIPES.recipeBuilder("package_" + material.getName() + "_nonuple_pipe", new Object[0]).inputItems(GTUtil.copyAmount(9, smallPipe)).circuitMeta(9).outputItems(nonuplePipe).duration(40).EUt(GTValues.VA[0]).save(provider);
    }

    private static void addDuctRecipes(Consumer<FinishedRecipe> provider, Material material, int outputAmount) {
        VanillaRecipeHelper.addShapedRecipe(provider, "small_duct_%s".formatted(material.getName()), GTBlocks.DUCT_PIPES[DuctPipeType.SMALL.ordinal()].asStack(outputAmount * 2), "w", "X", "h", Character.valueOf('X'), new UnificationEntry(TagPrefix.plate, material));
        VanillaRecipeHelper.addShapedRecipe(provider, "medium_duct_%s".formatted(material.getName()), GTBlocks.DUCT_PIPES[DuctPipeType.NORMAL.ordinal()].asStack(outputAmount), " X ", "wXh", " X ", Character.valueOf('X'), new UnificationEntry(TagPrefix.plate, material));
        VanillaRecipeHelper.addShapedRecipe(provider, "large_duct_%s".formatted(material.getName()), GTBlocks.DUCT_PIPES[DuctPipeType.LARGE.ordinal()].asStack(outputAmount), "XwX", "X X", "XhX", Character.valueOf('X'), new UnificationEntry(TagPrefix.plate, material));
        VanillaRecipeHelper.addShapedRecipe(provider, "huge_duct_%s".formatted(material.getName()), GTBlocks.DUCT_PIPES[DuctPipeType.HUGE.ordinal()].asStack(outputAmount), "XwX", "X X", "XhX", Character.valueOf('X'), new UnificationEntry(TagPrefix.plateDouble, material));
    }

    private static int getVoltageMultiplier(Material material) {
        return material.getBlastTemperature() >= 2800 ? GTValues.VA[1] : GTValues.VA[0];
    }
}

