/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.data.pack;

import com.google.common.collect.Sets;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.addon.AddonFinder;
import com.gregtechceu.gtceu.api.addon.IGTAddon;
import com.gregtechceu.gtceu.common.data.GTRecipes;
import com.gregtechceu.gtceu.config.ConfigHolder;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.SharedConstants;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.metadata.MetadataSectionSerializer;
import net.minecraft.server.packs.metadata.pack.PackMetadataSection;
import net.minecraft.server.packs.resources.IoSupplier;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ParametersAreNonnullByDefault
public class GTDynamicDataPack
implements PackResources {
    protected static final ObjectSet<String> SERVER_DOMAINS = new ObjectOpenHashSet();
    protected static final Map<ResourceLocation, byte[]> DATA = new HashMap<ResourceLocation, byte[]>();
    private final String name;

    public GTDynamicDataPack(String name) {
        this(name, AddonFinder.getAddons().stream().map(IGTAddon::addonModId).collect(Collectors.toSet()));
    }

    public GTDynamicDataPack(String name, Collection<String> domains) {
        this.name = name;
        SERVER_DOMAINS.addAll(domains);
    }

    public static void clearServer() {
        DATA.clear();
    }

    public static void addRecipe(FinishedRecipe recipe) {
        JsonObject recipeJson = recipe.m_125966_();
        Path parent = GTCEu.getGameDir().resolve("gtceu/dumped/data");
        ResourceLocation recipeId = recipe.m_6445_();
        if (ConfigHolder.INSTANCE.dev.dumpRecipes) {
            GTDynamicDataPack.writeJson(recipeId, "recipes", parent, (JsonElement)recipeJson);
        }
        DATA.put(GTDynamicDataPack.getRecipeLocation(recipeId), recipeJson.toString().getBytes(StandardCharsets.UTF_8));
        if (recipe.m_5860_() != null) {
            JsonObject advancement = recipe.m_5860_();
            if (ConfigHolder.INSTANCE.dev.dumpRecipes) {
                GTDynamicDataPack.writeJson(recipe.m_6448_(), "advancements", parent, (JsonElement)advancement);
            }
            DATA.put(GTDynamicDataPack.getAdvancementLocation(Objects.requireNonNull(recipe.m_6448_())), advancement.toString().getBytes(StandardCharsets.UTF_8));
        }
    }

    @ApiStatus.Internal
    public static void writeJson(ResourceLocation id, @Nullable String subdir, Path parent, JsonElement json) {
        try {
            Path file = subdir != null ? parent.resolve(id.m_135827_()).resolve(subdir).resolve(id.m_135815_() + ".json") : parent.resolve(id.m_135827_()).resolve(id.m_135815_());
            Files.createDirectories(file.getParent(), new FileAttribute[0]);
            try (OutputStream output = Files.newOutputStream(file, new OpenOption[0]);){
                output.write(json.toString().getBytes());
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addAdvancement(ResourceLocation loc, JsonObject obj) {
        ResourceLocation l = GTDynamicDataPack.getAdvancementLocation(loc);
        Map<ResourceLocation, byte[]> map = DATA;
        synchronized (map) {
            DATA.put(l, obj.toString().getBytes(StandardCharsets.UTF_8));
        }
    }

    @Nullable
    public IoSupplier<InputStream> m_8017_(String ... elements) {
        return null;
    }

    public IoSupplier<InputStream> m_214146_(PackType type, ResourceLocation location) {
        if (type == PackType.SERVER_DATA) {
            byte[] byteArray = DATA.get(location);
            if (byteArray != null) {
                return () -> new ByteArrayInputStream(byteArray);
            }
            return null;
        }
        return null;
    }

    public void m_8031_(PackType packType, String namespace, String path, PackResources.ResourceOutput resourceOutput) {
        if (packType == PackType.SERVER_DATA) {
            if (!((String)path).endsWith("/")) {
                path = (String)path + "/";
            }
            String finalPath = path;
            DATA.keySet().stream().filter(Objects::nonNull).filter(loc -> loc.m_135815_().startsWith(finalPath)).forEach(id -> {
                IoSupplier<InputStream> resource = this.m_214146_(packType, (ResourceLocation)id);
                if (resource != null) {
                    resourceOutput.accept(id, resource);
                }
            });
        }
    }

    public Set<String> m_5698_(PackType type) {
        return type == PackType.SERVER_DATA ? SERVER_DOMAINS : Set.of();
    }

    @Nullable
    public <T> T m_5550_(MetadataSectionSerializer<T> metaReader) {
        if (metaReader == PackMetadataSection.f_243696_) {
            return (T)new PackMetadataSection((Component)Component.m_237113_((String)"GTCEu dynamic data"), SharedConstants.m_183709_().m_264084_(PackType.SERVER_DATA));
        }
        if (metaReader.m_7991_().equals("filter")) {
            JsonObject filter = new JsonObject();
            JsonArray block = new JsonArray();
            GTRecipes.RECIPE_FILTERS.forEach(id -> {
                JsonObject entry = new JsonObject();
                entry.addProperty("namespace", "^" + id.m_135827_().replaceAll("[\\W]", "\\\\$0") + "$");
                entry.addProperty("path", "^recipes/" + id.m_135815_().replaceAll("[\\W]", "\\\\$0") + "\\.json$");
                block.add((JsonElement)entry);
            });
            filter.add("block", (JsonElement)block);
            return (T)metaReader.m_6322_(filter);
        }
        return null;
    }

    public String m_5542_() {
        return this.name;
    }

    public void close() {
    }

    public static ResourceLocation getRecipeLocation(ResourceLocation recipeId) {
        return new ResourceLocation(recipeId.m_135827_(), String.join((CharSequence)"", "recipes/", recipeId.m_135815_(), ".json"));
    }

    public static ResourceLocation getAdvancementLocation(ResourceLocation advancementId) {
        return new ResourceLocation(advancementId.m_135827_(), String.join((CharSequence)"", "advancements/", advancementId.m_135815_(), ".json"));
    }

    public static ResourceLocation getTagLocation(String identifier, ResourceLocation tagId) {
        return new ResourceLocation(tagId.m_135827_(), String.join((CharSequence)"", "tags/", identifier, "/", tagId.m_135815_(), ".json"));
    }

    static {
        SERVER_DOMAINS.addAll((Collection)Sets.newHashSet((Object[])new String[]{"gtceu", "minecraft", "forge", "c"}));
    }
}

